/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableNameUtil;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.sabre.CostCodesHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CreditLimitInfo;
import com.gridnine.xtrip.common.model.profile.GdsReferenceIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.system.model.PersonCodeSettings;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.Callback;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberGenerator;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberHelper;
import com.gridnine.xtrip.server.model.helpers.PersonProfileLockHelper;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.LoggerFactory;

public class ProfilesInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 0.5;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (Person.class.getName().equals(data.getEntityType().getName())) {
            this.deleteAccount(((Person)data.getEntity()).getLoginName());
        }
    }

    private void deleteAccount(String loginName) throws Exception {
        if (TextUtil.isBlank((String)loginName) || !ProfileHelper.SABRE_LOGIN_PATTERN.matcher(loginName).matches()) {
            return;
        }
        UserAccount account = (UserAccount)AssetsStorage.get().find(UserAccount.class, UserAccount.Property.loginName.name(), (Object)loginName);
        AclUser aclUser = (AclUser)AssetsStorage.get().find(AclUser.class, AclUser.Property.id.name(), (Object)loginName);
        if (aclUser == null) {
            AssetsStorage.get().delete((BaseAsset)account, true);
        }
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (Organization.class.getName().equals(data.getEntityType().getName())) {
            Organization organization = (Organization)data.getEntity();
            organization.getCostCodes().stream().map(CostCode::getValue).filter(Objects::nonNull).filter(CostCodesHelper::isCostCodeContainsUnsupportedSymbols).findFirst().ifPresent(value -> {
                throw Xeption.forEndUser((String)Messages.UnsupportedSymbolsInUdidValue, (Object[])new Object[]{CostCodesHelper.UNSUPPORTED_SYMBOLS, value});
            });
            this.updateCreditLimits(organization.getFinanceRestrictions().getCreditLimits());
        } else if (SalesPoint.class.getName().equals(data.getEntityType().getName())) {
            this.updatePersonIndex(data, ss);
        } else if (Person.class.getName().equals(data.getEntityType().getName())) {
            Person person = (Person)data.getEntity();
            this.updateAccount(person.getLoginName(), PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)person, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
            this.updateCreditLimits(person.getFinanceRestrictions().getCreditLimits());
            this.generatePersonCode(person);
        }
    }

    private void updateAccount(String loginName, String fullName) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)UserAccount.Property.loginName.name(), (Object)loginName));
        for (UserAccount account : AssetsStorage.get().search(UserAccount.class, query).getData()) {
            if (!(fullName != null ? !fullName.equals(account.getFullName()) : account.getFullName() != null)) continue;
            account.setFullName(fullName);
            AssetsStorage.get().save((BaseAsset)account);
        }
    }

    private void updateCreditLimits(List<CreditLimitInfo> creditLimitInfos) throws Exception {
        for (CreditLimitInfo creditLimitInfo : creditLimitInfos) {
            creditLimitInfo.setTerminalCreditDateStart(MiscUtil.clearTime((Date)creditLimitInfo.getTerminalCreditDateStart(), (boolean)false, (boolean)false, (boolean)true, (boolean)true));
            creditLimitInfo.setTerminalCreditDateEnd(MiscUtil.clearTime((Date)creditLimitInfo.getTerminalCreditDateEnd(), (boolean)false, (boolean)false, (boolean)true, (boolean)true));
        }
    }

    private void updatePersonIndex(EntityContainer<SalesPoint> salesPointContainer, SessionCallback ss) {
        EntityContainer oldSalesPointContainer = LogicalStorage.get().getEntityStorage().getLocalOperationContext(salesPointContainer.toReference()).getOldCtr();
        if (oldSalesPointContainer != null && MiscUtil.equals((Object)((SalesPoint)salesPointContainer.getEntity()).getAgency(), (Object)((SalesPoint)oldSalesPointContainer.getEntity()).getAgency())) {
            return;
        }
        final HashSet<EntityReference> relatedPersons = new HashSet<EntityReference>();
        SearchQuery searchQuery = new SearchQuery();
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsReferenceIndex.Property.salesPoint.name(), (Object)salesPointContainer.toReference()));
        List relatedGdsIndexes = EntityStorage.get().search(GdsReferenceIndex.class, searchQuery).getData();
        for (GdsReferenceIndex relatedGdsIndex : relatedGdsIndexes) {
            relatedPersons.add(relatedGdsIndex.getSource());
        }
        ss.addCallback(new Callback(){
            private static final long serialVersionUID = -7864016444276474082L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(SessionCallback ss1) {
                PersonProfileLockHelper personProfileLockHelper = PersonProfileLockHelper.fromReferences(relatedPersons);
                while (personProfileLockHelper.hasNext()) {
                    EntityContainer<Person> relatedPerson = null;
                    try {
                        EntityReference personEntityReference;
                        personProfileLockHelper.lockNextContainer();
                        relatedPerson = personProfileLockHelper.getCurrentPersonContainer();
                        EntityReference entityReference = personEntityReference = relatedPerson != null ? relatedPerson.toReference() : null;
                        if (personProfileLockHelper.isLocked()) {
                            LoggerFactory.getLogger(this.getClass()).debug("rebuilding index of " + personEntityReference);
                            LogicalStorage.get().getEntityStorage().updateIndexes(relatedPerson, relatedPerson, Collections.singletonList(GdsReferenceIndex.class), false);
                            continue;
                        }
                        throw new Exception("Unable to lock container");
                    }
                    catch (Exception e) {
                        LoggerFactory.getLogger(this.getClass()).error("unable to rebuild index of " + relatedPerson, (Throwable)e);
                    }
                    finally {
                        if (!personProfileLockHelper.isLocked()) continue;
                        personProfileLockHelper.unlockCurrentContainer();
                    }
                }
            }
        });
    }

    private void generatePersonCode(final Person person) throws Exception {
        PersonCodeSettings settings;
        EntityContainer settingsCtr;
        if (TextUtil.isBlank((String)person.getCode()) && (settingsCtr = EntityStorage.get().load(PersonCodeSettings.class, UniqueSettingsRegistry.get().getUidByClassName(PersonCodeSettings.class.getName()))) != null && (settings = (PersonCodeSettings)settingsCtr.getEntity()).isGenerateCode() && person.getTypes().contains(PersonType.PASSENGER) && !person.getTypes().contains(PersonType.AGENT)) {
            CompositeNumber compNum = new CompositeNumber(){

                public void setNumberSuffix(String value) {
                }

                public void setNumberPrefix(String value) {
                }

                public void setNumber(String value) {
                    person.setCode(value);
                }

                public String getNumberSuffix() {
                    return null;
                }

                public String getNumberPrefix() {
                    return null;
                }

                public String getNumber() {
                    return person.getCode();
                }
            };
            ((SequenceNumberHelper)Environment.getPublished(SequenceNumberHelper.class)).generateInc(compNum, Person.class.getName(), null);
            if (TextUtil.nonBlank((String)person.getCode())) {
                String code;
                SequenceNumberGenerator engine = (SequenceNumberGenerator)Environment.getPublished(SequenceNumberGenerator.class);
                DecimalFormat decimalFormat = new DecimalFormat(engine.getFormat(compNum, Person.class.getName()));
                BigInteger number = new BigInteger(person.getCode());
                while (true) {
                    code = String.format("%s%s%s", TextUtil.nonNullStr((String)settings.getPrefix()), TextUtil.nonNullStr((String)decimalFormat.format(number)), TextUtil.nonNullStr((String)settings.getSuffix()));
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.code.name(), (Object)code));
                    query.setLimit(1);
                    query.setResultMode(ResultMode.COUNT_ONLY);
                    if (EntityStorage.get().search(PersonIndex.class, query).getTotalCount() == 0) break;
                    number = number.add(BigInteger.ONE);
                }
                person.setCode(code);
            }
        }
    }
}

