/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.licence.LicenceServerProvider;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.licence2.AppConfiguration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ProtectedEntitiesInterceptor
implements EntityInterceptor {
    private static final Set<String> SYSTEM_USERS = new HashSet<String>(Collections.singletonList("system"));
    private static final Set<String> SYSTEM_DATA_SOURCES = new HashSet<String>(Arrays.asList("fx-applyRules", "fx-rollback"));

    public double getPriority() {
        return 2.147483647E9;
    }

    public boolean isSystem() {
        return true;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (Environment.isPublished(LicenceServerProvider.class) || SYSTEM_USERS.contains(data.getModifiedBy()) || SYSTEM_DATA_SOURCES.contains(data.getVersionInfo().getDataSource())) {
            return;
        }
        this.checkProtectedEntities("\u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435", data);
        if (!AppConfiguration.get().isCollectTechnicalFee()) {
            return;
        }
        if (BookingFile.class.equals((Object)data.getEntityType())) {
            EntityContainer oldCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
            if (oldCtr == null) {
                return;
            }
            Map oldProdMap = ((BookingFile)oldCtr.getEntity()).getReservations().stream().flatMap(res -> res.getProducts().stream()).distinct().collect(Collectors.toMap(BaseIdentity::getUid, Function.identity()));
            BookingFile bookingFile = (BookingFile)data.getEntity();
            bookingFile.getReservations().stream().flatMap(res -> res.getProducts().stream()).distinct().forEach(bp -> {
                BaseProduct oldProd = (BaseProduct)oldProdMap.get(bp.getUid());
                if (oldProd != null) {
                    boolean isTechnicalProviderContractApplied;
                    EntityReference techProvider;
                    EntityReference oldTechProvider = GeneralProductHelper.getTechnicalProvider((BaseProduct)oldProd);
                    if (!Objects.equals(oldTechProvider, techProvider = GeneralProductHelper.getTechnicalProvider((BaseProduct)bp))) {
                        throw Xeption.forEndUser((String)"\u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e", (Object[])new Object[0]);
                    }
                    if (oldProd.getSalesOriginProvider() != null && !Objects.equals(oldProd.getSalesOriginProvider(), bp.getSalesOriginProvider())) {
                        throw Xeption.forEndUser((String)"\u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 sales origin provider \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e", (Object[])new Object[0]);
                    }
                    if (oldProd.getSalesOriginContent() != null && !Objects.equals(oldProd.getSalesOriginContent(), bp.getSalesOriginContent())) {
                        throw Xeption.forEndUser((String)"\u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 sales origin content \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e", (Object[])new Object[0]);
                    }
                    boolean bl = isTechnicalProviderContractApplied = oldTechProvider != null && GeneralProductHelper.getUnmodifiableContractRelations((BaseProduct)oldProd).stream().anyMatch(rel -> Objects.equals(GeneralProductHelper.getContractType((EntityReference)rel.getDescription()), ContractType.TECHNICAL_PROVIDER));
                    if (isTechnicalProviderContractApplied && this.isTechnicalProviderContractShouldBeApplied((BaseProduct)bp) && GeneralProductHelper.getUnmodifiableContractRelations((BaseProduct)bp).stream().noneMatch(rel -> Objects.equals(GeneralProductHelper.getContractType((EntityReference)rel.getDescription()), ContractType.TECHNICAL_PROVIDER))) {
                        throw Xeption.forEndUser((String)"\u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0441 \u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0438\u043c \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u043e\u043c \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430 \u043f\u0440\u0438\u043c\u0435\u043d\u0451\u043d\u043d\u044b\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e", (Object[])new Object[0]);
                    }
                    Map oldGpcMap = GeneralProductHelper.getCommissions((BaseProduct)oldProd, (ContractType)ContractType.TECHNICAL_PROVIDER).stream().collect(Collectors.toMap(gpc -> gpc.getCommissionProperties().getCaption(), Function.identity()));
                    if (!GeneralProductHelper.getCommissions((BaseProduct)bp, (ContractType)ContractType.TECHNICAL_PROVIDER).stream().allMatch(gpc -> {
                        GeneralProductCommission oldGpc = (GeneralProductCommission)oldGpcMap.get(gpc.getCommissionProperties().getCaption());
                        return oldGpc != null && MoneyHelper.isSame((Money)oldGpc.getAmount(), (Money)gpc.getAmount()) && Objects.equals(oldGpc.getEquivalentAmount(), gpc.getEquivalentAmount()) && Objects.equals(oldGpc.getContractEquivalentAmount(), gpc.getContractEquivalentAmount());
                    })) {
                        throw Xeption.forEndUser((String)"\u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0439 \u0438 \u0441\u0431\u043e\u0440\u043e\u0432 \u0438\u0437 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0441 \u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0438\u043c \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u043e\u043c \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e", (Object[])new Object[0]);
                    }
                }
            });
        }
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (Environment.isPublished(LicenceServerProvider.class)) {
            return;
        }
        this.checkProtectedEntities("\u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435", data);
    }

    private void checkProtectedEntities(String action, EntityContainer<?> data) {
        if ("sabre_technical_provider_profile".equals(data.getUid())) {
            throw Xeption.forEndUser((String)String.format("%s \u043f\u0440\u043e\u0444\u0438\u043b\u044f \u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e", action), (Object[])new Object[0]);
        }
        if ("sabre_technical_provider_contract".equals(data.getUid())) {
            throw Xeption.forEndUser((String)String.format("%s \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0441 \u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0438\u043c \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u043e\u043c \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e", action), (Object[])new Object[0]);
        }
        if ("technical_fee_system_model_contract".equals(data.getUid())) {
            throw Xeption.forEndUser((String)String.format("%s \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b \u043f\u0440\u0430\u0432\u0438\u043b \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e", action), (Object[])new Object[0]);
        }
        if ("technical_fee_fee_properties".equals(data.getUid())) {
            throw Xeption.forEndUser((String)String.format("%s \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0445 \u0441\u0432\u043e\u0439\u0441\u0442\u0432 \u0441\u0431\u043e\u0440\u0430 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e", action), (Object[])new Object[0]);
        }
        if ("agency_bonus_commission_properties".equals(data.getUid())) {
            throw Xeption.forEndUser((String)String.format("%s \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0445 \u0441\u0432\u043e\u0439\u0441\u0442\u0432 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e", action), (Object[])new Object[0]);
        }
    }

    private boolean isTechnicalProviderContractShouldBeApplied(BaseProduct product) {
        Date issueDate = GeneralProductHelper.getProductDate((BaseProduct)product);
        EntityReference sabreContractRef = ProfileHelper.findTechnicalProviderContract();
        EntityContainer sabreContractCtr = EntityStorage.get().resolve(sabreContractRef);
        if (sabreContractCtr != null) {
            return MiscUtil.isBetween((Date)((Contract)sabreContractCtr.getEntity()).getStartDate(), (Date)((Contract)sabreContractCtr.getEntity()).getEndDate(), (Date)MiscUtil.clearTime((Date)issueDate));
        }
        return true;
    }
}

