/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberHelper;
import com.gridnine.xtrip.server.model.interceptors.SequenceNumberInterceptor;

public class ReceiptSequenceNumberInterceptor
extends SequenceNumberInterceptor {
    @Override
    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (EntityStorageHelper.isEmpty(data)) {
            return;
        }
        BaseEntity baseEntity = data.getEntity();
        if (!Receipt.class.isInstance(baseEntity)) {
            return;
        }
        Receipt receipt = (Receipt)baseEntity;
        if (TextUtil.nonBlank((String)receipt.getNumber())) {
            return;
        }
        String designator = receipt.getClass().getName();
        SequenceNumberHelper.get().generateInc((CompositeNumber)receipt, designator, null);
        this.saveNumber(data, (CompositeNumber)receipt, designator);
    }
}

