/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceIdForGetThereInterceptor
implements EntityInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public double getPriority() {
        return 1.0;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (Person.class.getName().equals(data.getEntityType().getName())) {
            Person person = (Person)data.getEntity();
            this.log.debug("==> Start check and save login GetThere");
            if (!GetThereSynchronizationUtil.isGetThereEnabled()) {
                this.log.debug("GetThere synchronization is disabled");
                return;
            }
            if (TextUtil.nonBlank((String)person.getResourceIdForGetThere())) {
                this.log.debug("resourceIdForGetThere non blank: " + person.getResourceIdForGetThere());
                return;
            }
            if (!ProfileHelper.checkPersonParametersForGetThere((List)person.getEmployments())) {
                this.log.debug("checkPersonParametersForGetThere is false");
                return;
            }
            for (PersonCommunication communication : person.getCommunications()) {
                this.log.debug("Start check communication");
                if (!CommunicationType.EMAIL.equals((Object)communication.getType()) || !TextUtil.nonBlank((String)communication.getSense())) continue;
                this.log.debug("Email is present: \"" + communication.getSense() + "\"");
                this.log.debug("Start check any body with equal getThere login");
                String somebodyWithTheSameGetThereLogin = ProfileHelper.getAnybodyWithEqualGetThereLogin((String)communication.getSense(), (String)data.getUid());
                if (somebodyWithTheSameGetThereLogin == null) {
                    this.log.debug("Set email \"" + communication.getSense() + "\" in resourceIdForGetThere");
                    person.setResourceIdForGetThere(communication.getSense());
                    this.log.debug("==================== end onSave ====================");
                    return;
                }
                this.log.debug("Such login is busy: \"" + somebodyWithTheSameGetThereLogin + "\"");
            }
            this.log.debug("Email not found");
            this.log.debug("==================== end onSave ====================");
        }
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }
}

