/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.VendorFinanceDocumentData;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.handlers.rules.ShipmentsDateRulesHelper;
import com.gridnine.xtrip.server.model.rules.RulesHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RulesInterceptor
implements EntityInterceptor {
    public static final double PRIORITY = 3.0;

    public double getPriority() {
        return 3.0;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        RulesHelper.applyRules(data);
        EntityContainer<?> bookingCtr = data;
        EntityContainer oldBookingCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        Map statuses = oldBookingCtr != null ? ((BookingFile)oldBookingCtr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).collect(Collectors.toMap(Function.identity(), p -> ProductHandler.of((BaseProduct)p).getStatus(p))) : Collections.emptyMap();
        Map<BaseProduct, Boolean> contractRulesAppliedInfo = ((BookingFile)bookingCtr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(p -> statuses.get(p) != ProductStatus.SELL && ProductHandler.of((BaseProduct)p).getStatus(p) == ProductStatus.SELL || FinanceDocumentsHelper.allowedProductStatusesShipment.contains(statuses.get(p)) && !FinanceDocumentsHelper.allowedProductStatusesShipment.contains(ProductHandler.of((BaseProduct)p).getStatus(p))).collect(Collectors.toMap(Function.identity(), p -> false));
        Map vendorFinanceDocumentsData = oldBookingCtr != null ? ((BookingFile)oldBookingCtr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).collect(Collectors.toMap(Function.identity(), p -> p.getVendorFinanceDocumentsData().stream().filter(item -> TextUtil.nonBlank((String)item.getVendorNumber()) && item.getVendorDate() != null).map(VendorFinanceDocumentData::getType).collect(Collectors.toSet()))) : Collections.emptyMap();
        Map vendorFinanceDocumentsDataChanges = ((BookingFile)bookingCtr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(p -> vendorFinanceDocumentsData.get(p) != null && !((Set)vendorFinanceDocumentsData.get(p)).equals(p.getVendorFinanceDocumentsData().stream().filter(item -> TextUtil.nonBlank((String)item.getVendorNumber()) && item.getVendorDate() != null).map(VendorFinanceDocumentData::getType).collect(Collectors.toSet()))).collect(Collectors.toMap(Function.identity(), p -> false));
        boolean applyRules = false;
        Map fopsEquivalentValues = oldBookingCtr != null ? ((BookingFile)oldBookingCtr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).collect(Collectors.toMap(Function.identity(), p -> ProductHandler.of((BaseProduct)p).getUnmodifiableContractRelations(p).stream().filter(cr -> cr.getFops().stream().anyMatch(fop -> fop.getEquivalentAmount() != null)).collect(Collectors.toMap(Function.identity(), cr -> GeneralProductHelper.calculateFopsEquivalentValue((Collection)cr.getFops()))))) : Collections.emptyMap();
        List products = ((BookingFile)bookingCtr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).collect(Collectors.toList());
        for (BaseProduct product : products) {
            Map values = (Map)fopsEquivalentValues.get(product);
            if (values == null) continue;
            List contractRelations = ProductHandler.of((BaseProduct)product).getUnmodifiableContractRelations(product);
            for (GeneralProductContractRelationData contractRelation : contractRelations) {
                BigDecimal oldValue = (BigDecimal)values.get(contractRelation);
                BigDecimal newValue = GeneralProductHelper.calculateFopsEquivalentValue((Collection)contractRelation.getFops());
                if ((MiscUtil.compare((Comparable)oldValue, (Comparable)BigDecimal.ZERO) != 0 || MiscUtil.compare((Comparable)newValue, (Comparable)BigDecimal.ZERO) == 0) && (MiscUtil.compare((Comparable)oldValue, (Comparable)BigDecimal.ZERO) == 0 || MiscUtil.compare((Comparable)newValue, (Comparable)BigDecimal.ZERO) != 0)) continue;
                applyRules = true;
            }
        }
        if (!contractRulesAppliedInfo.isEmpty() || !vendorFinanceDocumentsDataChanges.isEmpty() || applyRules) {
            ShipmentsDateRulesHelper.applyRules(bookingCtr, contractRulesAppliedInfo, false, false, new ArrayList<Message>());
        }
    }
}

