/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrder;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.NumberGenerationType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceNumberInterceptor
implements EntityInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public double getPriority() {
        return 0.0;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        String designator;
        BookingFile bookingFile;
        if (BookingFile.class.getName().equals(data.getEntityType().getName())) {
            bookingFile = (BookingFile)data.getEntity();
            designator = this.getClassName((CompositeNumber)bookingFile);
            SequenceNumberHelper.get().generateInc((CompositeNumber)bookingFile, designator, null);
            this.saveNumber(data, (CompositeNumber)bookingFile, designator);
        }
        if (StockOrder.class.getName().equals(data.getEntityType().getName())) {
            StockOrder stockOrder = (StockOrder)data.getEntity();
            designator = this.getClassName((CompositeNumber)stockOrder);
            SequenceNumberHelper.get().generateInc((CompositeNumber)stockOrder, designator, null);
            this.saveNumber(data, (CompositeNumber)stockOrder, designator);
        }
        if (BookingFile.class.getName().equals(data.getEntityType().getName())) {
            bookingFile = (BookingFile)data.getEntity();
            HashSet<String> paymentUIDs = new HashSet<String>();
            for (Payment payment : bookingFile.getPayments()) {
                String paymantUID = payment.getUid();
                if (paymentUIDs.contains(paymantUID)) continue;
                paymentUIDs.add(paymantUID);
                HashMap<CompositeNumber, String> numbersMap = new HashMap<CompositeNumber, String>();
                numbersMap.put((CompositeNumber)payment, this.getClassName((CompositeNumber)payment));
                for (FinanceDocument financeDocument : payment.getFinanceDocuments()) {
                    if (financeDocument.getTemplate() == null) continue;
                    numbersMap.put((CompositeNumber)financeDocument, this.getFinanceDocumentType(financeDocument));
                }
                NumberGenerationType numberGenerationType = this.getNumberGenerationType(bookingFile, payment);
                if (numberGenerationType == NumberGenerationType.PACKET) {
                    SequenceNumberHelper.get().generateMax(numbersMap, payment.getNumber());
                    this.saveNumbers(data, numbersMap);
                    continue;
                }
                SequenceNumberHelper.get().generateInc(numbersMap, null);
                this.saveNumbers(data, numbersMap);
            }
        }
    }

    protected void saveNumber(EntityContainer<?> data, CompositeNumber compositeNumber, String designator) throws Exception {
    }

    protected void saveNumbers(EntityContainer<?> data, Map<CompositeNumber, String> numbersMap) throws Exception {
    }

    protected String getClassName(CompositeNumber num) {
        if (num instanceof FinanceDocument) {
            EntityReference template = ((FinanceDocument)num).getTemplate();
            return template != null ? template.getUid() : null;
        }
        return num.getClass().getName();
    }

    protected String getFinanceDocumentType(FinanceDocument financeDocument) {
        String value;
        EntityContainer templateDocumentContainer = EntityStorage.get().resolve(financeDocument.getTemplate());
        if (templateDocumentContainer != null && !TextUtil.isBlank((String)(value = ProfileHelper.findMetadataStringByCode((List)((TemplateDocument)templateDocumentContainer.getEntity()).getMetadata(), (String)MetadataKey.KEY_FINANCE_DOCUMENT_TYPE.name())))) {
            return value.trim();
        }
        return financeDocument.getTemplate() != null ? financeDocument.getTemplate().getUid() : null;
    }

    private NumberGenerationType getNumberGenerationType(BookingFile bf, Payment payment) throws Exception {
        FinanceDocumentsProperties fdp;
        EntityContainer subagencyContainer;
        NumberGenerationType numberGenerationType = NumberGenerationType.SEQUENTIAL;
        HashSet<String> productUIDs = new HashSet<String>();
        for (Object billingItem : payment.getBillingItems()) {
            for (String productUID : billingItem.getProductUids()) {
                if (TextUtil.isBlank((String)productUID)) continue;
                productUIDs.add(productUID);
            }
        }
        EntityReference subagency = null;
        for (String productUID : productUIDs) {
            BaseProduct product = BookingHelper.findProduct((BookingFile)bf, (String)productUID);
            if (product == null) continue;
            ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
            if (handler == null) {
                this.log.error("no product handler is registered for product class " + product.getClass().getName());
                continue;
            }
            subagency = GeneralProductHelper.getSubagency((BaseProduct)product);
            if (subagency == null) continue;
            break;
        }
        if (subagency != null && (subagencyContainer = EntityStorage.get().resolve(subagency)) != null && subagencyContainer.getEntity() != null && (fdp = ((Organization)subagencyContainer.getEntity()).getFinanceDocumentProperties()).getNumberGenerationType() != null) {
            numberGenerationType = fdp.getNumberGenerationType();
        }
        return numberGenerationType;
    }
}

