/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.model.handlers.rules.GeneralProductRulesHelper;
import com.gridnine.xtrip.server.model.interceptors.BaseFopSettingsInterceptor;
import java.util.ArrayList;

public class ServiceFopSettingsInterceptor
extends BaseFopSettingsInterceptor {
    private static final double PRIORITY = 2.99;

    public double getPriority() {
        return 2.99;
    }

    @Override
    protected EntityContainer<Contract> findContract(BaseProduct product, GeneralProductContractRelationData contractRelation) throws Exception {
        ContractType contractType = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription());
        EntityReference blankOwner = GeneralProductHelper.getBlankOwner((BaseProduct)product);
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
        SalesChain salesChain = handler.getSalesChain(product);
        EntityReference supplier = GeneralProductHelper.getContractRelationSupplier((EntityReference)contractRelation.getDescription(), (SalesChain)salesChain);
        EntityReference customer = contractType == ContractType.CLIENT ? product.getReservation().getBookingFile().getCustomerProfile() : GeneralProductHelper.getContractRelationCustomer((EntityReference)contractRelation.getDescription(), (SalesChain)salesChain);
        return GeneralProductRulesHelper.getContract(contractType, product, (EntityReference<Organization>)blankOwner, (EntityReference<Organization>)supplier, (EntityReference<Organization>)customer, new ArrayList<ValidationMessage>(), handler.findIssueDate(product), null, null);
    }

    @Override
    protected boolean isAppropriateFop(BaseProduct product, GeneralProductFop fop) {
        return GeneralProductHelper.isServiceFop((GeneralProductFop)fop);
    }
}

