/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSaveParameters;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentProductAppliedRulesIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.Callback;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.LogicalStorageHelper;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShipmentInterceptor
implements EntityInterceptor {
    static final Logger log = LoggerFactory.getLogger(ShipmentInterceptor.class);

    public double getPriority() {
        return 0.0;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!Shipment.class.equals((Object)data.getEntityType())) {
            return;
        }
        EntityContainer<?> shipmentContainer = data;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ShipmentProductAppliedRulesIndex.Property.shipment.name(), (Object)shipmentContainer.toReference()));
        EntityStorage entityStorage = EntityStorage.get();
        entityStorage.search(ShipmentProductAppliedRulesIndex.class, query).getData().stream().map(item -> entityStorage.resolve(item.getSource())).filter(Objects::nonNull).collect(Collectors.toList()).forEach(arg_0 -> ((EntityStorage)entityStorage).delete(arg_0));
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!Shipment.class.equals((Object)data.getEntityType())) {
            return;
        }
        final String title = String.format("%s (%s)", data.toReference(), data.getUid());
        log.debug(String.format("shipment interceptor -> %s -> save -> start", title));
        final EntityContainer<?> shipmentContainer = data;
        EntityContainer oldShipmentContainer = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        if (oldShipmentContainer != null) {
            log.debug(String.format("shipment interceptor -> %s -> save -> old shipment container found", title));
            String number = ((Shipment)shipmentContainer.getEntity()).getNumber();
            String oldNumber = ((Shipment)oldShipmentContainer.getEntity()).getNumber();
            if (!TextUtil.isSame((String)number, (String)oldNumber)) {
                log.debug(String.format("shipment interceptor -> %s -> save -> shipment number update -> %s -> %s", title, oldNumber, number));
                final EntityStorageActualizeParameters actualizeParameters = new EntityStorageActualizeParameters().processedUncachedEntity(true);
                final EntityStorageSaveParameters saveParameters = (EntityStorageSaveParameters)new EntityStorageSaveParameters().ignoreInterceptors(true);
                EntityStorageContext context = new EntityStorageContext();
                Map bookingFileContainers = FinanceDocumentHelper.getBillingItems(((Shipment)shipmentContainer.getEntity()).getBillingItems(), context).stream().map(item -> EntityStorageHelper.resolveDetailed((NestedEntityReference)item.getProduct(), (EntityStorageContext)context)).filter(Objects::nonNull).collect(Collectors.groupingBy(MiscUtil.Pair::getFirst, MiscUtil.getListCollector(MiscUtil.Pair::getSecond)));
                for (Map.Entry entry : bookingFileContainers.entrySet()) {
                    final EntityContainer bookingFileContainer = entry.getKey();
                    final Collection products = (Collection)entry.getValue();
                    final String bookingFileTitle = String.format("%s (%s)", bookingFileContainer.toReference(), bookingFileContainer.getUid());
                    ss.addCallback(new Callback(){
                        private static final long serialVersionUID = 4760981191840792887L;

                        public void execute(SessionCallback ss1) {
                            log.debug(String.format("shipment interceptor -> %s -> save -> callback -> %s -> start", title, bookingFileTitle));
                            try {
                                List components = products.stream().flatMap(item -> item.getFopDetalizations().values().stream()).flatMap(item -> item.getComponents().stream()).filter(item -> MiscUtil.equals((Object)shipmentContainer.toReference(), (Object)item.getShipment()) || MiscUtil.equals((Object)shipmentContainer.toReference(), (Object)item.getCorrectionShipment())).collect(Collectors.toList());
                                for (FopComponent component : components) {
                                    EntityStorage.get().actualize(component.getShipment(), actualizeParameters);
                                    EntityStorage.get().actualize(component.getCorrectionShipment(), actualizeParameters);
                                }
                                bookingFileContainer.setModified(new Date());
                                bookingFileContainer.getVersionInfo().setDataSource("shipments actualize");
                                EntityStorage.get().save(bookingFileContainer, true, saveParameters);
                            }
                            catch (Exception e) {
                                log.error(String.format("shipment interceptor -> %s -> save -> callback -> %s -> unable to actualize shipments", title, bookingFileTitle), (Throwable)e);
                            }
                            log.debug(String.format("shipment interceptor -> %s -> save -> callback -> %s -> end", title, bookingFileTitle));
                        }
                    });
                }
            } else {
                log.debug(String.format("shipment interceptor -> %s -> save -> shipment number matches -> %s", title, number));
            }
        } else {
            log.debug(String.format("shipment interceptor -> %s -> save -> old shipment container not found", title));
        }
        EntityStorageContext ctx = LogicalStorageHelper.getEntityStorageContext();
        Shipment shipment = (Shipment)shipmentContainer.getEntity();
        shipment.setPayedAmountCachedValue(ShipmentHelper.calculatePayedAmount(shipment, ctx));
        shipment.setTotalAmountCachedValue(ShipmentHelper.calculateTotalAmount(shipment, ctx));
        shipment.setTotalVatAmountCachedValue(ShipmentHelper.calculateTotalVatAmount(shipment, ctx));
        log.debug(String.format("shipment interceptor -> %s -> save -> end", title));
    }
}

