/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.rules.RulesOptimizationHelper;

public class StandardRulesOptimizationInterceptor
implements EntityInterceptor {
    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        BaseEntity entity = data.getEntity();
        if (entity instanceof Contract) {
            Contract contract = (Contract)entity;
            RulesOptimizationHelper.optimize(contract.getRuleSet());
        } else if (entity instanceof TripartiteContract) {
            TripartiteContract tripartiteContract = (TripartiteContract)entity;
            RulesOptimizationHelper.optimize(tripartiteContract.getRuleSet());
        }
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public double getPriority() {
        return 0.0;
    }
}

