/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.stockcontrol.ETicketQuota;
import com.gridnine.xtrip.common.model.stockcontrol.ETicketQuotaIndex;
import com.gridnine.xtrip.common.model.stockcontrol.OrderItem;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlankControlStatus;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlankIndex;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrder;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrderIndex;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrderStatus;
import com.gridnine.xtrip.common.model.stockcontrol.UsageStatus;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.db.Callback;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.stockcontrol.StockControlProductHandler;
import com.gridnine.xtrip.server.model.helpers.StockControlDao;
import com.gridnine.xtrip.server.model.stockcontrol.RegisterStockOrderHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StockControlInterceptor
implements EntityInterceptor {
    public static final String StockControlInterceptor_DuplicateScn = Messages.StockControlInterceptor_detectDuplicateSCNForTicket;
    public static final String StockControlInterceptor_NoBlankFound = Messages.StockControlInterceptor_notFoundBlankSCN;
    public static final String StockControlInterceptor_NoCurrentLocation = Messages.StockControlInterceptor_noCurrentLocation;
    public static final String StockControlInterceptor_WrongCurrentLocation = Messages.StockControlInterceptor_currentLocationBlankNotCorrectly;
    public static final String StockControlInterceptor_NoAgency = Messages.StockControlInterceptor_agentWriteoutTicket;
    public static final String StockControlInterceptor_NoSalesPointForAgent = Messages.StockControlInterceptor_agentNoSalePoint;
    public static final String StockControlInterceptor_NoPcc = Messages.StockControlInterceptor_salePointNoRCC;
    public static final String StockControlInterceptor_NoValidator = Messages.StockControlInterceptor_salePointNoValidator;
    private static final Logger log = LoggerFactory.getLogger(StockControlInterceptor.class);

    public double getPriority() {
        return 4.0;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (BookingFile.class.getName().equals(data.getEntityType().getName())) {
            for (StockBlankIndex index : this.getRelatedBlanks(data.toReference())) {
                this.unregisterBlank((EntityReference<StockBlank>)index.getSource());
            }
            return;
        }
        if (StockBlank.class.getName().equals(data.getEntityType().getName())) {
            StockBlank blank = (StockBlank)data.getEntity();
            final EntityReference bookingFile = blank.getBookingFile();
            if (bookingFile != null) {
                ss.addCallback(new Callback(){
                    private static final long serialVersionUID = -1467669102173700973L;

                    public void execute(SessionCallback ss1) {
                        try {
                            EntityContainer container = EntityStorage.get().resolve(bookingFile);
                            if (container == null) {
                                return;
                            }
                            EntityStorage.get().save(container, false);
                        }
                        catch (Exception e) {
                            LoggerFactory.getLogger(this.getClass()).error("Unable to resave booking " + bookingFile);
                        }
                    }
                });
            }
            return;
        }
        if (StockOrder.class.getName().equals(data.getEntityType().getName())) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)StockOrderIndex.Property.relatedOrders.name(), (Object)data.getUid()));
            query.setResultMode(ResultMode.COUNT_ONLY);
            if (EntityStorage.get().search(StockOrderIndex.class, query).getTotalCount() > 0) {
                throw new Exception("Unable to delete Stock order because there are related orders");
            }
            query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)StockBlankIndex.Property.orders.name(), (Object)data.getUid()));
            query.setResultMode(ResultMode.COUNT_ONLY);
            if (EntityStorage.get().search(StockBlankIndex.class, query).getTotalCount() > 0) {
                throw new Exception("Unable to delete Stock order because there are connected blanks in the data base");
            }
            StockOrder order = (StockOrder)data.getEntity();
            StockControlInterceptor.unreserveBlanksForStockOrder(order, null);
            SearchQuery query2 = new SearchQuery();
            query2.getCriteria().getCriterions().add(SearchCriterion.contains((String)StockOrderIndex.Property.relatedOrders.name(), (Object)data.getUid()));
            query2.getPreferredProperties().add(StockOrderIndex.Property.relatedOrders.name());
            for (StockOrderIndex index : EntityStorage.get().search(StockOrderIndex.class, query2).getData()) {
                EntityContainer container = EntityStorage.get().resolve(index.getSource());
                if (container == null) continue;
                ((StockOrder)container.getEntity()).getRelatedOrders().remove(data.toReference());
                EntityStorage.get().save(container, false);
            }
            return;
        }
    }

    private void unregisterBlank(EntityReference<StockBlank> source) throws Exception {
        EntityContainer container = EntityStorage.get().resolve(source);
        if (container == null) {
            return;
        }
        StockBlank stockBlank = (StockBlank)container.getEntity();
        stockBlank.setProductUid(null);
        stockBlank.setProductNumber(null);
        stockBlank.setBookingFile(null);
        stockBlank.setTariffType(null);
        stockBlank.setOperationDate(null);
        stockBlank.setVendorPaymentDate(null);
        stockBlank.setUsageStatus(UsageStatus.NEW);
        stockBlank.getProductLogItems().clear();
        stockBlank.getControlMessages().clear();
        EntityStorage.get().save(container, false);
    }

    private List<StockBlankIndex> getRelatedBlanks(EntityReference<?> data) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)StockBlankIndex.Property.bookingFile.name(), (Object)data.getUid()));
        return EntityStorage.get().search(StockBlankIndex.class, query).getData();
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (BookingFile.class.getName().equals(data.getEntityType().getName())) {
            EntityContainer container;
            StockControlProductHandler handler;
            BaseProduct product;
            HashSet<StockBlankIndex> unregister = new HashSet<StockBlankIndex>();
            HashMap<String, BaseProduct> register = new HashMap<String, BaseProduct>();
            HashMap<EntityReference, BaseProduct> change = new HashMap<EntityReference, BaseProduct>();
            HashMap<EntityReference, BaseProduct> update = new HashMap<EntityReference, BaseProduct>();
            List<StockBlankIndex> relatedBlanks = this.getRelatedBlanks(data.toReference());
            for (StockBlankIndex stockBlankIndex : relatedBlanks) {
                unregister.add(stockBlankIndex);
            }
            BookingFile oldBooking = null;
            for (Reservation res : ((BookingFile)data.getEntity()).getReservations()) {
                for (BaseProduct bp : res.getProducts()) {
                    StockControlProductHandler handler2 = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findStockControlHandler(bp.getClass());
                    if (handler2 == null) continue;
                    StockControlInterceptor.clearValidationMessages(bp);
                    if (handler2.getTicketType(bp) == TicketType.EXTERNAL || handler2.getTicketType(bp) == TicketType.FAKE || handler2.getTicketType(bp) == TicketType.CORRECTION || handler2.getTicketType(bp) == TicketType.NOT_OWN || handler2.getStatus(bp) == ProductStatus.SELL && handler2.getNextProduct(bp) != null && (handler2.getStatus(handler2.getNextProduct(bp)) == ProductStatus.REFUND || handler2.getStatus(handler2.getNextProduct(bp)) == ProductStatus.EXCHANGE)) continue;
                    for (String scn : handler2.getSCNs(bp)) {
                        EntityContainer entityContainer;
                        if (TextUtil.isBlank((String)scn)) continue;
                        StockBlankIndex blank = this.findBlank(relatedBlanks, bp, scn);
                        if (blank == null && handler2.getPreviousProduct(bp) != null && (handler2.getStatus(bp) == ProductStatus.EXCHANGE || handler2.getStatus(bp) == ProductStatus.REFUND) && (blank = this.findBlank(relatedBlanks, handler2.getPreviousProduct(bp), scn)) != null) {
                            change.put(blank.getSource(), bp);
                            unregister.remove(blank);
                            continue;
                        }
                        if (blank == null) {
                            register.put(scn, bp);
                            continue;
                        }
                        if (oldBooking == null && (entityContainer = EntityStorage.get().resolve(data.toReference())) != null) {
                            oldBooking = (BookingFile)entityContainer.getEntity();
                        }
                        if (oldBooking == null || StockControlInterceptor.needUpdate(bp, oldBooking)) {
                            update.put(blank.getSource(), bp);
                        }
                        if (oldBooking != null) {
                            BaseProduct baseProduct = BookingHelper.findProduct((BookingFile)oldBooking, (String)bp.getUid());
                            boolean needChanges = false;
                            if (baseProduct != null) {
                                if (handler2.getStatus(bp) == ProductStatus.SELL && handler2.getStatus(baseProduct) == ProductStatus.VOID) {
                                    needChanges = true;
                                }
                                if (handler2.getStatus(bp) == ProductStatus.VOID && handler2.getStatus(baseProduct) == ProductStatus.SELL) {
                                    needChanges = true;
                                }
                            }
                            if (needChanges) {
                                change.put(blank.getSource(), bp);
                                if (update.containsKey(blank.getSource())) {
                                    update.remove(blank.getSource());
                                }
                            }
                        }
                        unregister.remove(blank);
                    }
                }
            }
            HashSet<BaseProduct> hashSet = new HashSet<BaseProduct>();
            for (Map.Entry entry : register.entrySet()) {
                String scn = (String)entry.getKey();
                product = (BaseProduct)entry.getValue();
                handler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findStockControlHandler(product.getClass());
                if (!hashSet.contains(product)) {
                    StockControlInterceptor.clearValidationMessages(product);
                } else {
                    hashSet.add(product);
                }
                HashSet<StockBlankIndex> tempSet = new HashSet<StockBlankIndex>();
                for (StockBlankIndex stockBlankIndex : unregister) {
                    if (!scn.equals(stockBlankIndex.getNumber())) continue;
                    tempSet.add(stockBlankIndex);
                }
                EntityContainer<StockBlank> stockBlankContainer = null;
                for (StockBlankIndex index3 : tempSet) {
                    if (index3.getUsageStatus() != UsageStatus.NEW) continue;
                    stockBlankContainer = EntityStorage.get().resolve(index3.getSource());
                    unregister.remove(index3);
                    break;
                }
                if (stockBlankContainer == null && !tempSet.isEmpty()) {
                    StockBlankIndex stockBlankIndex = (StockBlankIndex)tempSet.iterator().next();
                    stockBlankContainer = EntityStorage.get().resolve(stockBlankIndex.getSource());
                    unregister.remove(stockBlankIndex);
                }
                if (stockBlankContainer != null) {
                    ((StockBlank)stockBlankContainer.getEntity()).getProductLogItems().clear();
                }
                if (stockBlankContainer == null) {
                    Date issueDate;
                    MetaRegistry metaRegistry;
                    IndexType indexType;
                    SearchQuery searchQuery = new SearchQuery();
                    if (handler.getStatus(product) != null) {
                        SearchCriterion criterion = SearchCriterion.eq((String)handler.getStatusIndexPropertyName(), (Object)handler.getStatus(product));
                        if (handler.getStatus(product) == ProductStatus.REFUND) {
                            searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{criterion, SearchCriterion.eq((String)handler.getStatusIndexPropertyName(), (Object)ProductStatus.EXCHANGE)}));
                        } else if (handler.getStatus(product) == ProductStatus.EXCHANGE) {
                            searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{criterion, SearchCriterion.eq((String)handler.getStatusIndexPropertyName(), (Object)ProductStatus.REFUND)}));
                        } else {
                            searchQuery.getCriteria().getCriterions().add(criterion);
                        }
                    }
                    if ((indexType = (IndexType)(metaRegistry = MetaRegistry.get()).getIndexes().get(handler.getProductIndexClass().getName())).getCollections().containsKey(handler.getSCNIndexPropertyName())) {
                        searchQuery.getCriteria().getCriterions().add(SearchCriterion.contains((String)handler.getSCNIndexPropertyName(), (Object)scn));
                    } else {
                        searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)handler.getSCNIndexPropertyName(), (Object)scn));
                    }
                    searchQuery.setResultMode(ResultMode.COUNT_ONLY);
                    if (handler.getTicketTypeIndexPropertyName() != null) {
                        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)handler.getTicketTypeIndexPropertyName(), (Object)TicketType.OWN), SearchCriterion.eq((String)handler.getTicketTypeIndexPropertyName(), null)}));
                    }
                    if ((issueDate = handler.getIssueDate(product)) != null) {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(issueDate);
                        cal.add(1, -1);
                        Date startDate = cal.getTime();
                        cal.add(1, 2);
                        Date endDate = cal.getTime();
                        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)handler.getIssueDateIndexPropertyName(), (Object)startDate), SearchCriterion.le((String)handler.getIssueDateIndexPropertyName(), (Object)endDate)}), SearchCriterion.eq((String)handler.getIssueDateIndexPropertyName(), null)}));
                    }
                    searchQuery.getCriteria().getCriterions().addAll(handler.getProductIndexAdditionalCriterions(product));
                    if (EntityStorage.get().search(handler.getProductIndexClass(), searchQuery).getTotalCount() > 1) {
                        StockControlInterceptor.addValidationMessage(product, (ValidationMessageType)StandartValidationMessageType.SCI_DUPLICATE_SCN, scn, handler.getSystemNumber(product));
                    }
                    if ((stockBlankContainer = StockControlDao.findBlankByScn(scn, false)) == null) {
                        StockControlInterceptor.addValidationMessage(product, (ValidationMessageType)StandartValidationMessageType.SCI_NO_BLANK_FOUND, scn);
                        continue;
                    }
                    String string = ((StockBlank)stockBlankContainer.getEntity()).getProductUid();
                    if (!TextUtil.isBlank((String)string) && !string.equals(product.getUid())) {
                        StockControlInterceptor.addValidationMessage(product, (ValidationMessageType)StandartValidationMessageType.SCI_NO_BLANK_FOUND, scn);
                        continue;
                    }
                }
                StockBlank stockBlank = (StockBlank)stockBlankContainer.getEntity();
                stockBlank.setOperationDate(RegisterStockOrderHelper.getOperationDate(product));
                stockBlank.setVendorPaymentDate(RegisterStockOrderHelper.getVendorPaymentDate(product));
                stockBlank.setProductUid(product.getUid());
                stockBlank.setProductNumber(RegisterStockOrderHelper.buildProductNumber(product, stockBlank.getNumber()));
                stockBlank.setBookingFile(data.toReference());
                RegisterStockOrderHelper.changeBlankUsageStatus(stockBlank, product);
                RegisterStockOrderHelper.registerProductLogItem(data, product, stockBlank, null);
                stockBlank.setValidatorCode(handler.getValidator(product));
                stockBlank.setTariffType(handler.getTariffType(product));
                StockControlInterceptor.updateValidationMessages(stockBlank, product);
                EntityStorage.get().save((EntityContainer)stockBlankContainer, false);
            }
            for (StockBlankIndex index : unregister) {
                this.unregisterBlank((EntityReference<StockBlank>)index.getSource());
            }
            hashSet.clear();
            for (Map.Entry entry : change.entrySet()) {
                container = EntityStorage.get().resolve((EntityReference)entry.getKey());
                if (container == null) continue;
                StockBlank stockBlank = (StockBlank)container.getEntity();
                BaseProduct product2 = (BaseProduct)entry.getValue();
                StockControlProductHandler handler3 = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findStockControlHandler(product2.getClass());
                if (!hashSet.contains(product2)) {
                    StockControlInterceptor.clearValidationMessages(product2);
                } else {
                    hashSet.add(product2);
                }
                stockBlank.setOperationDate(RegisterStockOrderHelper.getOperationDate(product2));
                stockBlank.setVendorPaymentDate(RegisterStockOrderHelper.getVendorPaymentDate(product2));
                RegisterStockOrderHelper.changeBlankUsageStatus(stockBlank, product2);
                stockBlank.setProductUid(product2.getUid());
                stockBlank.setProductNumber(RegisterStockOrderHelper.buildProductNumber(product2, stockBlank.getNumber()));
                stockBlank.setBookingFile(data.toReference());
                if (stockBlank.getProductLogItems().isEmpty() && handler3.getPreviousProduct(product2) != null && handler3.getStatus(handler3.getPreviousProduct(product2)) == ProductStatus.SELL) {
                    RegisterStockOrderHelper.registerProductLogItem(data, handler3.getPreviousProduct(product2), stockBlank, null);
                }
                RegisterStockOrderHelper.registerProductLogItem(data, product2, stockBlank, null);
                stockBlank.setValidatorCode(handler3.getValidator(product2));
                stockBlank.setTariffType(handler3.getTariffType(product2));
                StockControlInterceptor.updateValidationMessages(stockBlank, product2);
                EntityStorage.get().save(container, false);
            }
            hashSet.clear();
            Object var9_20 = null;
            for (Map.Entry entry : update.entrySet()) {
                container = EntityStorage.get().resolve((EntityReference)entry.getKey());
                if (container == null) continue;
                product = (BaseProduct)entry.getValue();
                handler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findStockControlHandler(product.getClass());
                ((StockBlank)container.getEntity()).setVendorPaymentDate(RegisterStockOrderHelper.getVendorPaymentDate(product));
                ((StockBlank)container.getEntity()).setOperationDate(RegisterStockOrderHelper.getOperationDate(product));
                ((StockBlank)container.getEntity()).setTariffType(handler.getTariffType(product));
                StockControlInterceptor.updateValidationMessages((StockBlank)container.getEntity(), product);
                EntityStorage.get().save(container, false);
            }
            return;
        }
        if (StockOrder.class.getName().equals(data.getEntityType().getName())) {
            Iterator orderItems2;
            StockOrder order = (StockOrder)data.getEntity();
            if (order.getStatus() == null) {
                order.setStatus(StockOrderStatus.NEW);
            }
            EntityContainer container = EntityStorage.get().resolve(data.toReference());
            if (order.getStatus() == StockOrderStatus.NEW) {
                ArrayList<Message> messages = new ArrayList<Message>();
                if (container != null) {
                    StockOrder oldOrder = (StockOrder)container.getEntity();
                    StockControlInterceptor.unreserveBlanksForDeletedOrderItems(order, oldOrder, messages);
                }
                StockControlInterceptor.reserveBlanksForStockOrder(order, messages);
                return;
            }
            if (container == null) {
                return;
            }
            StockOrder order2 = (StockOrder)container.getEntity();
            List<String> orderItems1 = this.buildOrderItems(order);
            if (!orderItems1.containsAll((Collection<?>)((Object)(orderItems2 = this.buildOrderItems(order2)))) || !orderItems2.containsAll(orderItems1)) {
                throw new Exception("Order items changed for non \"NEW\" order");
            }
        }
        if (StockBlank.class.getName().equals(data.getEntityType().getName())) {
            StockBlank blank = (StockBlank)data.getEntity();
            if (blank.getUsageStatus() == null) {
                blank.setUsageStatus(UsageStatus.NEW);
            }
            if (blank.getControlStatus() == null) {
                blank.setControlStatus(StockBlankControlStatus.NONE);
            }
            if (TextUtil.isBlank((String)blank.getProductUid())) {
                StockControlInterceptor.updateValidationMessages(blank, null);
            }
            EntityContainer entityBooking = null;
            entityBooking = EntityStorage.get().resolve(blank.getBookingFile());
            if (entityBooking != null) {
                block10: for (Reservation reservation : ((BookingFile)entityBooking.getEntity()).getReservations()) {
                    for (BaseProduct product : reservation.getProducts()) {
                        if (!product.getUid().equals(blank.getProductUid())) continue;
                        StockControlInterceptor.updateValidationMessages(blank, product);
                        continue block10;
                    }
                }
            }
        }
        if (ETicketQuota.class.getName().equals(data.getEntityType().getName())) {
            EntityContainer cntr;
            ETicketQuota entity = (ETicketQuota)data.getEntity();
            SearchQuery query = new SearchQuery();
            if (entity.getBlankOwner() != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ETicketQuotaIndex.Property.blankOwner.name(), (Object)entity.getBlankOwner()));
            }
            if (entity.getStockHolder() != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ETicketQuotaIndex.Property.stockHolder.name(), (Object)entity.getStockHolder()));
            }
            if (entity.getCurrentLocation() != null && !entity.getCurrentLocation().equals((Object)entity.getStockHolder())) {
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ETicketQuotaIndex.Property.currentLocation.name(), (Object)entity.getCurrentLocation()));
            } else {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ETicketQuotaIndex.Property.currentLocation.name(), null), SearchCriterion.eq((String)ETicketQuotaIndex.Property.currentLocation.name(), (Object)entity.getStockHolder())}));
            }
            SearchResult result = EntityStorage.get().search(ETicketQuotaIndex.class, query);
            HashSet<EntityReference> references = new HashSet<EntityReference>();
            for (ETicketQuotaIndex index : result.getData()) {
                references.add(index.getSource());
            }
            if (!references.isEmpty() && !(cntr = EntityStorage.get().resolve((EntityReference)references.iterator().next())).equals(data)) {
                throw new Exception("The e-ticket quota with same blank owner, stock holder and current location already exists");
            }
        }
    }

    private static <P extends BaseProduct> void clearValidationMessages(P product) {
        if (product == null) {
            return;
        }
        StockControlProductHandler handler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findStockControlHandler(product.getClass());
        Iterator<ValidationMessage> it = handler.getValidationMessages(product).iterator();
        while (it.hasNext()) {
            if (it.next().getCategory() != ValidationMessageCategory.STOCK_CONTROL) continue;
            it.remove();
        }
        if (handler.getStatus(product) == ProductStatus.REFUND || handler.getStatus(product) == ProductStatus.EXCHANGE) {
            StockControlInterceptor.clearValidationMessages(handler.getPreviousProduct(product));
        }
    }

    private static <P extends BaseProduct> void addValidationMessage(P product, ValidationMessageType type, Object ... parameters) throws Exception {
        ValidationMessage message = ValidationMessageHelper.createValidationMessage((ValidationMessageType)type, (Object[])parameters);
        StockControlProductHandler handler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findStockControlHandler(product.getClass());
        handler.getValidationMessages(product).add(message);
        if (handler.getPreviousProduct(product) != null && (handler.getStatus(product) == ProductStatus.REFUND || handler.getStatus(product) == ProductStatus.EXCHANGE)) {
            handler.getValidationMessages(handler.getPreviousProduct(product)).add((ValidationMessage)XCloneHelper.clone((XCloneable)message, (boolean)true));
        }
    }

    private static <P extends BaseProduct> boolean needUpdate(P prod, BookingFile oldBooking) throws Exception {
        StockControlProductHandler handler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findStockControlHandler(prod.getClass());
        BaseProduct oldProd = BookingHelper.findProductByUid((String)prod.getUid(), (BookingFile)oldBooking);
        if (oldProd == null) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"navigationKey", (Object)prod.getUid()));
            List data = EntityStorage.get().search(handler.getProductIndexClass(), query).getData();
            if (data.isEmpty()) {
                return true;
            }
            oldProd = BookingHelper.findProduct((BookingFile)((BookingFile)EntityStorage.get().resolve(((EntityIndex)data.get(0)).getSource()).getEntity()), (String)prod.getUid());
        }
        if (!CollectionUtil.equals((Collection)CommonReservationGdsNameInfoHelper.getGdsNames((Reservation)prod.getReservation()), (Collection)CommonReservationGdsNameInfoHelper.getGdsNames((Reservation)oldProd.getReservation()), (boolean)true)) {
            return true;
        }
        if (!MiscUtil.equals(handler.getBlankOwner(prod), handler.getBlankOwner(oldProd))) {
            return true;
        }
        if (!MiscUtil.equals((Object)handler.getPCC(prod), (Object)handler.getPCC(oldProd))) {
            return true;
        }
        if (!MiscUtil.equals(handler.getValidationMessages(prod), (Object)handler.getValidator(oldProd))) {
            return true;
        }
        if (!MiscUtil.equals((Object)handler.getTariffType(prod), (Object)handler.getTariffType(oldProd))) {
            return true;
        }
        return handler.getVendorFops(prod).size() != handler.getVendorFops(oldProd).size() || StockControlInterceptor.needUpdate(prod, oldProd);
    }

    private static <P extends BaseProduct> boolean needUpdate(P prod, P oldProd) {
        StockControlProductHandler handler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findStockControlHandler(prod.getClass());
        List fopsNew = handler.getVendorFops(prod);
        List fopsOld = handler.getVendorFops(oldProd);
        if (fopsNew.isEmpty() && fopsOld.isEmpty()) {
            return false;
        }
        Date newDate = handler.getOperationDate((Fop)fopsNew.get(0));
        Date oldDate = handler.getOperationDate((Fop)fopsOld.get(0));
        return newDate == null || oldDate == null || newDate.getDate() != oldDate.getDate() || newDate.getMonth() != oldDate.getMonth() || newDate.getYear() != oldDate.getYear();
    }

    private static <P extends BaseProduct, I extends EntityIndex<BookingFile>, F extends Fop> void updateValidationMessages(StockBlank stockBlank, P product) throws Exception {
        String validator;
        String pcc;
        EntityContainer salesPointCtr;
        stockBlank.getControlMessages().clear();
        if (stockBlank.getUsageStatus() == UsageStatus.NEW || stockBlank.getUsageStatus() == UsageStatus.RETURN) {
            stockBlank.setControlStatus(StockBlankControlStatus.NONE);
            return;
        }
        if (stockBlank.getControlStatus() == StockBlankControlStatus.IGNORE) {
            return;
        }
        if (stockBlank.getCurrentLocation() == null) {
            stockBlank.getControlMessages().add(RegisterStockOrderHelper.createMessage(MessageType.ERROR, StockControlInterceptor_NoCurrentLocation, null, new Object[0]));
            stockBlank.setControlStatus(StockBlankControlStatus.ERROR);
            StockControlInterceptor.updateProductMessages(stockBlank, product);
            return;
        }
        if (product == null) {
            stockBlank.getControlMessages().add(RegisterStockOrderHelper.createMessage(MessageType.ERROR, Messages.StockControlInterceptor_blankNotNewNoHaveProduct, null, new Object[0]));
            stockBlank.setControlStatus(StockBlankControlStatus.ERROR);
            return;
        }
        StockControlProductHandler handler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findStockControlHandler(product.getClass());
        String clsName = stockBlank.getCurrentLocation().getType().getName();
        if (!clsName.equals(Person.class.getName()) && !clsName.equals(SalesPoint.class.getName()) && MiscUtil.equals((Object)stockBlank.getStockHolder(), (Object)stockBlank.getCurrentLocation()) || clsName.equals(Organization.class.getName()) && stockBlank.getUsageStatus() == UsageStatus.SELL && handler.getSubagency(product) != null && !MiscUtil.equals((Object)stockBlank.getCurrentLocation().getUid(), (Object)handler.getSubagency(product).getUid()) || clsName.equals(Person.class.getName()) && stockBlank.getUsageStatus() == UsageStatus.SELL && handler.getAgent(product) != null && !MiscUtil.equals((Object)stockBlank.getCurrentLocation(), handler.getAgent(product))) {
            stockBlank.getControlMessages().add(RegisterStockOrderHelper.createMessage(MessageType.ERROR, StockControlInterceptor_WrongCurrentLocation, null, stockBlank.getCurrentLocation().toString()));
            stockBlank.setControlStatus(StockBlankControlStatus.ERROR);
            StockControlInterceptor.updateProductMessages(stockBlank, product);
            return;
        }
        if (StockControlInterceptor.isAgency((EntityReference<? extends BaseProfile>)stockBlank.getCurrentLocation())) {
            stockBlank.setControlStatus(StockBlankControlStatus.OK);
            return;
        }
        if (clsName.equals(Person.class.getName())) {
            EntityContainer container = EntityStorage.get().resolve(stockBlank.getCurrentLocation());
            if (container == null) {
                stockBlank.getControlMessages().add(RegisterStockOrderHelper.createMessage(MessageType.ERROR, StockControlInterceptor_NoCurrentLocation, null, new Object[0]));
                stockBlank.setControlStatus(StockBlankControlStatus.ERROR);
                StockControlInterceptor.updateProductMessages(stockBlank, product);
                return;
            }
            Person agent = (Person)container.getEntity();
            if (!StockControlInterceptor.isRefInAgencyList(agent.getEmployments(), (EntityReference<Organization>)stockBlank.getStockHolder())) {
                stockBlank.getControlMessages().add(RegisterStockOrderHelper.createMessage(MessageType.ERROR, StockControlInterceptor_NoAgency, null, StockControlInterceptor.agencyList2String(agent.getEmployments()), handler.getSystemNumber(product), container.toReference().toString()));
                stockBlank.setControlStatus(StockBlankControlStatus.ERROR);
                StockControlInterceptor.updateProductMessages(stockBlank, product);
                return;
            }
        }
        SalesPoint salesPoint = null;
        if (handler.getSalesPoint(product) != null && (salesPointCtr = EntityStorage.get().resolve(handler.getSalesPoint(product))) != null) {
            salesPoint = (SalesPoint)salesPointCtr.getEntity();
        }
        if (!TextUtil.isBlank((String)(pcc = handler.getPCC(product)))) {
            boolean found = false;
            if (salesPoint != null) {
                for (Pcc item : salesPoint.getPccs()) {
                    if (!pcc.equalsIgnoreCase(item.getCode()) || !CommonReservationGdsNameInfoHelper.containsGds((Reservation)product.getReservation(), (GdsName)item.getGdsName()) || item.getOpened() != null && stockBlank.getOperationDate() != null && stockBlank.getOperationDate().before(item.getOpened()) || item.getClosed() != null && stockBlank.getOperationDate() != null && stockBlank.getOperationDate().after(item.getClosed())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    stockBlank.getControlMessages().add(RegisterStockOrderHelper.createMessage(MessageType.ERROR, StockControlInterceptor_NoPcc, null, salesPoint.toString(), pcc));
                    stockBlank.setControlStatus(StockBlankControlStatus.ERROR);
                    StockControlInterceptor.updateProductMessages(stockBlank, product);
                    return;
                }
            }
        }
        if (!TextUtil.isBlank((String)(validator = handler.getValidator(product)))) {
            boolean found = false;
            if (salesPoint != null) {
                for (Validator item : salesPoint.getValidators()) {
                    if (!validator.equals(item.getNumber()) || !MiscUtil.equals((Object)item.getAgency(), (Object)stockBlank.getStockHolder()) || !MiscUtil.equals((Object)item.getBlankOwner(), handler.getBlankOwner(product)) || item.getOpened() != null && stockBlank.getOperationDate() != null && stockBlank.getOperationDate().before(item.getOpened()) || item.getClosed() != null && stockBlank.getOperationDate() != null && stockBlank.getOperationDate().after(item.getClosed())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    stockBlank.getControlMessages().add(RegisterStockOrderHelper.createMessage(MessageType.ERROR, StockControlInterceptor_NoValidator, null, salesPoint.toString(), validator));
                    stockBlank.setControlStatus(StockBlankControlStatus.ERROR);
                    StockControlInterceptor.updateProductMessages(stockBlank, product);
                    return;
                }
            }
        }
        stockBlank.setControlStatus(StockBlankControlStatus.OK);
    }

    private static <P extends BaseProduct> void updateProductMessages(StockBlank stockBlank, P product) {
        if (product == null) {
            return;
        }
        StockControlProductHandler handler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findStockControlHandler(product.getClass());
        if ((handler.getStatus(product) == ProductStatus.EXCHANGE || handler.getStatus(product) == ProductStatus.REFUND) && handler.getPreviousProduct(product) != null && handler.getTicketType(handler.getPreviousProduct(product)) == TicketType.OWN && handler.getStatus(handler.getPreviousProduct(product)) == ProductStatus.SELL) {
            StockControlInterceptor.updateProductMessages(stockBlank, handler.getPreviousProduct(product));
        }
        for (Message message : stockBlank.getControlMessages()) {
            if (message.getType() != MessageType.ERROR) continue;
            ValidationMessage item = new ValidationMessage();
            item.setCategory(ValidationMessageCategory.STOCK_CONTROL);
            item.setSeverity(ValidationMessageSeverity.ERROR);
            item.setMessage(message.getMessage());
            handler.getValidationMessages(product).add(item);
        }
    }

    private StockBlankIndex findBlank(List<StockBlankIndex> relatedBlanks, BaseProduct bp, String scn) {
        if (bp == null) {
            return null;
        }
        for (StockBlankIndex index : relatedBlanks) {
            if (!bp.getUid().equals(index.getProductUid()) || !scn.equals(index.getNumber())) continue;
            return index;
        }
        return null;
    }

    private List<String> buildOrderItems(StockOrder order) {
        ArrayList<String> result = new ArrayList<String>();
        for (OrderItem item : order.getItems()) {
            StringBuilder sb = new StringBuilder();
            sb.append(item.getBlanksCount());
            sb.append(' ').append(item.getFirstBlankNumber());
            sb.append(' ').append(item.getBlankType());
            sb.append(' ').append(item.getOwner());
            sb.append(' ').append(item.getTariffType());
            result.add(sb.toString());
        }
        return result;
    }

    private static void reserveBlanksForStockOrder(StockOrder order, List<Message> messages) throws Exception {
        for (OrderItem item : order.getItems()) {
            int i = 0;
            while ((long)i < item.getBlanksCount()) {
                EntityContainer blankContainer;
                StockBlank blank;
                String blankNumber = FormattedNumberUtil.add((String)item.getFirstBlankNumber(), (long)i);
                EntityReference<StockBlank> blankReference = StockControlInterceptor.findBlank(blankNumber, item, messages);
                if (blankReference != null && !(blank = (StockBlank)(blankContainer = EntityStorage.get().resolve(blankReference)).getEntity()).isReserved()) {
                    blank.setReserved(true);
                    EntityStorage.get().save(blankContainer, false);
                }
                ++i;
            }
        }
    }

    private static void unreserveBlanksForStockOrder(StockOrder order, List<Message> messages) throws Exception {
        for (OrderItem item : order.getItems()) {
            int i = 0;
            while ((long)i < item.getBlanksCount()) {
                EntityContainer blankContainer;
                StockBlank blank;
                String blankNumber = FormattedNumberUtil.add((String)item.getFirstBlankNumber(), (long)i);
                EntityReference<StockBlank> blankReference = StockControlInterceptor.findBlank(blankNumber, item, messages);
                if (blankReference != null && (blank = (StockBlank)(blankContainer = EntityStorage.get().resolve(blankReference)).getEntity()).isReserved()) {
                    blank.setReserved(false);
                    EntityStorage.get().save(blankContainer, false);
                }
                ++i;
            }
        }
    }

    private static void unreserveBlanksForDeletedOrderItems(StockOrder newOrder, StockOrder oldOrder, List<Message> messages) throws Exception {
        oldOrder.getItems().removeAll(newOrder.getItems());
        for (OrderItem item : oldOrder.getItems()) {
            int i = 0;
            while ((long)i < item.getBlanksCount()) {
                EntityContainer blankContainer;
                StockBlank blank;
                String blankNumber = FormattedNumberUtil.add((String)item.getFirstBlankNumber(), (long)i);
                EntityReference<StockBlank> blankReference = StockControlInterceptor.findBlank(blankNumber, item, messages);
                if (blankReference != null && (blank = (StockBlank)(blankContainer = EntityStorage.get().resolve(blankReference)).getEntity()).isReserved()) {
                    blank.setReserved(false);
                    EntityStorage.get().save(blankContainer, false);
                }
                ++i;
            }
        }
    }

    private static EntityReference<StockBlank> findBlank(String blankNumber, OrderItem item, List<Message> messages) {
        try {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)StockBlankIndex.Property.owner.name(), (Object)item.getOwner().getUid()));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)StockBlankIndex.Property.number.name(), (Object)blankNumber));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)StockBlankIndex.Property.usageStatus.name(), (Object)UsageStatus.NEW));
            List data = EntityStorage.get().search(StockBlankIndex.class, query).getData();
            if (data.size() == 0) {
                SystemHelper.addMessage(messages, (String)"StockControlDao_BlankNotFound", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{blankNumber});
                return null;
            }
            if (data.size() > 1) {
                SystemHelper.addMessage(messages, (String)"StockControlDao_FewBlanksFound", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{blankNumber});
                return null;
            }
            StockBlankIndex blankIndex = (StockBlankIndex)data.get(0);
            return blankIndex.getSource();
        }
        catch (Exception e) {
            SystemHelper.addMessage(messages, (String)"StockControlDao_SearchBlankInStockError", (String)e.toString(), (MessageType)MessageType.ERROR, (Object[])new Object[]{item.getFirstBlankNumber()});
            return null;
        }
    }

    private static boolean isRefInAgencyList(List<PersonEmployment> employments, EntityReference<Organization> agencyRef) {
        boolean result = false;
        if (employments != null && agencyRef != null) {
            for (PersonEmployment empl : employments) {
                if (empl.getOrganization() == null || !empl.getOrganization().equals(agencyRef)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private static String agencyList2String(List<PersonEmployment> employments) {
        StringBuilder result = new StringBuilder("");
        if (employments != null) {
            for (PersonEmployment empl : employments) {
                if (empl.getOrganization() == null || !Organization.class.equals((Object)empl.getOrganization().getType())) {
                    result.append(result.length() > 0 ? ", " : "");
                }
                result.append(empl.getOrganization().toString());
            }
        }
        return result.toString();
    }

    private static boolean isAgency(EntityReference<? extends BaseProfile> location) throws Exception {
        if (location == null || !Organization.class.equals((Object)location.getType())) {
            return false;
        }
        EntityContainer ctr = EntityStorage.get().resolve(location);
        if (ctr == null) {
            log.error("unable to load profile " + location);
            return false;
        }
        return ((Organization)ctr.getEntity()).getTypes().contains(OrganizationType.AGENCY);
    }
}

