/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.async.AsyncCommand;
import com.gridnine.xtrip.common.async.AsyncCommandOption;
import com.gridnine.xtrip.common.async.AsyncExecutor;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.profile.OrganizationBalanceIndex;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.db.Callback;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionsInterceptor
implements EntityInterceptor {
    static final Logger log = LoggerFactory.getLogger(TransactionsInterceptor.class);
    private static final String KEY_UPDATE_BOOKING_FILE_INDEX_BALANCE_CALLBACK_ADDED = "key_update_booking_file_index_balance_callback_added";
    private static final String KEY_UPDATE_BOOKING_FILE_INDEX_BALANCE_BOOKING_FILE_LIST = "key_update_booking_file_index_balance_booking_file_list";
    private static final String KEY_UPDATE_ORGANIZATION_INDEX_BALANCE_CALLBACK_ADDED = "key_update_organization_index_balance_callback_added";
    private static final String KEY_UPDATE_ORGANIZATION_INDEX_BALANCE_ORGANIZATION_LIST = "key_update_organization_index_balance_organization_list";

    public double getPriority() {
        return 2.147483647E9;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        BillingTransaction billingTransaction;
        if (BookingFile.class.equals((Object)data.getEntityType())) {
            HashMap<String, String> context = new HashMap<String, String>();
            context.put(IBusStandardContextKeys.VERSION_INFO_DATA_SOURCE.name(), this.getClass().getName());
            context.put(IBusStandardContextKeys.VERSION_INFO_VERSION_NOTES.name(), "onDelete");
            context.put(IBusBookingContextKeys.BOOKING_REFERENCE.name(), (String)data.toReference());
            IntegrationBusFacade.get().getRequestReplyAdapter("finance:delete-booking-file").processSync(context);
            return;
        }
        if (BasePaymentDocument.class.isAssignableFrom(data.getEntityType())) {
            HashMap<String, String> context = new HashMap<String, String>();
            context.put(IBusStandardContextKeys.VERSION_INFO_DATA_SOURCE.name(), this.getClass().getName());
            context.put(IBusStandardContextKeys.VERSION_INFO_VERSION_NOTES.name(), "onDelete");
            context.put(IBusFinanceContextKeys.BASE_PAYMEMT_DOCUMENT_REFERENCE.name(), (String)data.toReference());
            IntegrationBusFacade.get().getRequestReplyAdapter("finance:delete-base-payment-document").processSync(context);
            return;
        }
        if (BillingTransaction.class.isAssignableFrom(data.getEntityType()) && !(billingTransaction = (BillingTransaction)data.getEntity()).isAutoCreated()) {
            HashMap<String, String> context = new HashMap<String, String>();
            context.put(IBusStandardContextKeys.VERSION_INFO_DATA_SOURCE.name(), this.getClass().getName());
            context.put(IBusStandardContextKeys.VERSION_INFO_VERSION_NOTES.name(), "onDelete");
            context.put(IBusFinanceContextKeys.BILLING_TRANSACTION_REFERENCE.name(), (String)data.toReference());
            IntegrationBusFacade.get().getRequestReplyAdapter("finance:delete-billing-transaction").processSync(context);
            return;
        }
        if (Transaction.class.isAssignableFrom(data.getEntityType())) {
            Transaction transaction = (Transaction)data.getEntity();
            this.updateBookingFileIndex(transaction, ss);
            this.updateOrganizationBalanceIndex(transaction, ss);
            return;
        }
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        BillingTransaction billingTransaction;
        if (BookingFile.class.equals((Object)data.getEntityType())) {
            HashMap<String, String> context = new HashMap<String, String>();
            context.put(IBusStandardContextKeys.VERSION_INFO_DATA_SOURCE.name(), this.getClass().getName());
            context.put(IBusStandardContextKeys.VERSION_INFO_VERSION_NOTES.name(), "onSave");
            context.put(IBusBookingContextKeys.BOOKING_REFERENCE.name(), (String)data.toReference());
            IntegrationBusFacade.get().getRequestReplyAdapter("finance:save-booking-file").processSync(context);
            return;
        }
        if (BasePaymentDocument.class.isAssignableFrom(data.getEntityType())) {
            HashMap<String, String> context = new HashMap<String, String>();
            context.put(IBusStandardContextKeys.VERSION_INFO_DATA_SOURCE.name(), this.getClass().getName());
            context.put(IBusStandardContextKeys.VERSION_INFO_VERSION_NOTES.name(), "onSave");
            context.put(IBusFinanceContextKeys.BASE_PAYMEMT_DOCUMENT_REFERENCE.name(), (String)data.toReference());
            IntegrationBusFacade.get().getRequestReplyAdapter("finance:save-base-payment-document").processSync(context);
            return;
        }
        if (BillingTransaction.class.isAssignableFrom(data.getEntityType()) && !(billingTransaction = (BillingTransaction)data.getEntity()).isAutoCreated()) {
            HashMap<String, String> context = new HashMap<String, String>();
            context.put(IBusStandardContextKeys.VERSION_INFO_DATA_SOURCE.name(), this.getClass().getName());
            context.put(IBusStandardContextKeys.VERSION_INFO_VERSION_NOTES.name(), "onSave");
            context.put(IBusFinanceContextKeys.BILLING_TRANSACTION_REFERENCE.name(), (String)data.toReference());
            IntegrationBusFacade.get().getRequestReplyAdapter("finance:save-billing-transaction").processSync(context);
            return;
        }
        if (Transaction.class.isAssignableFrom(data.getEntityType())) {
            Transaction transaction = (Transaction)data.getEntity();
            this.updateBookingFileIndex(transaction, ss);
            this.updateOrganizationBalanceIndex(transaction, ss);
            return;
        }
    }

    private void updateBookingFileIndex(Transaction transaction, SessionCallback ss) {
        if ("true".equals(System.getProperty("booking-file-index-balance-update.disabled"))) {
            return;
        }
        if (transaction.getBooking() == null) {
            return;
        }
        final Set bookingFiles = (Set)LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getParameters().computeIfAbsent(KEY_UPDATE_BOOKING_FILE_INDEX_BALANCE_BOOKING_FILE_LIST, key -> new HashSet());
        bookingFiles.add(transaction.getBooking());
        if (Boolean.TRUE.equals(LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getParameters().get(KEY_UPDATE_BOOKING_FILE_INDEX_BALANCE_CALLBACK_ADDED))) {
            return;
        }
        LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getParameters().put(KEY_UPDATE_BOOKING_FILE_INDEX_BALANCE_CALLBACK_ADDED, Boolean.TRUE);
        ss.addCallback(new Callback(){
            private static final long serialVersionUID = -7417023983409716924L;

            public void execute(SessionCallback ss1) {
                AsyncExecutor.get().execute(this.getClass().getName(), (AsyncCommand & Serializable)() -> {
                    for (EntityReference bookingFile : bookingFiles) {
                        try {
                            EntityContainer bookingFileContainer = EntityStorage.get().resolve(bookingFile);
                            if (bookingFileContainer == null) continue;
                            LogicalStorage.get().getEntityStorage().updateIndexes(bookingFileContainer, bookingFileContainer, Collections.singleton(BookingFileIndex.class), false);
                        }
                        catch (Exception e) {
                            log.error("unable to rebuild booking file index of " + bookingFile, (Throwable)e);
                        }
                    }
                }, new AsyncCommandOption[0]);
            }
        });
    }

    private void updateOrganizationBalanceIndex(Transaction transaction, SessionCallback ss) throws Exception {
        if ("true".equals(System.getProperty("organization-balance-index-handler.disabled"))) {
            return;
        }
        if ("true".equals(System.getProperty("organization-index-balance-update.disabled"))) {
            return;
        }
        if (transaction.getOrganization() == null) {
            return;
        }
        final Set organizations = (Set)LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getParameters().computeIfAbsent(KEY_UPDATE_ORGANIZATION_INDEX_BALANCE_ORGANIZATION_LIST, key -> new HashSet());
        organizations.add(transaction.getOrganization());
        if (Boolean.TRUE.equals(LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getParameters().get(KEY_UPDATE_ORGANIZATION_INDEX_BALANCE_CALLBACK_ADDED))) {
            return;
        }
        LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getParameters().put(KEY_UPDATE_ORGANIZATION_INDEX_BALANCE_CALLBACK_ADDED, Boolean.TRUE);
        ss.addCallback(new Callback(){
            private static final long serialVersionUID = -1691393019764183341L;

            public void execute(SessionCallback ss1) {
                AsyncExecutor.get().execute(this.getClass().getName(), (AsyncCommand & Serializable)() -> {
                    for (EntityReference organization : organizations) {
                        try {
                            EntityContainer orgnizationContainer = EntityStorage.get().resolve(organization);
                            LogicalStorage.get().getEntityStorage().updateIndexes(orgnizationContainer, orgnizationContainer, Collections.singleton(OrganizationBalanceIndex.class), false);
                        }
                        catch (Exception e) {
                            log.error("unable to rebuild organziation balance index of " + organization, (Throwable)e);
                        }
                    }
                }, new AsyncCommandOption[0]);
            }
        });
    }
}

