/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.forOfPayment.OrganizationFOPCheckRules;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.TrashBinItemType;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.qualityCheck.OrganizationQualityCheckRules;
import com.gridnine.xtrip.common.model.system.AccountingEntry;
import com.gridnine.xtrip.common.model.system.BaseSystemSettings;
import com.gridnine.xtrip.common.model.travelPolicy.OrganizationTravelPolicy;
import com.gridnine.xtrip.common.system.model.TrashBinSettings;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.helpers.TrashBinHelper;

public class TrashBinInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 50.0;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (TrashBinHelper.isIgnoreTrashBin()) {
            return;
        }
        Class cls = data.getEntityType();
        TrashBinItemType type = null;
        if (Person.class.equals((Object)cls)) {
            type = TrashBinItemType.PERSON;
        } else if (Organization.class.equals((Object)cls)) {
            type = TrashBinItemType.ORGANIZATION;
        } else if (SalesPoint.class.equals((Object)cls)) {
            type = TrashBinItemType.SALES_POINT;
        } else if (Contract.class.equals((Object)cls)) {
            type = TrashBinItemType.CONTRACT;
        } else if (ModelContract.class.equals((Object)cls)) {
            type = TrashBinItemType.MODEL_CONTRACT;
        } else if (TripartiteContract.class.equals((Object)cls)) {
            type = TrashBinItemType.TRIPARTITE_CONTRACT;
        } else if (AccountingEntry.class.equals((Object)cls)) {
            type = TrashBinItemType.ACCOUNTING_ENTRY;
        } else if (BookingFile.class.equals((Object)cls)) {
            type = TrashBinItemType.BOOKING_FILE;
        } else if (UniversalProductDescription.class.equals((Object)cls)) {
            type = TrashBinItemType.UNIVERSAL_PRODUCT_DESCRIPTION;
        } else if (Receipt.class.equals((Object)cls)) {
            type = TrashBinItemType.RECEIPT;
        } else if (Shipment.class.equals((Object)cls) && !TrashBinInterceptor.isNotCreateShipmentTrashBinItems()) {
            type = TrashBinItemType.SHIPMENT;
        } else if (BaseSystemSettings.class.isAssignableFrom(cls)) {
            type = TrashBinItemType.SYSTEM_SETTINGS;
        } else if (OrganizationQualityCheckRules.class.equals((Object)cls)) {
            type = TrashBinItemType.ORGANIZATION_QUALITY_CHECK_RULES;
        } else if (OrganizationFOPCheckRules.class.equals((Object)cls)) {
            type = TrashBinItemType.ORGANIZATION_FOP_CHECK_RULES;
        } else if (OrganizationTravelPolicy.class.equals((Object)cls)) {
            type = TrashBinItemType.ORGANIZATION_TRAVEL_POLICY;
        }
        if (type == null) {
            return;
        }
        TrashBinHelper.createTrashBinItem(type, data, ss);
    }

    private static boolean isNotCreateShipmentTrashBinItems() {
        EntityContainer ctr = EntityStorage.get().load(TrashBinSettings.class, UniqueSettingsRegistry.get().getUidByClassName(TrashBinSettings.class.getName()));
        return ctr != null && ((TrashBinSettings)ctr.getEntity()).isNotCreateShipmentTrashBinItems();
    }
}

