/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.misc.BlankTypePolicy;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductIndex;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.UniversalProductHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.validation.UniversalProductMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberHelper;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.model.interceptors.ProductsHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalProductInterceptor
implements EntityInterceptor {
    public static final double PRIORITY = 2.03;

    public double getPriority() {
        return 2.03;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        EntityContainer<?> bookingFileContainer = data;
        EntityContainer oldBookingFileContainer = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        for (Reservation res : bookingFile.getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                if (!(prod instanceof UniversalProduct)) continue;
                UniversalProduct product = (UniversalProduct)prod;
                boolean isNewProduct = ProductsHelper.isNewProduct((EntityContainer<BookingFile>)oldBookingFileContainer, (BaseProduct)product);
                this.updateProduct(product, isNewProduct);
            }
        }
    }

    private void updateProduct(UniversalProduct product, boolean isNewProduct) throws Exception {
        this.generateFops(product);
        this.updateBranch(product);
        ArrayList<ValidationMessage> additionalMessages = new ArrayList<ValidationMessage>();
        UniversalProductDescription description = this.getDescription(product, additionalMessages);
        this.updateBlankOwnerAndSupplier(product, description);
        if (product.getStatus() == null) {
            product.setStatus(ProductStatus.SELL);
        }
        if (product.getLocalIssueDate() == null) {
            product.setLocalIssueDate(product.getIssueDate());
        }
        if (isNewProduct) {
            this.updateFops(product);
        }
        UniversalProductHelper.updateVat((UniversalProduct)product);
        if (description != null) {
            if (description.getBlankTypePolicy() == BlankTypePolicy.PRINTED_OR_ETICKET || description.getBlankTypePolicy() == BlankTypePolicy.ONLY_ETICKET) {
                UniversalProductInterceptor.updateScnAndEticketFlag(product);
            }
            if (description.isAutoGeneratedSystemNumbers() && TextUtil.isBlank((String)product.getSystemNumber())) {
                do {
                    product.setSystemNumber(null);
                    this.updateSystemNumber(product);
                } while (this.isSystemNumberExists(product));
            }
        }
    }

    private boolean isSystemNumberExists(UniversalProduct product) {
        SearchQuery query = new SearchQuery();
        query.setResultMode(ResultMode.COUNT_ONLY);
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)UniversalProductIndex.Property.description.name(), (Object)product.getDescription()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)UniversalProductIndex.Property.ticketNumber.name(), (Object)product.getSystemNumber()));
        return EntityStorage.get().search(UniversalProductIndex.class, query).getTotalCount() > 0;
    }

    private void updateSystemNumber(final UniversalProduct product) throws Exception {
        SequenceNumberHelper.get().generateInc(new CompositeNumber(){

            public void setNumberSuffix(String value) {
            }

            public void setNumberPrefix(String value) {
            }

            public void setNumber(String value) {
                product.setSystemNumber(value);
            }

            public String getNumberSuffix() {
                return null;
            }

            public String getNumberPrefix() {
                return null;
            }

            public String getNumber() {
                return product.getSystemNumber();
            }
        }, String.format("universal_product.%s", product.getDescription().getUid()), null);
    }

    private static void updateScnAndEticketFlag(final UniversalProduct product) {
        ProductsHelper.updateScnAndEticketFlag(new ProductsHelper.BlankTypeHandler(){

            @Override
            public void setEticket(boolean value) {
                product.setEticket(value);
            }

            @Override
            public String getSystemNumber() {
                return product.getSystemNumber();
            }

            @Override
            public int getConjunctionsCount() {
                return 0;
            }

            @Override
            public DictionaryReference<BlankType> getBlankType() {
                return product.getBlankType();
            }

            @Override
            public void clearSCN() {
                product.setScn(null);
            }

            @Override
            public void addSCN(String value) {
                product.setScn(value);
            }
        });
    }

    private void generateFops(UniversalProduct product) {
        ProductHandler handler = ProductHandler.of((BaseProduct)product);
        boolean isFareFopsRelevant = handler.isFareFopsRelevant((BaseProduct)product);
        List contractRelations = UniversalProductHelper.getContractRelations((UniversalProduct)product);
        for (GeneralProductContractRelationData relation : contractRelations) {
            List fops;
            if (!isFareFopsRelevant) {
                relation.getFops().removeIf(f -> GeneralProductHelper.productFopTypes.contains(GeneralProductHelper.getFopType((GeneralProductFop)f)));
                continue;
            }
            BigDecimal price = product.getEquivalentFare();
            if (price == null || price.compareTo(BigDecimal.ZERO) == 0 || !GeneralProductHelper.filterFops((Collection)(fops = relation.getFops()), (Set)GeneralProductHelper.productFopTypes, null, null).isEmpty()) continue;
            GeneralProductFop fop = this.generateFop(product);
            fop.setType(PaymentType.CASH);
            fop.setEquivalentAmount(product.getEquivalentFare());
            fops.add(fop);
        }
    }

    private GeneralProductFop generateFop(UniversalProduct product) {
        GeneralProductFop fop = new GeneralProductFop();
        fop.setType(PaymentType.CASH);
        fop.setOperationDate(null);
        fop.setAgent(null);
        return fop;
    }

    private void updateBranch(UniversalProduct product) throws Exception {
        if (product.getBranch() != null) {
            return;
        }
        EntityContainer salesPointContainer = EntityStorage.get().resolve(product.getSalesPoint());
        if (salesPointContainer != null) {
            product.setBranch(((SalesPoint)salesPointContainer.getEntity()).getBranch());
        }
    }

    private UniversalProductDescription getDescription(UniversalProduct ticket, List<ValidationMessage> additionalMessages) {
        Logger log = LoggerFactory.getLogger(this.getClass());
        if (ticket.getDescription() == null) {
            log.warn(String.format("product %s: description is null", ticket.getSystemNumber()));
            additionalMessages.add(MessageHelper.createValidationMessage((ValidationMessageType)UniversalProductMessageType.UNIVERSAL_PRODUCT_DESCRIPTION_IS_NULL, null, (Object[])new Object[0]));
            return null;
        }
        try {
            EntityContainer descriptionContainer = EntityStorage.get().resolve(ticket.getDescription());
            if (descriptionContainer == null) {
                additionalMessages.add(MessageHelper.createValidationMessage((ValidationMessageType)UniversalProductMessageType.UNIVERSAL_PRODUCT_UNABLE_TO_LOAD_DESCRIPTION, null, (Object[])new Object[0]));
                log.warn(String.format("product %s: description %s is absent in DB", ticket.getSystemNumber(), ticket.getDescription()));
                return null;
            }
            return (UniversalProductDescription)descriptionContainer.getEntity();
        }
        catch (Exception e) {
            log.error("unable to resolve reference " + ticket.getDescription(), (Throwable)e);
            additionalMessages.add(MessageHelper.createValidationMessage((ValidationMessageType)UniversalProductMessageType.UNIVERSAL_PRODUCT_UNABLE_TO_LOAD_DESCRIPTION, (Throwable)e, (Object[])new Object[0]));
            return null;
        }
    }

    private void updateBlankOwnerAndSupplier(UniversalProduct ticket, UniversalProductDescription description) throws Exception {
        if (UniversalProductHelper.getSupplier((UniversalProduct)ticket) != null && ticket.getBlankOwner() != null) {
            return;
        }
        if (description == null) {
            return;
        }
        if (!description.isBlankOwnerAndSupplierAreAgency()) {
            return;
        }
        EntityReference agencyRef = UniversalProductHelper.getAgency((UniversalProduct)ticket);
        if (agencyRef == null) {
            agencyRef = ticket.getReservation().getBookingFile().getAgency();
        }
        ticket.setBlankOwner(agencyRef);
        UniversalProductHelper.setSupplier((UniversalProduct)ticket, (EntityReference)agencyRef);
        if (UniversalProductHelper.getSubagency((UniversalProduct)ticket) == null) {
            UniversalProductHelper.setSubagency((UniversalProduct)ticket, (EntityReference)agencyRef);
        }
    }

    private void updateFops(UniversalProduct product) {
        List contractRelations = UniversalProductHelper.getContractRelations((UniversalProduct)product);
        EntityReference salesPointRef = product.getSalesPoint();
        Date operationDate = product.getIssueDate();
        EntityReference<Person> agent = product.getAgent();
        if (agent == null) {
            try {
                agent = ProfileDao.findCurrentAgent(null);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("unable to find current agent", (Throwable)e);
            }
        }
        operationDate = null;
        agent = null;
        ProductsHelper.updateFops(contractRelations, (EntityReference<SalesPoint>)salesPointRef, operationDate, agent);
    }
}

