/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.DeskEntry;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.assets.Workspace;
import com.gridnine.xtrip.common.model.cache.common.AssetReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.AssetStorageOperationStartedInterceptor;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.util.Date;
import java.util.List;

public class UserAccountInterceptor
implements AssetStorageOperationStartedInterceptor {
    public double getPriority() {
        return 0.0;
    }

    public void beforeSave(SessionCallback ss, BaseAsset data) throws Exception {
        if (data instanceof UserAccount) {
            UserAccount account = (UserAccount)data;
            UserAccount oldAccount = (UserAccount)LogicalStorage.get().getAssetStorage().getLocalOperationContext(new AssetReference((BaseAsset)account)).getOldAsset();
            if (oldAccount == null || !MiscUtil.equals((Object)oldAccount.getPasswordDigest(), (Object)account.getPasswordDigest())) {
                account.getPasswordDigests().add(account.getPasswordDigest());
                account.setPasswordLastUpdateDate(new Date());
                account.setTemporarilyBlockDate(null);
            }
            if (oldAccount == null || oldAccount.isActive() != account.isActive()) {
                account.setActiveLastUpdateDate(new Date());
            }
        }
    }

    public void beforeDelete(SessionCallback ss, BaseAsset data) throws Exception {
        if (data instanceof UserAccount) {
            UserAccount account = (UserAccount)data;
            this.deleteLogin(account.getLoginName());
            this.deleteUserLocks(account.getLoginName());
        }
    }

    private void deleteUserLocks(String loginName) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)DeskEntry.Property.owner.name(), (Object)loginName));
        List entries = AssetsStorage.get().search(DeskEntry.class, query).getData();
        for (DeskEntry entry : entries) {
            AssetsStorage.get().delete((BaseAsset)entry);
        }
    }

    private void deleteLogin(String loginName) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.loginName.name(), (Object)loginName));
        for (PersonIndex index : EntityStorage.get().search(PersonIndex.class, query).getData()) {
            EntityContainer ctr = EntityStorage.get().resolve(index.getSource());
            if (ctr == null) continue;
            ((Person)ctr.getEntity()).setLoginName(null);
            EntityStorage.get().save(ctr, false);
            SysLogHelper.audit(ctr.toReference(), "entity-modification", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.UserAccountInterceptor_userAccountDeleted, (Object[])new Object[]{loginName}));
        }
        query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)Workspace.Property.owner.name(), (Object)loginName));
        query.getPreferredProperties().add(Workspace.Property.owner.name());
        for (Workspace workspace : AssetsStorage.get().search(Workspace.class, query).getData()) {
            AssetsStorage.get().delete((BaseAsset)workspace);
        }
    }
}

