/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.licence;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.system.LicenceDocumentStatus;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.RsaUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.LicenceHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.dbproperties.LogicalDBPropertiesStorage;
import com.gridnine.xtrip.server.licence.Address;
import com.gridnine.xtrip.server.licence.RequestType;
import com.gridnine.xtrip.server.model.licence.LicenceDocumentRequest;
import com.gridnine.xtrip.server.model.licence.LicenceDocumentResponse;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeoutException;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenceChecker
implements Disposable {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int CHECKING_PERIOD = 3600000;
    private static final int CHECKING_DELAY = 60000;
    public static String MAC = "MAC";
    public static String HOSTNAME = "HOSTNAME";
    public static String USERNAME = "USERNAME";
    public static String SYSTEM = "SYSTEM";
    public static String IP = "IP";
    public static String INSTALLATIONID = "INSTALLATIONID";
    public static String AGENCIES = "AGENCIES";
    public static int AGENCIES_MAX_LENGTH = 1000;
    private static final String USER_AGENT = "Mozilla/5.0";
    private static final String URL_FOR_IP_1 = "https://api.ipify.org/";
    private static final String URL_FOR_IP_2 = "http://bot.whatismyipaddress.com/";
    private Timer timer;
    private final SimpleDateFormat sdf = new SimpleDateFormat();

    public void configure(ExtendedProperties config) throws Exception {
        if (!this.isLicenceCheckNeeded()) {
            this.log.info("LicenceChecker disabled for this project, because it has NoLicence extension point in one of its plugin.xml");
            return;
        }
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                LicenceChecker.this.checkLicence();
            }
        }, 60000L, 3600000L);
        this.log.info("LicenceChecker configured");
    }

    private boolean isLicenceCheckNeeded() {
        return !LicenceChecker.hasExtensionEndsWith("NoLicenceChecker");
    }

    public static boolean hasExtensionEndsWith(String suffix) {
        for (PluginDescriptor descr : PluginManager.lookup(JpfUtil.class).getRegistry().getPluginDescriptors()) {
            for (Extension ext : descr.getExtensions()) {
                if (ext.getId() == null || !ext.getId().endsWith(suffix)) continue;
                return true;
            }
        }
        return false;
    }

    void checkLicence() {
        this.log.debug("LicenceChecker started");
        LogicalDBPropertiesStorage dbProps = LogicalStorage.get().getDbPropertiesStorage();
        try {
            byte[] licenceId;
            ValueHolder ipAddress = new ValueHolder();
            LicenceDocumentResponse licenceResponse = this.requestForLicenceId((ValueHolder<String>)ipAddress);
            if (licenceResponse != null && LicenceDocumentStatus.VALID.equals((Object)licenceResponse.getStatus())) {
                dbProps.putValue("com.gridnine.xtrip.server.licence.LastValidDate", this.sdf.format(new Date()));
                this.log.debug("We are in whitelist => no licence checking");
                return;
            }
            byte[] byArray = licenceId = licenceResponse != null ? licenceResponse.getLicenceId() : null;
            if (licenceId != null && licenceId.length > 0) {
                LicenceDocumentStatus status;
                String specialData = this.collectHardwareInfo();
                String desKey = DesUtil.generateKey();
                String encryptedSpecialData = DesUtil.encrypt((char[])desKey.toCharArray(), (String)specialData);
                byte[] encryptedDesKey = this.encryptDataRSA(desKey, licenceId);
                if (encryptedDesKey == null || encryptedDesKey.length == 0) {
                    encryptedDesKey = specialData.getBytes();
                }
                if (LicenceDocumentStatus.VALID.equals((Object)(status = this.requestForLicenceStatus(licenceId, encryptedSpecialData, encryptedDesKey, (String)ipAddress.getValue()))) || LicenceDocumentStatus.VALID_DUPLICATE.equals((Object)status)) {
                    dbProps.putValue("com.gridnine.xtrip.server.licence.LastValidDate", this.sdf.format(new Date()));
                    this.log.debug(String.format("Licence status: %s, new licenceID: %s", status.name(), new String(licenceId)));
                    if (LicenceDocumentStatus.VALID_DUPLICATE.equals((Object)status)) {
                        this.log.debug("Duplicate licence found!");
                    }
                } else if (LicenceDocumentStatus.INVALID.equals((Object)status)) {
                    this.log.error(String.format("licence not valid, licenceID: %s, licenceStatus: %s", new String(licenceId), status.toString()));
                    LicenceHelper.stopApplication();
                } else if (LicenceDocumentStatus.UNKNOWN.equals((Object)status) || status == null) {
                    this.log.debug("Null status received, checking last date");
                    this.checkLastValidDateAndStopIfNeeded(dbProps);
                }
            } else {
                this.checkLastValidDateAndStopIfNeeded(dbProps);
            }
        }
        catch (Exception ex) {
            this.log.debug("exception while checking licence", (Throwable)ex);
            this.checkLastValidDateAndStopIfNeeded(dbProps);
        }
        this.log.debug("LicenceChecker finished");
    }

    private byte[] encryptDataRSA(String specialData, byte[] licenceId) {
        byte[] res = null;
        if (TextUtil.isBlank((String)specialData)) {
            return null;
        }
        try {
            res = RsaUtil.encrypt((byte[])specialData.getBytes(), (byte[])licenceId, (int)RsaUtil.SIZE_2048);
        }
        catch (Exception e) {
            this.log.debug("exception while encrypting data", (Throwable)e);
        }
        return res;
    }

    private String getHostName() {
        InetAddress ip = LicenceHelper.getIpAddress();
        return ip != null ? ip.getHostName() : "";
    }

    private String collectHardwareInfo() {
        String username;
        String hostName;
        String sys;
        this.log.debug("Collecting hardware info...");
        InetAddress ip = LicenceHelper.getIpAddress();
        StringBuilder res = new StringBuilder();
        NetworkInterface network = null;
        try {
            if (ip != null) {
                network = NetworkInterface.getByInetAddress(ip);
            }
        }
        catch (SocketException e) {
            this.log.error("Error while obtainig NetworkInterface");
        }
        if (network != null) {
            try {
                byte[] mac = network.getHardwareAddress();
                StringBuilder sb = new StringBuilder();
                if (mac != null) {
                    for (int i = 0; i < mac.length; ++i) {
                        sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                    }
                    res.append(res.length() > 0 ? ";" : "").append(MAC).append("=").append(sb.toString());
                    this.log.debug("MAC address: " + sb.toString());
                }
                this.log.debug("MAC address is not determined");
            }
            catch (SocketException e) {
                this.log.debug("Failed to determine MAC");
                e.printStackTrace();
            }
        }
        if ((sys = System.getProperty("os.name")) != null && sys.toLowerCase().contains("win")) {
            String REGSTR_LOCATION = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion";
            String REGSTR_KEY = "ProductId";
            String REGSTR_64BIT_PARAM = " /reg:64";
            try {
                String resp = ExecuteCmdUtil.getProductIdWindows("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", "ProductId", this.log);
                if (TextUtil.isBlank((String)resp)) {
                    resp = ExecuteCmdUtil.getProductIdWindows("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", "ProductId /reg:64", this.log);
                }
                if (!TextUtil.isBlank((String)resp)) {
                    res.append(res.length() > 0 ? ";" : "").append(INSTALLATIONID).append("=").append(resp);
                }
                this.log.debug("Win detected, InstallationId = " + resp);
            }
            catch (Exception e) {
                this.log.error("Exception during registry access to get ProductId on Windows");
            }
        } else {
            String LINUX_CMD = "cat /var/lib/dbus/machine-id";
            try {
                String resp = ExecuteCmdUtil.getProductIdLinux("cat /var/lib/dbus/machine-id", this.log);
                if (!TextUtil.isBlank((String)resp)) {
                    res.append(res.length() > 0 ? ";" : "").append(INSTALLATIONID).append("=").append(resp);
                }
                this.log.debug("Linux detected, InstallationId = " + resp);
            }
            catch (Exception e) {
                this.log.error("Exception during access to machine-id on Linux");
            }
        }
        String agenciesString = this.collectAgencies();
        if (!TextUtil.isBlank((String)agenciesString)) {
            res.append(res.length() > 0 ? ";" : "").append(AGENCIES).append("=").append(agenciesString);
        }
        if (!TextUtil.isBlank((String)(hostName = this.getHostName()))) {
            res.append(res.length() > 0 ? ";" : "").append(HOSTNAME).append("=").append(hostName);
        }
        if (!TextUtil.isBlank((String)sys)) {
            res.append(res.length() > 0 ? ";" : "").append(SYSTEM).append("=").append(sys);
        }
        if (!TextUtil.isBlank((String)(username = System.getProperty("user.name")))) {
            res.append(res.length() > 0 ? ";" : "").append(USERNAME).append("=").append(username);
        }
        return res.toString();
    }

    private String collectAgencies() {
        StringBuilder res = new StringBuilder();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.AGENCY));
        List orgIndices = EntityStorage.get().search(OrganizationIndex.class, query).getData();
        for (OrganizationIndex ind : orgIndices) {
            if (ind.getShortName() != null && ind.getShortName().getValues() != null) {
                String shortName = (String)ind.getShortName().getValues().get(LocaleUtil.LOCALE_RU);
                if (TextUtil.isBlank((String)shortName)) {
                    shortName = (String)ind.getShortName().getValues().get(LocaleUtil.LOCALE_EN);
                }
                if (TextUtil.isBlank((String)shortName)) {
                    shortName = (String)ind.getShortName().getValues().get(Locale.ROOT);
                }
                if (!TextUtil.isBlank((String)shortName) && res.length() + shortName.length() < AGENCIES_MAX_LENGTH) {
                    res.append(res.length() > 0 ? " | " : "").append(shortName);
                }
            }
            if (res.length() <= AGENCIES_MAX_LENGTH) continue;
            break;
        }
        return res.toString();
    }

    private void checkLastValidDateAndStopIfNeeded(LogicalDBPropertiesStorage dbProps) {
        try {
            String s = dbProps.getValue("com.gridnine.xtrip.server.licence.LastValidDate");
            if (s != null) {
                if (new Date().getTime() - this.sdf.parse(s).getTime() > 864000000L) {
                    this.log.error("licence not valid, maximum valid interval exceeded");
                    LicenceHelper.stopApplication();
                }
            } else {
                s = this.sdf.format(new Date());
                dbProps.putValue("com.gridnine.xtrip.server.licence.LastValidDate", s);
            }
            this.log.warn(String.format("licence expiration date is %s", this.sdf.format(new Date(this.sdf.parse(s).getTime() + 864000000L))));
        }
        catch (Exception e) {
            this.log.error("Exception happened while checking last valid date for licence", (Throwable)e);
        }
    }

    private SynchronizationResponse<LicenceDocumentResponse> processRequest(LicenceDocumentRequest data) {
        SynchronizationRequest<LicenceDocumentRequest> request = new SynchronizationRequest<LicenceDocumentRequest>();
        request.setClientId(Environment.getApplicationId());
        request.setData(data);
        request.setOperationId("licence-document-processing");
        request.setUser("licence-checker");
        ValueHolder trace = new ValueHolder();
        return SynchronizationHelper.execute(request, Address.getSync(), (ValueHolder<String>)trace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LicenceDocumentResponse requestForLicenceId(ValueHolder<String> ipAddress) {
        LicenceDocumentRequest data = new LicenceDocumentRequest();
        data.setAppId(Environment.getApplicationId());
        data.setRequestType(RequestType.GET_NEW_ID);
        ipAddress.setValue((Object)LicenceHelper.getIpAddressStr());
        data.setIpAddress((String)ipAddress.getValue());
        StringBuilder traceString = new StringBuilder();
        SynchronizationResponse<LicenceDocumentResponse> response = this.processRequest(data);
        LicenceDocumentResponse licenceResponse = null;
        try {
            for (Message msg : response.getMessages()) {
                if (msg.getType() != MessageType.ERROR) continue;
                this.log.warn("Request to LicenceServer for licenceID had errors: " + msg.getMessage());
                traceString.append("\r\nError while requesting for the LicenceID: ").append(msg.getMessage());
                LicenceDocumentResponse licenceDocumentResponse = null;
                return licenceDocumentResponse;
            }
            licenceResponse = response.getData();
        }
        catch (Exception e) {
            this.log.error("Unable to request for the LicenceID", (Throwable)e);
            traceString.append(String.format("\r\nUnable to request for the LicenceID:\n %s", TextUtil.getExceptionStackTrace((Throwable)e)));
        }
        finally {
            SynchronizationHelper.log(traceString.toString(), "licence-document-processing");
        }
        return licenceResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LicenceDocumentStatus requestForLicenceStatus(byte[] licenceId, String encryptedSpecialData, byte[] encryptedDesKey, String ipAddress) {
        LicenceDocumentStatus res = null;
        LicenceDocumentRequest data = new LicenceDocumentRequest();
        data.setAppId(Environment.getApplicationId());
        data.setRequestType(RequestType.CHECK_ID);
        data.setLastUpdateDate(LicenceHelper.getLastUpdateDate());
        data.setSpecialData(encryptedDesKey);
        data.setEncryptedSpecialData(encryptedSpecialData);
        data.setLicenceId(licenceId);
        data.setIpAddress(ipAddress);
        StringBuilder traceString = new StringBuilder();
        SynchronizationResponse<LicenceDocumentResponse> response = this.processRequest(data);
        try {
            for (Message msg : response.getMessages()) {
                if (msg.getType() != MessageType.ERROR) continue;
                this.log.warn("Request to LicenceServer for licence status had errors: " + msg.getMessage());
                traceString.append("\r\nError while requesting for the licence status: ").append(msg.getMessage());
                LicenceDocumentStatus licenceDocumentStatus = null;
                return licenceDocumentStatus;
            }
            LicenceDocumentResponse licenceResponse = response.getData();
            if (licenceResponse != null) {
                res = licenceResponse.getStatus();
            }
        }
        catch (Exception e) {
            this.log.error("Unable to request for the licence status", (Throwable)e);
            traceString.append(String.format("\r\nUnable to request for the licence status:\n %s", TextUtil.getExceptionStackTrace((Throwable)e)));
        }
        finally {
            SynchronizationHelper.log(traceString.toString(), "licence-document-processing");
        }
        return res;
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.log.info("LicenceChecker timer stopped");
    }

    public void dispose() {
        this.stop();
    }

    public static class ExecuteCmdUtil {
        private static StringWriter sw = new StringWriter();

        public static String getProductIdWindows(String location, String key, Logger log) {
            String command = "reg query \"" + location + "\" /v " + key;
            try {
                ExecuteCmdUtil.executeCommandLine(command, false, false, 1000L);
                String[] parsed = sw.toString().split("\\s+");
                if (parsed.length > 0) {
                    return parsed[parsed.length - 1];
                }
            }
            catch (IOException e) {
                log.error("IOException while reading from Windows regustry");
            }
            catch (InterruptedException e) {
                log.error("InterruptedException while reading from Windows regustry");
            }
            catch (TimeoutException e) {
                log.error("TimeoutException while reading from Windows regustry");
            }
            return null;
        }

        public static String getProductIdLinux(String cmd, Logger log) {
            try {
                ExecuteCmdUtil.executeCommandLine(cmd, false, false, 1000L);
                String[] parsed = sw.toString().split("\\s+");
                if (parsed.length > 0) {
                    return parsed[parsed.length - 1];
                }
            }
            catch (IOException e) {
                log.error("IOException while reading machine-id property in Linux");
            }
            catch (InterruptedException e) {
                log.error("InterruptedException while reading machine-id property in Linux");
            }
            catch (TimeoutException e) {
                log.error("TimeoutException while reading machine-id property in Linux");
            }
            return null;
        }

        private static int executeCommandLine(String commandLine, boolean printOutput, boolean printError, long timeout) throws IOException, InterruptedException, TimeoutException {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(commandLine);
            InputStream is = process.getInputStream();
            Worker worker = new Worker(process);
            worker.start();
            try {
                worker.join(timeout);
                if (worker.getExit() != -1) {
                    int c;
                    while ((c = is.read()) != -1) {
                        sw.write(c);
                    }
                    int n = worker.getExit();
                    return n;
                }
                try {
                    throw new TimeoutException();
                }
                catch (InterruptedException ex) {
                    worker.interrupt();
                    throw ex;
                }
            }
            finally {
                process.destroy();
            }
        }

        private static class Worker
        extends Thread {
            private final Process process;
            private int exit;

            Worker(Process p) {
                this.process = p;
            }

            @Override
            public void run() {
                try {
                    this.exit = this.process.waitFor();
                }
                catch (InterruptedException ignore) {
                    this.exit = -1;
                }
            }

            public int getExit() {
                return this.exit;
            }
        }
    }
}

