/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.licence2;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.export.UrlConnectionInfoSettings;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.config.RegionalVariation;
import com.gridnine.xtrip.common.model.system.licence2.LicenceValidationRequest;
import com.gridnine.xtrip.common.model.system.licence2.LicenceValidationResponse;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.LicenceHelper;
import com.gridnine.xtrip.server.configuration.ServerConfiguration;
import com.gridnine.xtrip.server.licence.Address;
import com.gridnine.xtrip.server.model.licence2.AppConfiguration;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Arrays;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.PluginDescriptor;
import org.w3c.dom.Element;

public class LicenceBasedConfiguration
implements AppConfiguration,
Disposable {
    private static final long MAX_VALID_INTERVAL = 864000000L;
    private static final int CHECKING_PERIOD = 3600000;
    private static final int CHECKING_DELAY = 60000;
    private static final String OPERATION = "licence-validation-processing";
    final Log log = LogFactory.getLog(this.getClass());
    private final File licenceDataFile;
    private final String licenceKey;
    private final boolean offlineLicence;
    private LicenceValidationResponse lastResponse;
    private Timer timer;

    public LicenceBasedConfiguration() throws Exception {
        if (LicenceBasedConfiguration.isLicenceCheckDisabled()) {
            this.licenceDataFile = null;
            this.licenceKey = null;
            this.offlineLicence = true;
            this.lastResponse = new LicenceValidationResponse();
            this.lastResponse.setVaild(true);
            this.lastResponse.getConfiguration().setRegionalVariation(RegionalVariation.RU);
            this.lastResponse.getConfiguration().setOnlineGdsEnabled(true);
            this.lastResponse.getConfiguration().setIbeEnabled(LicenceBasedConfiguration.isPluginPresent(".ibecorp"));
            this.lastResponse.getConfiguration().setRestrictedStorage(false);
            this.lastResponse.getConfiguration().setTravelPolicyAuthEnabled(true);
            this.log.info((Object)"licence check disabled");
            return;
        }
        this.licenceDataFile = new File(Environment.getDataFolder(), "licence.data");
        this.licenceKey = ((ServerConfiguration)Environment.getPublished(ServerConfiguration.class)).getConfiguration().getProperty("licenceKey");
        boolean bl = this.offlineLicence = !TextUtil.isBlank((String)this.licenceKey) && DesUtil.decode((String)this.licenceKey).endsWith("01");
        if (this.licenceDataFile.isFile()) {
            try (InputStream in = DesUtil.getCipherInputStream((InputStream)new FileInputStream(this.licenceDataFile));){
                Element elm = DocumentBuilderHelper.parse((InputStream)in).getDocumentElement();
                this.lastResponse = (LicenceValidationResponse)XHelper.readObject((Element)elm, (String)".");
            }
            catch (Exception e) {
                this.log.warn((Object)"failed loading licence data", (Throwable)e);
            }
        }
        if (!this.isLicenceValid()) {
            this.checkLicence(false);
        }
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    LicenceBasedConfiguration.this.checkLicence(true);
                }
                catch (Exception e) {
                    LicenceBasedConfiguration.this.log.error((Object)"failed checking licence", (Throwable)e);
                }
            }
        }, 60000L, 3600000L);
        this.log.info((Object)"licence check scheduled");
    }

    public void dispose() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public boolean isExtensionLegal(Extension ext) {
        if (!this.isLicenceValid()) {
            throw new IllegalStateException("invalid licence");
        }
        Extension.Parameter param = ext.getParameter("regionalVariation");
        if (param == null) {
            return true;
        }
        String value = param.valueAsString();
        RegionalVariation variation = (RegionalVariation)CollectionUtil.findEnumConstant(RegionalVariation.class, (String)value);
        if (variation == null) {
            return false;
        }
        return this.lastResponse.getConfiguration().getRegionalVariation() == variation;
    }

    @Override
    public RegionalVariation getRegionalVariation() {
        if (!this.isLicenceValid()) {
            throw new IllegalStateException("invalid licence");
        }
        return this.lastResponse.getConfiguration().getRegionalVariation();
    }

    @Override
    public boolean isOnlineGdsEnabled() {
        if (!this.isLicenceValid()) {
            throw new IllegalStateException("invalid licence");
        }
        return this.lastResponse.getConfiguration().isOnlineGdsEnabled();
    }

    @Override
    public boolean isIbeEnabled() {
        if (!this.isLicenceValid()) {
            throw new IllegalStateException("invalid licence");
        }
        return this.lastResponse.getConfiguration().isIbeEnabled();
    }

    @Override
    public boolean isRestrictedStorage() {
        if (!this.isLicenceValid()) {
            throw new IllegalStateException("invalid licence");
        }
        return this.lastResponse.getConfiguration().isRestrictedStorage();
    }

    @Override
    public boolean isShowTuiReports() {
        if (!this.isLicenceValid()) {
            throw new IllegalStateException("invalid licence");
        }
        return this.lastResponse.getConfiguration().isShowTuiReports();
    }

    @Override
    public boolean isTravelPolicyAuthEnabled() {
        if (!this.isLicenceValid()) {
            throw new IllegalStateException("invalid licence");
        }
        return this.lastResponse.getConfiguration().isTravelPolicyAuthEnabled();
    }

    @Override
    public boolean isRedAppCounterEnabled() {
        if (!this.isLicenceValid()) {
            throw new IllegalStateException("invalid licence");
        }
        return this.lastResponse.getConfiguration().isRedAppCounterEnabled();
    }

    @Override
    public boolean isCollectTechnicalFee() {
        if (!this.isLicenceValid()) {
            throw new IllegalStateException("invalid licence");
        }
        return this.lastResponse.getConfiguration().isCollectTechnicalFee();
    }

    @Override
    public Date getCollectTechnicalFeeBeginDate() {
        if (!this.isLicenceValid()) {
            throw new IllegalStateException("invalid licence");
        }
        return this.lastResponse.getConfiguration().getCollectTechnicalFeeBeginDate();
    }

    private static boolean isPluginPresent(String name) {
        PluginManager pm = PluginManager.lookup(LicenceBasedConfiguration.class);
        if (pm == null) {
            return false;
        }
        for (PluginDescriptor descr : pm.getRegistry().getPluginDescriptors()) {
            if (!descr.getId().contains(name)) continue;
            return true;
        }
        return false;
    }

    private static boolean isLicenceCheckDisabled() {
        if ("true".equalsIgnoreCase(System.getProperty("LicenceChecker.force"))) {
            return false;
        }
        return !JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server.model", (String)"DisableLicenceChecker").isEmpty();
    }

    private boolean isLicenceValid() {
        if (this.lastResponse == null || !this.lastResponse.isVaild()) {
            return false;
        }
        if (this.offlineLicence) {
            return true;
        }
        if (this.lastResponse.getTimestamp() == null) {
            return false;
        }
        return System.currentTimeMillis() - this.lastResponse.getTimestamp().getTime() < 864000000L;
    }

    void checkLicence(boolean forceStop) throws Exception {
        this.log.debug((Object)"licence check started");
        SynchronizationRequest<LicenceValidationRequest> request = this.prepareRequest();
        LicenceValidationResponse response = this.queryForLicence(request);
        if (response != null) {
            this.lastResponse = response;
            try (OutputStream out = DesUtil.getCipherOutputStream((OutputStream)new FileOutputStream(this.licenceDataFile, false));){
                XUtil.serialize((XSerializable)response, (OutputStream)out);
                this.log.debug((Object)("licence check result saved to file " + this.licenceDataFile));
            }
            catch (Exception e) {
                this.log.error((Object)("failed saving licence check result to file " + this.licenceDataFile), (Throwable)e);
            }
        }
        if (!this.isLicenceValid()) {
            this.log.error((Object)"licence not valid or maximum offline interval exceeded");
            if (forceStop) {
                LicenceHelper.stopApplication();
            } else {
                throw Xeption.forAdmin((String)"licence not valid", (Object[])new Object[0]);
            }
        }
    }

    private SynchronizationRequest<LicenceValidationRequest> prepareRequest() {
        LicenceValidationRequest data = new LicenceValidationRequest();
        data.setLicenceKey(this.licenceKey);
        data.setAppId(Environment.getApplicationId());
        data.setMacAddress(this.getMacAddress());
        data.setInstallationUpdated(LicenceHelper.getLastUpdateDate());
        SynchronizationRequest<LicenceValidationRequest> request = new SynchronizationRequest<LicenceValidationRequest>();
        request.setClientId(Environment.getApplicationId());
        request.setData(data);
        request.setOperationId(OPERATION);
        return request;
    }

    private String getMacAddress() {
        NetworkInterface network = null;
        String macAddress = null;
        try {
            InetAddress ip = LicenceHelper.getIpAddress();
            if (ip != null) {
                network = NetworkInterface.getByInetAddress(ip);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"failed obtainig NetworkInterface", (Throwable)e);
        }
        if (network != null) {
            try {
                byte[] mac = network.getHardwareAddress();
                if (mac != null) {
                    macAddress = Arrays.toString(mac);
                } else {
                    this.log.debug((Object)"MAC address is not determined");
                }
            }
            catch (Exception e) {
                this.log.debug((Object)"failed determining MAC", (Throwable)e);
            }
        }
        return macAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LicenceValidationResponse queryForLicence(SynchronizationRequest<LicenceValidationRequest> request) {
        SynchronizationResponse response = SynchronizationHelper.execute(request, Address.getSync(), new UrlConnectionInfoSettings(), null);
        StringBuilder traceString = new StringBuilder();
        try {
            for (Message msg : response.getMessages()) {
                if (msg.getType() == MessageType.ERROR) {
                    this.log.error((Object)("Request to LicenceServer for licence validation had errors: " + msg.getMessage()));
                    traceString.append("\r\nError while requesting for the licence validation: ").append(msg.getMessage());
                    LicenceValidationResponse licenceValidationResponse = null;
                    return licenceValidationResponse;
                }
                if (msg.getType() != MessageType.FOR_USER) continue;
                this.log.warn((Object)("No access to use licence: " + msg.getMessage()));
                LicenceValidationResponse licenceValidationResponse = (LicenceValidationResponse)response.getData();
                return licenceValidationResponse;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"failed validating licence", (Throwable)e);
            traceString.append(String.format("\r\nUnable to validate licence:\n %s", TextUtil.getExceptionStackTrace((Throwable)e)));
        }
        finally {
            SynchronizationHelper.log(traceString.toString(), OPERATION);
        }
        return (LicenceValidationResponse)response.getData();
    }
}

