/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.mail;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.mail.MailServerParameters;
import com.gridnine.xtrip.common.model.mail.MailServerSettings;
import com.gridnine.xtrip.server.ServerApplication;
import org.java.plugin.util.ExtendedProperties;

public class MailConfigUtil {
    private static Integer DEFAULT_PORT = 25;

    public static MailServerSettings readMailServerParameters() {
        EntityContainer entityContainer = EntityStorage.get().load(MailServerSettings.class, UniqueSettingsRegistry.get().getUidByClassName(MailServerSettings.class.getName()));
        if (entityContainer == null) {
            return MailConfigUtil.readMailServerParametersFromProperties();
        }
        MailServerSettings settings = (MailServerSettings)entityContainer.getEntity();
        if (settings.getMailServerParameters().getPort() == null) {
            settings.getMailServerParameters().setPort(DEFAULT_PORT);
        }
        return settings;
    }

    @Deprecated
    public static MailServerSettings readMailServerParametersFromProperties() {
        Integer port;
        String propertyHost = "mail.host";
        String propertyPort = "mail.port";
        String propertyUser = "mail.user";
        String propertyPassword = "mail.password";
        String propertyAdmin = "mail.admin";
        String propertyDefaultFrom = "mail.defaultFrom";
        ExtendedProperties configuration = ((ServerApplication)Environment.getPublished(ServerApplication.class)).getConfiguration();
        String host = configuration.getProperty(propertyHost, null);
        try {
            String v = configuration.getProperty(propertyPort, DEFAULT_PORT.toString());
            port = Integer.valueOf(v);
        }
        catch (Exception e) {
            port = DEFAULT_PORT;
        }
        String user = configuration.getProperty(propertyUser, null);
        String password = configuration.getProperty(propertyPassword, null);
        MailServerParameters parameters = new MailServerParameters();
        parameters.setHost(host);
        parameters.setPort(port);
        parameters.setUser(user);
        parameters.setPasswrod(password);
        MailServerSettings result = new MailServerSettings();
        String admin = configuration.getProperty(propertyAdmin, null);
        String defaultFrom = configuration.getProperty(propertyDefaultFrom, null);
        result.setMailServerParameters(parameters);
        result.setAdminAddress(admin);
        result.setDefaultFrom(defaultFrom);
        return result;
    }
}

