/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.mail;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.mail.MailAddress;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.mail.MailPart;
import com.gridnine.xtrip.common.model.mail.MailServerParameters;
import com.gridnine.xtrip.common.model.mail.MailServerSettings;
import com.gridnine.xtrip.common.model.standard.helpers.HttpHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.jms.JMSFacade;
import com.gridnine.xtrip.server.jms.JMSMessageConfiguration;
import com.gridnine.xtrip.server.jms.JMSQueueWorker;
import com.gridnine.xtrip.server.model.mail.MailConfigUtil;
import com.gridnine.xtrip.server.model.mail.MailSenderJMSWorker;
import com.gridnine.xtrip.server.model.mail.MailSenderOperationData;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MailcapCommandMap;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailSender
implements Disposable {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final transient Logger logQueue = LoggerFactory.getLogger((String)(this.getClass().getName() + ".QUEUE"));
    private MailSenderJMSWorker worker;

    public void configure() throws Exception {
        MailServerSettings mailServerSettings = MailConfigUtil.readMailServerParameters();
        if (!this.isEnabled()) {
            this.log.info("disabled");
            return;
        }
        this.configureMailAPI();
        this.worker = new MailSenderJMSWorker(new MailSenderJMSWorker.MailSenderCallback(){

            @Override
            public Session createSession() {
                return MailSender.this.createSession();
            }

            @Override
            public Message buildMessage(Session session, MailDocument doc) throws Exception {
                return MailSender.this.buildMessage(session, doc);
            }
        }, Integer.parseInt(System.getProperty("mail.sender.threadscount", "10")));
        ((JMSFacade)Environment.getPublished(JMSFacade.class)).registerQueue(MailSenderOperationData.topicId, (JMSQueueWorker)this.worker);
        this.updateTimeoutProperty("mail.smtp.connectiontimeout", 60000L);
        this.updateTimeoutProperty("mail.smtp.timeout", 60000L);
        this.log.info(String.format("configured, smtpHost=%s, smtpPort=%s", mailServerSettings.getMailServerParameters().getHost(), mailServerSettings.getMailServerParameters().getPort()));
    }

    private void updateTimeoutProperty(String propName, long value) {
        String currentValue = System.getProperty(propName);
        if (TextUtil.isBlank((String)currentValue)) {
            System.setProperty(propName, Long.toString(value));
        }
    }

    private void configureMailAPI() {
        MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
        mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
        mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
        mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
        mc.addMailcap("message/rfc822;; x-java-content-handler=com.sun.mail.handlers.message_rfc822");
        CommandMap.setDefaultCommandMap((CommandMap)mc);
    }

    public static boolean isValidEmailAddress(String email) {
        try {
            new InternetAddress(email).validate();
            return true;
        }
        catch (AddressException ex) {
            return false;
        }
    }

    public static void checkAddress(Collection<MailAddress> mailAddress) {
        if (mailAddress.size() == 0) {
            throw new IllegalArgumentException("recipient address does not specified");
        }
        for (MailAddress address : mailAddress) {
            MailSender.checkAddress(address);
        }
    }

    public static void checkAddress(MailAddress address) {
        String email = address.getAddress();
        if (TextUtil.isBlank((String)email)) {
            throw new IllegalArgumentException("one or more recipient address is empty");
        }
        if (!MailSender.isValidEmailAddress(email)) {
            throw new IllegalArgumentException("invalid email address: " + email);
        }
    }

    private void sanitize(MailDocument doc) {
        this.sanitize(doc.getBody());
        this.sanitize(doc.getAttachments());
    }

    private void sanitize(MailPart part) {
        this.sanitize(part.getAttachments());
    }

    private void sanitize(List<MailPart> attachments) {
        if (attachments.isEmpty()) {
            return;
        }
        Iterator<MailPart> itr = attachments.iterator();
        do {
            MailPart mp;
            if ((mp = itr.next()).getData() == null) {
                itr.remove();
                continue;
            }
            this.sanitize(mp);
        } while (itr.hasNext());
    }

    private void checkBody(MailDocument doc) {
        if (doc.getBody() == null) {
            throw Xeption.forDeveloper((String)"no mail body", (Object[])new Object[0]);
        }
        this.checkMailPart(doc.getBody());
        doc.getAttachments().forEach(this::checkMailPart);
    }

    private void checkMailPart(MailPart part) {
        if (part.getData() == null) {
            throw Xeption.forDeveloper((String)"no mail data", (Object[])new Object[0]);
        }
        part.getAttachments().forEach(this::checkMailPart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getMailData(MailDocument doc) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Session session = Session.getDefaultInstance((Properties)new Properties());
            Message message = this.buildMessage(session, doc);
            ByteArrayOutputStream strm = new ByteArrayOutputStream();
            message.writeTo((OutputStream)strm);
            byte[] byArray = strm.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            this.log.error("error getting mail document content", (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public void send(MailDocument doc) {
        this.send(doc, null, 0L);
    }

    public void send(MailDocument doc, long delay) {
        this.send(doc, null, delay);
    }

    public void send(MailDocument doc, MailServerParameters parameters) {
        this.send(doc, parameters, 0L);
    }

    public void send(MailDocument doc, MailServerParameters parameters, long delay) {
        try {
            if (!this.isEnabled() && (parameters == null || TextUtil.isBlank((String)parameters.getHost()))) {
                this.logQueue.error(String.format("Error adding message %s for document %s, subject \"%s\", and addresses %s into JMS queue - mail service not enabled", doc.getName(), doc.getOwner(), doc.getSubject(), this.getRecipients(doc)));
                return;
            }
            this.sanitize(doc);
            this.checkBody(doc);
            JMSMessageConfiguration jmsMessageConfiguration = new JMSMessageConfiguration().setTopicId(MailSenderOperationData.topicId);
            if (delay > 0L) {
                jmsMessageConfiguration = jmsMessageConfiguration.setDelay(Long.valueOf(delay));
            }
            ((JMSFacade)Environment.getPublished(JMSFacade.class)).publishMessageAsync((Object)new MailSenderOperationData(doc, parameters), jmsMessageConfiguration);
            this.logQueue.debug(String.format("message %s for document %s, subject \"%s\", and addresses %s put into JMS queue", doc.getName(), doc.getOwner(), doc.getSubject(), this.getRecipients(doc)));
        }
        catch (RuntimeException e) {
            this.logQueue.debug(String.format("message %s for document %s, subject \"%s\", and addresses %s send failed", doc.getName(), doc.getOwner(), doc.getSubject(), this.getRecipients(doc)), (Throwable)e);
            throw e;
        }
    }

    public MailAddress getAdminAddress() {
        MailAddress address = new MailAddress();
        address.setAddress(MailConfigUtil.readMailServerParameters().getAdminAddress());
        return address;
    }

    public MailAddress getDefaultFromAddress() {
        MailAddress address = new MailAddress();
        address.setAddress(MailConfigUtil.readMailServerParameters().getDefaultFrom());
        return address;
    }

    public boolean isEnabled() {
        return !TextUtil.isBlank((String)MailConfigUtil.readMailServerParameters().getMailServerParameters().getHost());
    }

    private Session createSession() {
        Properties props = new Properties();
        String host = MailConfigUtil.readMailServerParameters().getMailServerParameters().getHost();
        props.put("mail.smtp.host", host);
        Integer port = MailConfigUtil.readMailServerParameters().getMailServerParameters().getPort();
        if (port != null) {
            props.put("mail.smtp.port", port);
        }
        return Session.getInstance((Properties)props);
    }

    private Message buildMessage(Session session, MailDocument doc) throws Exception {
        MimeMessage result = new MimeMessage(session);
        result.setFrom((Address)this.buildAddress(doc.getFrom()));
        for (MailAddress ma : doc.getTo()) {
            this.addRecipient(result, Message.RecipientType.TO, ma);
        }
        for (MailAddress ma : doc.getCc()) {
            this.addRecipient(result, Message.RecipientType.CC, ma);
        }
        for (MailAddress ma : doc.getBcc()) {
            this.addRecipient(result, Message.RecipientType.BCC, ma);
        }
        InternetAddress[] replyToAddress = this.buildAddresses(doc.getReplyTo());
        if (replyToAddress != null) {
            result.setReplyTo((Address[])replyToAddress);
        }
        result.setSubject(doc.getSubject(), "utf-8");
        if (doc.isImportant()) {
            result.setHeader("X-Priority", "1");
        }
        String subType = doc.isRelated() ? "related" : (doc.getMultipartSubType() != null ? doc.getMultipartSubType().name().toLowerCase() : null);
        MimeMultipart content = subType != null ? new MimeMultipart(subType) : new MimeMultipart();
        content.addBodyPart((BodyPart)this.buildMailPart(doc.getBody()));
        for (MailPart att : doc.getAttachments()) {
            content.addBodyPart((BodyPart)this.buildMailPart(att));
        }
        result.setContent((Multipart)content);
        result.setSentDate(new Date());
        return result;
    }

    private void addRecipient(MimeMessage mimeMessage, Message.RecipientType rt, MailAddress mailAddr) throws Exception {
        String mailAddressesStr = mailAddr.getAddress();
        if (mailAddressesStr == null) {
            return;
        }
        if (mailAddressesStr.indexOf(44) >= 0) {
            String[] adrs;
            for (String adr : adrs = StringUtils.split((String)mailAddressesStr, (char)',')) {
                if (TextUtil.isBlank((String)adr)) continue;
                MailAddress ma = new MailAddress();
                ma.setName(mailAddr.getName());
                ma.setAddress(adr);
                mimeMessage.addRecipients(rt, (Address[])this.buildAddresses(ma));
            }
        } else {
            mimeMessage.addRecipients(rt, (Address[])this.buildAddresses(mailAddr));
        }
    }

    private InternetAddress[] buildAddresses(MailAddress ma) throws Exception {
        if (ma == null) {
            return null;
        }
        ArrayList<InternetAddress> result = new ArrayList<InternetAddress>();
        for (String address : StringUtils.split((String)ma.getAddress(), (String)", ")) {
            result.add(new InternetAddress(address));
        }
        return result.toArray(new InternetAddress[0]);
    }

    private InternetAddress buildAddress(MailAddress ma) throws Exception {
        if (ma == null) {
            return null;
        }
        return TextUtil.isBlank((String)ma.getName()) ? new InternetAddress(ma.getAddress()) : new InternetAddress(ma.getAddress(), ma.getName());
    }

    private MimeBodyPart buildMailPart(MailPart mp) throws Exception {
        MimeBodyPart result = new MimeBodyPart();
        String contentType = HttpHelper.getMimeType((ContentType)mp.getContentType());
        if (mp.getContentTypeParameters().size() != 0) {
            StringBuilder sb = new StringBuilder();
            if (contentType != null) {
                sb.append(contentType);
            }
            for (Map.Entry entry : mp.getContentTypeParameters().entrySet()) {
                if (sb.length() > 0) {
                    sb.append(";").append(" ");
                }
                sb.append((String)entry.getKey()).append("=").append((String)entry.getValue());
            }
            contentType = sb.toString();
        }
        if (mp.getMultipartSubType() == null) {
            result.setContentID('<' + mp.getUid() + '>');
            if (mp.isInline()) {
                result.setDisposition("inline");
            }
            if (!TextUtil.isBlank((String)mp.getName())) {
                result.setFileName(mp.getName());
            }
            result.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(mp.getData(), contentType)));
        } else {
            MimeMultipart content = new MimeMultipart(mp.getMultipartSubType().name().toLowerCase());
            MimeBodyPart mainPart = new MimeBodyPart();
            mainPart.setContentID('<' + mp.getUid() + '>');
            if (mp.isInline()) {
                mainPart.setDisposition("inline");
            }
            if (!TextUtil.isBlank((String)mp.getName())) {
                mainPart.setFileName(mp.getName());
            }
            mainPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(mp.getData(), contentType)));
            content.addBodyPart((BodyPart)mainPart);
            for (MailPart att : mp.getAttachments()) {
                content.addBodyPart((BodyPart)this.buildMailPart(att));
            }
            result.setContent((Multipart)content);
        }
        return result;
    }

    private String getRecipients(MailDocument doc) {
        StringBuilder sb = new StringBuilder("[");
        if (doc.getTo() != null) {
            ArrayList<String> addresses = new ArrayList<String>();
            for (MailAddress ma : doc.getTo()) {
                if (TextUtil.isBlank((String)ma.getAddress())) continue;
                addresses.add(ma.getAddress());
            }
            sb.append(TextUtil.join((String)",", addresses));
        }
        sb.append("]");
        return sb.toString();
    }

    public void dispose() {
        if (this.worker != null) {
            this.worker.dispose();
        }
    }
}

