/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.mail;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.mail.MailAddress;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.mail.MailPart;
import com.gridnine.xtrip.common.model.mail.MailServerParameters;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MailSecurityHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.jms.JMSFacade;
import com.gridnine.xtrip.server.jms.JMSQueueWorker;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.model.mail.MailSenderOperationData;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailSenderJMSWorker
implements JMSQueueWorker<MailSenderOperationData> {
    private final MailSenderCallback clb;
    private final ExecutorServiceFacade service;
    final Logger log = LoggerFactory.getLogger(this.getClass());

    public MailSenderJMSWorker(MailSenderCallback callback, int threadCount) {
        this.clb = callback;
        this.service = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newFixedThreadPool(threadCount, (ThreadFactory)new JmsSenderMailFactory());
    }

    public boolean processRequest(final MailSenderOperationData message) throws Exception {
        this.service.execute(new Runnable(){

            @Override
            public void run() {
                DebugUtil.setThreadName((String)String.format("send-mail-%s", message.getMailDocument().getName()));
                try {
                    if (message.getServerParameters() == null) {
                        MailSenderJMSWorker.this.send(message.getMailDocument());
                        MailSenderJMSWorker.this.log.debug(String.format("message %s for document %s, subject \"%s\", and addresses %s was successfully sent", message.getMailDocument().getName(), message.getMailDocument().getOwner(), message.getMailDocument().getSubject(), MailSenderJMSWorker.this.getRecipients(message)));
                        return;
                    }
                    MailSenderJMSWorker.this.send(message.getMailDocument(), message.getServerParameters());
                    MailSenderJMSWorker.this.log.debug(String.format("message %s for document %s, subject \"%s\", and addresses %s was successfully sent", message.getMailDocument().getName(), message.getMailDocument().getOwner(), message.getMailDocument().getSubject(), MailSenderJMSWorker.this.getRecipients(message)));
                    MailSenderJMSWorker.this.createLogItem(message, null);
                }
                catch (MessagingException e) {
                    String recipients = MailSenderJMSWorker.this.getRecipients(message);
                    MailSenderJMSWorker.this.log.error(String.format("message with subject \"%s\" was not send %s to addresses %s", message.getMailDocument().getSubject(), message.getMailDocument().getName(), recipients), (Throwable)e);
                    if (e.getNextException() instanceof SocketTimeoutException) {
                        MailSenderJMSWorker.this.log.debug(String.format("exception for message with subject \"%s\" and addresses %s is a TimeoutException, returning message to queue", message.getMailDocument().getSubject(), recipients));
                        ((JMSFacade)Environment.getPublished(JMSFacade.class)).publishMessageAsync(MailSenderOperationData.topicId, (Object)message);
                        return;
                    }
                    MailSenderJMSWorker.this.createLogItem(message, (Exception)((Object)e));
                    if (e instanceof SendFailedException) {
                        MailSenderJMSWorker.this.handleFailedHotelNotification(message, e);
                    }
                }
                catch (Exception e) {
                    MailSenderJMSWorker.this.log.error(String.format("message with subject \"%s\" was not send %s to addresses %s", message.getMailDocument().getSubject(), message.getMailDocument().getName(), MailSenderJMSWorker.this.getRecipients(message)), (Throwable)e);
                    MailSenderJMSWorker.this.createLogItem(message, e);
                }
                finally {
                    DebugUtil.restoreThreadName();
                }
            }
        });
        return true;
    }

    private void handleFailedHotelNotification(MailSenderOperationData message, MessagingException e) {
        List addressesTo;
        Set invalidAddresses = Arrays.stream(((SendFailedException)e).getInvalidAddresses()).map(Address::toString).collect(Collectors.toSet());
        List invalidHotelAddresses = message.getMailDocument().getTo().stream().filter(MailAddress::isHotelAddress).map(MailAddress::getAddress).filter(invalidAddresses::contains).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(invalidHotelAddresses) && CollectionUtil.isNotEmpty(addressesTo = message.getMailDocument().getTo().stream().filter(address -> !address.isHotelAddress()).filter(address -> !invalidAddresses.contains(address.getAddress())).collect(Collectors.toList()))) {
            MailDocument mailDoc = new MailDocument();
            mailDoc.setFrom(message.getMailDocument().getFrom());
            mailDoc.getTo().addAll(addressesTo);
            mailDoc.setSubject(String.format("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043f\u0438\u0441\u044c\u043c\u043e \u0432 \u043e\u0442\u0435\u043b\u044c. \u0417\u0430\u043a\u0430\u0437 \u2116%s", message.getMailDocument().getOwner().getCaption()));
            MailPart mailPart = new MailPart();
            mailPart.setContentType(ContentType.TEXT);
            mailPart.setData(String.format("\u041f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \"%s\" \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", message.getMailDocument().getName()).getBytes());
            mailDoc.setBody(mailPart);
            MailSenderOperationData failedMessage = new MailSenderOperationData(mailDoc, message.getServerParameters());
            ((JMSFacade)Environment.getPublished(JMSFacade.class)).publishMessageAsync(MailSenderOperationData.topicId, (Object)failedMessage);
        }
    }

    void createLogItem(MailSenderOperationData message, Exception e) {
        if (message.getMailDocument().getOwner() == null) {
            return;
        }
        if (e == null) {
            SysLogHelper.audit(message.getMailDocument().getOwner(), "notification", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 {0} \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e", (Object[])new Object[]{message.getMailDocument().getName()}));
            return;
        }
        SysLogHelper.audit(message.getMailDocument().getOwner(), "notification", SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f {0} \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e, (Object[])new Object[]{message.getMailDocument().getName()}));
    }

    private String getRecipients(MailSenderOperationData message) {
        StringBuilder sb = new StringBuilder("[");
        if (message.getMailDocument().getTo() != null) {
            ArrayList<String> addresses = new ArrayList<String>();
            for (MailAddress ma : message.getMailDocument().getTo()) {
                if (TextUtil.isBlank((String)ma.getAddress())) continue;
                addresses.add(ma.getAddress());
            }
            sb.append(TextUtil.join((String)",", addresses));
        }
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(MailDocument mailDocument, MailServerParameters parameters) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            String protocol;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Properties props = new Properties();
            String string = protocol = parameters.isSsl() ? "smtps" : "smtp";
            if (parameters.isAuth()) {
                props.put("mail." + protocol + ".auth", "true");
            }
            props.put("mail." + protocol + ".host", parameters.getHost());
            if (parameters.isSsl()) {
                props.put("mail.smtps.ssl.trust", "*");
            }
            Session session = Session.getDefaultInstance((Properties)props);
            Message message = this.clb.buildMessage(session, mailDocument);
            ByteArrayOutputStream strm = new ByteArrayOutputStream();
            message.writeTo((OutputStream)strm);
            Transport transport = session.getTransport(protocol);
            transport.connect(parameters.getHost(), parameters.getPort().intValue(), parameters.getUser(), MailSecurityHelper.decode((String)parameters.getPasswrod()));
            try {
                transport.sendMessage(message, message.getAllRecipients());
            }
            catch (SendFailedException ex) {
                Address[] validUnsentAddresses = ex.getValidUnsentAddresses();
                if (validUnsentAddresses != null && validUnsentAddresses.length > 0) {
                    transport.sendMessage(message, validUnsentAddresses);
                    throw new Exception("mail was sent only to valid addresses " + Arrays.asList(validUnsentAddresses), ex);
                }
                throw ex;
            }
            transport.close();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(MailDocument mailDocument) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Message message = this.clb.buildMessage(this.clb.createSession(), mailDocument);
            ByteArrayOutputStream strm = new ByteArrayOutputStream();
            message.writeTo((OutputStream)strm);
            try {
                Transport.send((Message)message);
            }
            catch (SendFailedException ex) {
                Address[] validUnsentAddresses = ex.getValidUnsentAddresses();
                if (validUnsentAddresses != null && validUnsentAddresses.length > 0) {
                    Transport.send((Message)message, (Address[])validUnsentAddresses);
                    throw new Exception("mail was sent only to valid addresses " + Arrays.asList(validUnsentAddresses), ex);
                }
                throw ex;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public void dispose() {
        this.service.dispose();
    }

    static interface MailSenderCallback {
        public Message buildMessage(Session var1, MailDocument var2) throws Exception;

        public Session createSession();
    }

    static final class JmsSenderMailFactory
    implements ThreadFactory {
        private static final AtomicInteger idx = new AtomicInteger(0);

        JmsSenderMailFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("JMS Mail Sender " + idx.addAndGet(1));
            return thread;
        }
    }
}

