/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.mail;

import com.gridnine.xtrip.common.model.mail.MailAddress;
import com.gridnine.xtrip.common.model.mail.MailServerSettings;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.mail.MailConfigUtil;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MailServerGate {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    MailServerGate() {
    }

    void configure(ExtendedProperties config) throws Exception {
        MailServerSettings mailServerSettings = MailConfigUtil.readMailServerParameters();
        if (!this.isEnabled()) {
            this.log.info("disabled");
            return;
        }
        this.configureMailAPI();
        this.log.info(String.format("configured, smtpHost=%s, smtpPort=%s", mailServerSettings.getMailServerParameters().getHost(), mailServerSettings.getMailServerParameters().getPort()));
    }

    private void configureMailAPI() {
        MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
        mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
        mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
        mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
        mc.addMailcap("message/rfc822;; x-java-content-handler=com.sun.mail.handlers.message_rfc822");
        CommandMap.setDefaultCommandMap((CommandMap)mc);
    }

    public MailAddress getAdminAddress() {
        MailAddress address = new MailAddress();
        address.setAddress(MailConfigUtil.readMailServerParameters().getAdminAddress());
        return address;
    }

    public MailAddress getDefaultFromAddress() {
        MailAddress address = new MailAddress();
        address.setAddress(MailConfigUtil.readMailServerParameters().getDefaultFrom());
        return address;
    }

    public boolean isEnabled() {
        return !TextUtil.isBlank((String)MailConfigUtil.readMailServerParameters().getMailServerParameters().getHost());
    }
}

