/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.meta;

import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import org.junit.Assert;
import org.junit.Test;

public class SegmentPropertiesRenamerTest
extends ModelTestBase {
    @Test
    public void testEmpty() throws Exception {
        LuggageInfo info = this.getLuggageInfo("SegmentPropertiesRenamerTest_empty.xml");
        Assert.assertNull((Object)info);
    }

    @Test
    public void testKg() throws Exception {
        LuggageInfo info = this.getLuggageInfo("SegmentPropertiesRenamerTest_kg.xml");
        Assert.assertFalse((boolean)info.isNil());
        Assert.assertEquals((long)20L, (long)info.getQuantity().intValue());
        Assert.assertEquals((Object)"KG", (Object)info.getUnit().getCode());
    }

    @Test
    public void testNil() throws Exception {
        LuggageInfo info = this.getLuggageInfo("SegmentPropertiesRenamerTest_nil.xml");
        Assert.assertTrue((boolean)info.isNil());
    }

    @Test
    public void testNull() throws Exception {
        LuggageInfo info = this.getLuggageInfo("SegmentPropertiesRenamerTest_null.xml");
        Assert.assertNull((Object)info);
    }

    @Test
    public void testPc() throws Exception {
        LuggageInfo info = this.getLuggageInfo("SegmentPropertiesRenamerTest_pc.xml");
        Assert.assertFalse((boolean)info.isNil());
        Assert.assertEquals((long)1L, (long)info.getQuantity().intValue());
        Assert.assertEquals((Object)"PC", (Object)info.getUnit().getCode());
    }

    @Test
    public void testUnexpected() throws Exception {
        LuggageInfo info = this.getLuggageInfo("SegmentPropertiesRenamerTest_unexpected.xml");
        Assert.assertFalse((boolean)info.isNil());
        Assert.assertEquals((long)38L, (long)info.getQuantity().intValue());
        Assert.assertEquals((Object)"POPUGAEV", (Object)info.getUnit().getCode());
    }

    private LuggageInfo getLuggageInfo(String fileName) throws Exception {
        EntityContainer bfCtr = new EntityContainer(BookingFile.class);
        this.loadXSerializable(fileName, (XSerializable)bfCtr);
        Product prod = (Product)((Reservation)((BookingFile)bfCtr.getEntity()).getReservations().get(0)).getProducts().get(0);
        return ((Segment)((SegmentTariff)prod.getSegmentTariffs().get(0)).getSegments().get(0)).getLuggageInfo();
    }

    protected void configureMetaregistry(MetaRegistry metaRegistry) throws Exception {
        super.configureMetaregistry(metaRegistry);
        metaRegistry.register(((Object)((Object)this)).getClass().getClassLoader().getResource("com/gridnine/xtrip/common/model/model-booking.xml"));
    }
}

