/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.notification.service;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.mail.MailAddress;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.mail.MailPart;
import com.gridnine.xtrip.common.model.mail.MailServerParameters;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.EntityEventNotification;
import com.gridnine.xtrip.common.model.system.EntityEventNotificationIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.model.mail.MailConfigUtil;
import com.gridnine.xtrip.server.model.mail.MailSender;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

@Deprecated
public class EmailEventNotificationTask
extends BaseScheduledTask {
    private Date prevFireTime;

    public void configure(Properties config) throws Exception {
        this.prevFireTime = (Date)config.get("prevFireTime");
    }

    protected void doJob() throws Exception {
        Date currentTime = new Date();
        if (this.prevFireTime == null) {
            this.log.debug("prevFireTime is null, skipping");
            return;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)EntityEventNotificationIndex.Property.active.name(), (Object)true));
        query.getCriteria().getCriterions().add(SearchCriterion.le((String)EntityEventNotificationIndex.Property.alarmDate.name(), (Object)currentTime));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)EntityEventNotificationIndex.Property.needEmail.name(), (Object)true), SearchCriterion.between((String)EntityEventNotificationIndex.Property.eventDate.name(), (Object)this.prevFireTime, (Object)currentTime)}));
        this.log.debug(String.format("searching notifications with event date between %s and %s", this.prevFireTime, currentTime));
        try {
            List eventIndexes = EntityStorage.get().search(EntityEventNotificationIndex.class, query).getData();
            this.log.debug(eventIndexes.size() + " notifications found");
            for (EntityEventNotificationIndex index : eventIndexes) {
                this.log.debug(String.format("analizing notification %s with uid %s", index.getTitle(), index.getSource().getUid()));
                EntityReference notificationRef = index.getSource();
                try {
                    EntityContainer notificationCont = EntityStorage.get().resolve(notificationRef);
                    this.sendEmailNotification((EntityEventNotification)notificationCont.getEntity());
                    ((EntityEventNotification)notificationCont.getEntity()).setNeedEmail(false);
                    VersionInfo versionInfo = notificationCont.getVersionInfo();
                    versionInfo.setDataSource("EmailEventNotificationTask.doJob");
                    versionInfo.setVersionNotes("setting needMail to false");
                    EntityStorage.get().save(notificationCont, false);
                }
                catch (Exception e) {
                    StringBuilder stack = new StringBuilder();
                    for (StackTraceElement el : e.getStackTrace()) {
                        stack.append(el.toString());
                        stack.append("\n");
                    }
                    this.log.error("Error while sending notification: " + e.getMessage() + "\nStacktrace: " + stack.toString());
                }
            }
        }
        catch (Exception e) {
            StringBuilder stack = new StringBuilder();
            for (StackTraceElement el : e.getStackTrace()) {
                stack.append(el.toString());
                stack.append("\n");
            }
            this.log.error("Error while collecting event notification objects: " + e.getMessage() + "\nStacktrace: " + stack.toString());
        }
    }

    public void sendEmailNotification(EntityEventNotification data) throws Exception {
        MailSender sender = (MailSender)Environment.getPublished(MailSender.class);
        if (!sender.isEnabled()) {
            this.log.debug("Notification was not sent because Mail Service is disabled");
            return;
        }
        List<MailAddress> addresses = this.getAdresses(data.getEventLogins());
        String title = L10nResourcesManager.getStr((String)Messages.EmailEventNotificationTask_reminderEvent, (Object[])new Object[]{data.getTitle()});
        MailDocument mailDoc = new MailDocument();
        MailAddress fromAddress = new MailAddress();
        fromAddress.setName("MOM no-reply support");
        fromAddress.setAddress("no-reply@sabre.com");
        mailDoc.setFrom(fromAddress);
        mailDoc.getTo().addAll(addresses);
        mailDoc.setSubject(title);
        MailPart mailPart = this.prepareMail(data, sender, ContentType.TEXT);
        mailDoc.setBody(mailPart);
        MailServerParameters mailServerParameters = MailConfigUtil.readMailServerParameters().getMailServerParameters();
        if (!TextUtil.isBlank((String)mailServerParameters.getUser())) {
            sender.send(mailDoc, mailServerParameters);
        } else {
            sender.send(mailDoc);
        }
        this.log.debug("Email notification sent successfully");
    }

    private MailPart prepareMail(EntityEventNotification data, MailSender sender, ContentType contentType) {
        MailPart mailPart = new MailPart();
        mailPart.setContentType(contentType);
        if (ContentType.HTML.equals((Object)contentType)) {
            StringBuilder buf = new StringBuilder();
            buf.append("<html>");
            buf.append("<head>");
            buf.append("<title>");
            buf.append(String.format(L10nResourcesManager.getStr((String)Messages.EmailEventNotificationTask_reminderEvent, (Object[])new Object[0]), data.getTitle()));
            buf.append("</title>");
            buf.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            buf.append("</head>");
            buf.append("<body>");
            buf.append(L10nResourcesManager.getStr((String)Messages.EmailEventNotificationTask_reminderEventHTML, (Object[])new Object[]{data.getTitle()}));
            buf.append(String.format("<p>%s</p>", data.getText()));
            if (data.getEventDate() != null) {
                buf.append(L10nResourcesManager.getStr((String)Messages.EmailEventNotificationTask_dateEventHTML, (Object[])new Object[]{new SimpleDateFormat("dd.MM.yyyy - hh:mm").format(data.getEventDate())}));
            }
            if (data.getEventEntity() != null) {
                buf.append(L10nResourcesManager.getStr((String)Messages.EmailEventNotificationTask_objectReminderHTML, (Object[])new Object[]{data.getEventEntity().toString()}));
            }
            buf.append("<hr>");
            buf.append("<br>");
            buf.append(L10nResourcesManager.getStr((String)Messages.EmailEventNotificationTask_dontReplayOnThisLetterHTML, (Object[])new Object[0]));
            if (sender.getAdminAddress() != null && sender.getAdminAddress().getAddress() != null) {
                buf.append("<br>");
                buf.append(L10nResourcesManager.getStr((String)Messages.EmailEventNotificationTask_ifYouBelieveHaveReceivedByErrorHTML, (Object[])new Object[0])).append(sender.getAdminAddress().getAddress()).append(">").append(sender.getAdminAddress().getAddress()).append("</a></small>");
            }
            buf.append("</body>");
            buf.append("</html>");
            byte[] bytes = new byte[]{};
            try {
                bytes = buf.toString().getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                this.log.error("Error while encoding email message: " + e.getMessage());
            }
            mailPart.setName("notification.html");
            mailPart.setData(bytes);
        } else if (ContentType.TEXT.equals((Object)contentType)) {
            StringBuilder buf = new StringBuilder();
            buf.append(L10nResourcesManager.getStr((String)Messages.EmailEventNotificationTask_reminderEvent, (Object[])new Object[]{data.getTitle()}));
            buf.append("\n\n");
            buf.append(L10nResourcesManager.getStr((String)Messages.EmailEventNotificationTask_reminderText, (Object[])new Object[]{data.getText()}));
            buf.append("\n\n");
            if (data.getEventDate() != null) {
                buf.append(L10nResourcesManager.getStr((String)Messages.EmailEventNotificationTask_dateEvent, (Object[])new Object[]{new SimpleDateFormat("dd.MM.yyyy - hh:mm").format(data.getEventDate())}));
            }
            if (data.getEventEntity() != null) {
                buf.append("\n\n");
                buf.append(L10nResourcesManager.getStr((String)Messages.EmailEventNotificationTask_objectReminder, (Object[])new Object[]{data.getEventEntity().toString()}));
            }
            buf.append("\n\n");
            buf.append("----------------------------------------------\n");
            buf.append(L10nResourcesManager.getStr((String)Messages.EmailEventNotificationTask_dontReplayOnThisLetter, (Object[])new Object[0]));
            if (sender.getAdminAddress() != null && sender.getAdminAddress().getAddress() != null) {
                buf.append("\n");
                buf.append(L10nResourcesManager.getStr((String)Messages.EmailEventNotificationTask_ifYouBelieveHaveReceivedByError, (Object[])new Object[0]) + sender.getAdminAddress().getAddress());
            }
            byte[] bytes = new byte[]{};
            try {
                bytes = buf.toString().getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                this.log.error("Error while encoding email message: " + e.getMessage());
            }
            mailPart.setData(bytes);
        }
        return mailPart;
    }

    private List<MailAddress> getAdresses(List<String> eventLogins) {
        ArrayList<MailAddress> res = new ArrayList<MailAddress>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])this.getLoginCriterions(eventLogins)));
        try {
            List perInds = EntityStorage.get().search(PersonIndex.class, query).getData();
            for (PersonIndex perInd : perInds) {
                EntityReference perRef = perInd.getSource();
                EntityContainer perCont = EntityStorage.get().resolve(perRef);
                if (perCont == null) continue;
                Person per = (Person)perCont.getEntity();
                String email = "";
                for (Communication c : per.getCommunications()) {
                    if (c.getType() == null || !c.getType().equals((Object)CommunicationType.EMAIL)) continue;
                    email = c.getSense();
                    break;
                }
                MailAddress ma = new MailAddress();
                ma.setAddress(email);
                ma.setName(per.getLastName() + " " + per.getFirstName());
                res.add(ma);
            }
        }
        catch (Exception e) {
            StringBuilder stack = new StringBuilder();
            for (StackTraceElement el : e.getStackTrace()) {
                stack.append(el.toString());
                stack.append("\n");
            }
            this.log.error("Error collecting addresses: " + e.getMessage() + "\nStacktrace: " + stack.toString());
        }
        return res;
    }

    private SearchCriterion[] getLoginCriterions(List<String> eventLogins) {
        ArrayList<SearchCriterion> res = new ArrayList<SearchCriterion>();
        for (String login : eventLogins) {
            res.add(SearchCriterion.eq((String)PersonIndex.Property.loginName.name(), (Object)login));
        }
        return res.toArray(new SearchCriterion[0]);
    }
}

