/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.notification.service;

import com.gridnine.xtrip.common.Publisher;
import com.gridnine.xtrip.common.async.AsyncCommand;
import com.gridnine.xtrip.common.async.AsyncCommandOption;
import com.gridnine.xtrip.common.async.AsyncExecutor;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.EntityEventNotification;
import com.gridnine.xtrip.common.model.system.EntityEventNotificationIndex;
import com.gridnine.xtrip.common.model.system.EventNotification;
import com.gridnine.xtrip.common.model.system.EventNotificationRecipient;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.model.notification.service.NotificationsProcessingScheduledTask;
import java.io.Serializable;

public class NotificationServicePublisher
implements Publisher {
    public void publish() throws Exception {
        String taskSettingsUid = NotificationsProcessingScheduledTask.class.getName();
        if (EntityStorage.get().isAvailable(ScheduledTaskSettings.class, taskSettingsUid)) {
            return;
        }
        EntityContainer ctr = new EntityContainer(ScheduledTaskSettings.class, taskSettingsUid);
        ScheduledTaskSettings taskSettings = (ScheduledTaskSettings)ctr.getEntity();
        taskSettings.setEnabled(true);
        taskSettings.setCron(null);
        taskSettings.setPeriod(Long.valueOf(900000L));
        taskSettings.setDelay(taskSettings.getPeriod());
        taskSettings.setJobClass(NotificationsProcessingScheduledTask.class.getName());
        taskSettings.setName("\u0421\u043b\u0443\u0436\u0435\u0431\u043d\u043e\u0435: \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043d\u0430\u043f\u043e\u043c\u0438\u043d\u0430\u043d\u0438\u0439 \u043e \u0441\u043e\u0431\u044b\u0442\u0438\u044f\u0445");
        taskSettings.setType(SystemSettingsType.SCHEDULED_TASK_SETTINGS);
        ctr.getVersionInfo().setDataSource("NotificationServicePublisher");
        EntityStorage.get().save(ctr, false);
        AsyncExecutor.get().execute("converting-old-notifications", (AsyncCommand & Serializable)() -> {
            LogicalStorage.get().authorizeAsSystem();
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)EntityEventNotificationIndex.Property.active.name(), (Object)Boolean.TRUE));
            for (EntityEventNotificationIndex idx : EntityStorage.get().search(EntityEventNotificationIndex.class, query).getData()) {
                EntityContainer oldCtr = EntityStorage.get().resolve(idx.getSource());
                if (oldCtr == null) continue;
                this.convert((EntityContainer<EntityEventNotification>)oldCtr);
            }
        }, new AsyncCommandOption[]{AsyncCommandOption.LOCAL});
    }

    private void convert(EntityContainer<EntityEventNotification> oldCtr) {
        EntityContainer newCtr = new EntityContainer(EventNotification.class);
        ((EventNotification)newCtr.getEntity()).setActive(true);
        ((EventNotification)newCtr.getEntity()).setAlarmDate(((EntityEventNotification)oldCtr.getEntity()).getAlarmDate());
        ((EventNotification)newCtr.getEntity()).setEventDate(((EntityEventNotification)oldCtr.getEntity()).getEventDate());
        ((EventNotification)newCtr.getEntity()).setNeedEmail(((EntityEventNotification)oldCtr.getEntity()).isNeedEmail());
        ((EventNotification)newCtr.getEntity()).setTitle(((EntityEventNotification)oldCtr.getEntity()).getTitle());
        ((EventNotification)newCtr.getEntity()).setText(((EntityEventNotification)oldCtr.getEntity()).getText());
        ((EventNotification)newCtr.getEntity()).setEntityReference(((EntityEventNotification)oldCtr.getEntity()).getEventEntity());
        for (String login : ((EntityEventNotification)oldCtr.getEntity()).getEventLogins()) {
            try {
                UserAccount account = ProfileDao.findAccount(login);
                if (account == null) continue;
                EventNotificationRecipient recipient = new EventNotificationRecipient();
                recipient.setLogin(account.getLoginName());
                recipient.setName(account.getFullName());
                ((EventNotification)newCtr.getEntity()).getRecipients().add(recipient);
            }
            catch (Exception exception) {}
        }
        if (!((EventNotification)newCtr.getEntity()).getRecipients().isEmpty()) {
            newCtr.getVersionInfo().setDataSource("NotificationServicePublisher");
            newCtr.getVersionInfo().setVersionNotes("converted from old notification object");
            EntityStorage.get().save(newCtr, true);
        }
        ((EntityEventNotification)oldCtr.getEntity()).setActive(false);
        oldCtr.getVersionInfo().setDataSource("NotificationServicePublisher.convert");
        oldCtr.getVersionInfo().setVersionNotes("disabled after converting to new notification object");
        EntityStorage.get().save(oldCtr, true);
    }
}

