/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.notification.service;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.mail.MailAddress;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.mail.MailPart;
import com.gridnine.xtrip.common.model.mail.MailServerParameters;
import com.gridnine.xtrip.common.model.mail.MailServerSettings;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.EventNotification;
import com.gridnine.xtrip.common.model.system.EventNotificationIndex;
import com.gridnine.xtrip.common.model.system.EventNotificationRecipient;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.model.mail.MailConfigUtil;
import com.gridnine.xtrip.server.model.mail.MailSender;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class NotificationsProcessingScheduledTask
extends BaseScheduledTask {
    private static final String TAG = "processing";

    protected void doJob() throws Exception {
        if (!DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.NOTIFICATIONS_ENABLED, (boolean)false)) {
            this.log.debug("notifications disabled");
            return;
        }
        try {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)EventNotificationIndex.Property.active.name(), (Object)Boolean.TRUE));
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)EventNotificationIndex.Property.mailingDate.name(), (Object)new Date()));
            for (EventNotificationIndex idx : EntityStorage.get().search(EventNotificationIndex.class, query).getData()) {
                try {
                    EntityContainer ctr = EntityStorage.get().resolve(idx.getSource());
                    if (ctr == null) continue;
                    this.sendEmail((EntityContainer<EventNotification>)ctr);
                    EventNotification eventNotification = (EventNotification)ctr.getEntity();
                    eventNotification.setMailingDate(null);
                    if (eventNotification.isRepeatOnceYear() && eventNotification.getAlarmDate().before(new Date())) {
                        LocalDateTime dateTimeNextSendEmail = LocalDateTime.now().plusYears(1L);
                        eventNotification.setAlarmDate(DateUtils.toJavaDate((LocalDateTime)dateTimeNextSendEmail));
                        SysLogHelper.audit(ctr.toReference(), TAG, MessageType.MESSAGE, "\u0414\u0430\u0442\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e email " + dateTimeNextSendEmail.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm")));
                    }
                    VersionInfo versionInfo = ctr.getVersionInfo();
                    versionInfo.setDataSource("NotificationsProcessingScheduledTask");
                    versionInfo.setVersionNotes("process send email");
                    EntityStorage.get().save(ctr, true);
                }
                catch (Exception e) {
                    SysLogHelper.audit(idx.getSource(), TAG, MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043d\u0430\u043f\u043e\u043c\u0438\u043d\u0430\u043d\u0438\u044f", (Throwable)e, (Object[])new Object[0]));
                }
            }
        }
        catch (Exception e) {
            this.log.error("failed processing notifications", (Throwable)e);
        }
    }

    private void sendEmail(EntityContainer<EventNotification> notification) {
        MailSender sender = (MailSender)Environment.getPublished(MailSender.class);
        if (!sender.isEnabled()) {
            SysLogHelper.audit(notification.toReference(), TAG, MessageType.WARNING, "\u043f\u043e\u0447\u0442\u043e\u0432\u043e\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e - \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u043f\u043e\u0447\u0442\u043e\u0432\u044b\u0439 \u0441\u0435\u0440\u0432\u0438\u0441");
            return;
        }
        List<MailAddress> addresses = this.collectAddresses((EventNotification)notification.getEntity());
        if (addresses.isEmpty()) {
            SysLogHelper.audit(notification.toReference(), TAG, MessageType.WARNING, "\u043f\u043e\u0447\u0442\u043e\u0432\u043e\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e - \u043f\u0443\u0441\u0442\u043e\u0439 \u0441\u043f\u0438\u0441\u043e\u043a \u0430\u0434\u0440\u0435\u0441\u043e\u0432 \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u0435\u0439");
            return;
        }
        MailServerSettings settings = MailConfigUtil.readMailServerParameters();
        MailServerParameters mailServerParameters = settings.getMailServerParameters();
        MailDocument mailDoc = new MailDocument();
        MailAddress ma = new MailAddress();
        ma.setName("MOM no-reply support");
        if (!TextUtil.isBlank((String)settings.getDefaultFrom())) {
            ma.setAddress(settings.getDefaultFrom());
        } else if (!TextUtil.isBlank((String)mailServerParameters.getUser())) {
            ma.setAddress(mailServerParameters.getUser());
        } else {
            ma.setAddress("no-reply@sabre.com");
        }
        mailDoc.setFrom(ma);
        mailDoc.getTo().addAll(addresses);
        mailDoc.setSubject(L10nResourcesManager.getStr((String)Messages.EmailEventNotificationTask_reminderEvent, (Object[])new Object[]{((EventNotification)notification.getEntity()).getTitle()}));
        MailPart mailPart = new MailPart();
        mailPart.setContentType(ContentType.TEXT);
        mailPart.setData(this.renderBody((EventNotification)notification.getEntity(), sender.getAdminAddress()).getBytes(StandardCharsets.UTF_8));
        mailDoc.setBody(mailPart);
        if (!TextUtil.isBlank((String)mailServerParameters.getUser())) {
            sender.send(mailDoc, mailServerParameters);
        } else {
            sender.send(mailDoc);
        }
        SysLogHelper.audit(notification.toReference(), TAG, MessageType.MESSAGE, "\u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u043e\u0447\u0442\u043e\u0432\u043e\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043d\u0430 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u0430\u0434\u0440\u0435\u0441\u0430: " + addresses.stream().map(MailAddress::getAddress).collect(Collectors.joining(", ")));
    }

    private List<MailAddress> collectAddresses(EventNotification notification) {
        ArrayList<MailAddress> result = new ArrayList<MailAddress>(notification.getRecipients().size());
        HashSet<String> emails = new HashSet<String>();
        for (EventNotificationRecipient recipient : notification.getRecipients()) {
            MailAddress ma = new MailAddress();
            ma.setName(recipient.getName());
            if (!TextUtil.isBlank((String)recipient.getEmail())) {
                ma.setAddress(recipient.getEmail());
            } else {
                EntityContainer ctr = null;
                if (recipient.getProfile() != null) {
                    ctr = EntityStorage.get().resolve(recipient.getProfile());
                } else if (!TextUtil.isBlank((String)recipient.getLogin())) {
                    ctr = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)recipient.getLogin());
                }
                if (ctr == null) continue;
                for (Communication cmm : ((Person)ctr.getEntity()).getCommunications()) {
                    if (cmm.getType() != CommunicationType.EMAIL) continue;
                    ma.setAddress(cmm.getSense());
                    break;
                }
            }
            if (emails.contains(ma.getAddress())) continue;
            result.add(ma);
            emails.add(ma.getAddress());
        }
        return result;
    }

    private String renderBody(EventNotification notification, MailAddress adminAddress) {
        StringBuilder buf = new StringBuilder();
        buf.append(L10nResourcesManager.getStr((String)Messages.EmailEventNotificationTask_reminderEvent, (Object[])new Object[]{notification.getTitle()})).append("\n\n").append(L10nResourcesManager.getStr((String)Messages.EmailEventNotificationTask_reminderText, (Object[])new Object[]{notification.getText()}));
        if (notification.getEventDate() != null) {
            buf.append("\n\n").append(L10nResourcesManager.getStr((String)Messages.EmailEventNotificationTask_dateEvent, (Object[])new Object[]{new SimpleDateFormat("dd.MM.yyyy - hh:mm").format(notification.getEventDate())}));
        }
        if (notification.getEntityReference() != null) {
            buf.append("\n\n").append(L10nResourcesManager.getStr((String)Messages.EmailEventNotificationTask_objectReminder, (Object[])new Object[]{notification.getEntityReference().toString()}));
        }
        buf.append("\n\n----------------------------------------------\n");
        buf.append(L10nResourcesManager.getStr((String)Messages.EmailEventNotificationTask_dontReplayOnThisLetter, (Object[])new Object[0]));
        if (adminAddress != null && adminAddress.getAddress() != null) {
            buf.append("\n").append(L10nResourcesManager.getStr((String)Messages.EmailEventNotificationTask_ifYouBelieveHaveReceivedByError, (Object[])new Object[0]) + adminAddress.getAddress());
        }
        return buf.toString();
    }
}

