/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.number.helpers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjects;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.format.object.Format;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FinanceDocumentNumberHelper {
    private static Logger log = LoggerFactory.getLogger(FinanceDocumentNumberHelper.class);

    public static void generateNumber(FinanceDocument document, EntityStorageContext storageContext) {
        FinanceDocumentSettings settings;
        String pattern = null;
        boolean vendorDocument = document.isVendorDocument();
        FinanceDocumentsProperties properties = FinanceDocumentHelper.getFinanceDocumentsProperties((EntityReference<Organization>)document.getAgency(), false);
        if (properties != null && (settings = (FinanceDocumentSettings)properties.getFinanceDocumentsSettings().stream().filter(item -> item.getType() == document.getType()).findFirst().orElse(null)) != null && !TextUtil.isBlank((String)(vendorDocument ? settings.getNumberPatternVendor() : settings.getNumberPattern()))) {
            String string = pattern = vendorDocument ? settings.getNumberPatternVendor() : settings.getNumberPattern();
        }
        if (pattern != null) {
            Format format = Format.of(pattern);
            Format.FormatObjectData data = Format.FormatObjectDataBuilder.get().object((Object)document, ModelFormatObjects.FINANCE_DOCUMENT.getId()).build();
            document.setNumber(format.format(data, storageContext));
        }
    }
}

