/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.number.helpers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.PaymentDocumentType;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjects;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.PaymentDocumentHandler;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PaymentDocumentSettings;
import com.gridnine.xtrip.common.model.profile.PaymentDocumentsProperties;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.format.object.Format;
import com.gridnine.xtrip.server.model.helpers.PaymentDocumentHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PaymentDocumentNumberHelper {
    private static Logger log = LoggerFactory.getLogger(PaymentDocumentNumberHelper.class);

    public static void generateNumber(BasePaymentDocument document, EntityStorageContext storageContext) {
        PaymentDocumentHandler handler;
        String pattern = null;
        PaymentDocumentsProperties properties = PaymentDocumentHelper.getPaymentDocumentsProperties((EntityReference<Organization>)document.getOrganization(), false);
        if (properties != null && (handler = HandlersRegistry.get().findPaymentDocumentHandler(document.getClass())) != null) {
            PaymentDocumentType type = handler.getDocumentType(document);
            PaymentDocumentSettings settings = properties.getPaymentDocumentsSettings().stream().filter(item -> item.getType() == type).findFirst().orElse(null);
            if (settings != null && !TextUtil.isBlank((String)settings.getNumberPattern())) {
                pattern = settings.getNumberPattern();
            }
        }
        if (pattern != null) {
            Format format = Format.of(pattern);
            Format.FormatObjectData data = Format.FormatObjectDataBuilder.get().object((Object)document, ModelFormatObjects.PAYMENT_DOCUMENT.getId()).build();
            document.setNumber(format.format(data, storageContext));
        }
    }
}

