/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.number.helpers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjects;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.ShipmentProperties;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.format.object.Format;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShipmentNumberHelper {
    private static Logger log = LoggerFactory.getLogger(ShipmentNumberHelper.class);

    public static void generateNumber(Shipment shipment, EntityStorageContext storageContext) {
        String pattern = null;
        ShipmentProperties properties = ShipmentHelper.getShipmentsProperties((EntityReference<Organization>)shipment.getSupplier(), false);
        if (properties != null) {
            if (shipment.isCorrection()) {
                if (!TextUtil.isBlank((String)properties.getNumberPatternCorrection())) {
                    pattern = properties.getNumberPatternCorrection();
                }
            } else if (!TextUtil.isBlank((String)properties.getNumberPattern())) {
                pattern = properties.getNumberPattern();
            }
        }
        if (pattern != null) {
            Format format = Format.of(pattern);
            Format.FormatObjectData data = Format.FormatObjectDataBuilder.get().object((Object)shipment, ModelFormatObjects.SHIPMENT.getId()).build();
            shipment.setNumber(format.format(data, storageContext));
        }
    }
}

