/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.primorskoe;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLImportTestUtil {
    private static final int MAX_ENTRIES_PER_DOCUMENT = 600;
    private static final String IMPORTER = "importer";
    private static final String MAIN_AGENCY_CODE = "02\u0412\u0412\u041e";
    private static final Map<String, EntityContainer<? extends BaseEntity>> entityContainers = new HashMap<String, EntityContainer<? extends BaseEntity>>();
    private static final Map<String, Object> objects = new HashMap<String, Object>();
    private static final Map<String, BaseDictionary> dictionaryContainers = new HashMap<String, BaseDictionary>();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss");

    public static List<Document> convert(Document sourceDocument, List<Message> messages) throws Exception {
        XMLImportTestUtil.createRequiredEntities(messages);
        ArrayList<Document> convertDocuments = new ArrayList<Document>();
        Document convertDocument = null;
        Node element = null;
        int count = 0;
        for (EntityContainer<? extends BaseEntity> entityContainer : entityContainers.values()) {
            if (count % 600 == 0) {
                count = 0;
                convertDocument = DocumentBuilderHelper.newDocument();
                convertDocuments.add(convertDocument);
                element = convertDocument.createElementNS(null, "objects");
                convertDocument.appendChild(element);
            }
            Element entityElement = XMLImportTestUtil.createEntityContainerElement(convertDocument, entityContainer);
            element.appendChild(entityElement);
            element.setAttribute("totalCount", String.valueOf(count + 1));
            ++count;
        }
        return convertDocuments;
    }

    private static void createRequiredEntities(List<Message> messages) throws Exception {
        Document document = XMLImportTestUtil.getSourceDocument(new File("C:/primorskoe/primary.xml"));
        XMLImportTestUtil.convertOrganizations(document, messages);
        XMLImportTestUtil.convertSalesPoints(document, messages);
    }

    public static void convertOrganizations(Document document, List<Message> messages) throws Exception {
        NodeList nodeList = document.getElementsByTagName("AGN");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element[] agencyElements = XmlUtil.getElements((Element)((Element)nodeList.item(i)), (String)"DATA");
            for (int j = 0; j < agencyElements.length; ++j) {
                System.out.println(String.format(" -> ORGANIZATION FROM AGENCY -> %s of %s", String.valueOf(j + 1), String.valueOf(agencyElements.length)));
                Element agencyElement = agencyElements[j];
                XMLImportTestUtil.createOrganizationContainerFromAgency(document, agencyElement, messages);
            }
        }
    }

    public static void convertSalesPoints(Document document, List<Message> messages) throws Exception {
        NodeList nodeList = document.getElementsByTagName("REGP");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element[] salesPointElements = XmlUtil.getElements((Element)((Element)nodeList.item(i)), (String)"DATA");
            for (int j = 0; j < salesPointElements.length; ++j) {
                System.out.println(String.format(" -> SALES POINT -> %s of %s", String.valueOf(j + 1), String.valueOf(salesPointElements.length)));
                Element salesPointElement = salesPointElements[j];
                XMLImportTestUtil.createSalesPointContainer(document, salesPointElement, messages);
            }
        }
    }

    private static void createOrganizationContainerFromAgency(Document document, Element element, List<Message> messages) throws Exception {
        String street;
        String kpp;
        String inn;
        String name;
        String id = XmlUtil.getValue((Element)element, (String)"@AGN_CODE");
        if (TextUtil.isBlank((String)id)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c id \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0430\u0442\u0442\u0440\u0438\u0431\u0443\u0442 \"AGN_CODE\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{element}));
            return;
        }
        if (entityContainers.containsKey(id)) {
            return;
        }
        String title = id;
        boolean extendedTitle = false;
        EntityContainer<Organization> organizationContainer = XMLImportTestUtil.createEntityContainer(Organization.class, UUIDGenerator.generate((boolean)true).toString());
        Organization organization = (Organization)organizationContainer.getEntity();
        String code = XmlUtil.getValue((Element)element, (String)"@NSO_SID");
        if (!TextUtil.isBlank((String)code)) {
            organization.setCode(code.trim());
        }
        if (!TextUtil.isBlank((String)(name = XmlUtil.getValue((Element)element, (String)"@NAME")))) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, name.trim());
            }
            L10nStringHelper.setValue((L10nString)organization.getShortName(), (String)name.trim(), (Locale)LocaleUtil.LOCALE_RU);
            L10nStringHelper.setValue((L10nString)organization.getFullName(), (String)name.trim(), (Locale)LocaleUtil.LOCALE_RU);
        }
        if (!TextUtil.isBlank((String)(inn = XmlUtil.getValue((Element)element, (String)"@INN")))) {
            organization.setRegistrationId(inn.trim());
        }
        if (!TextUtil.isBlank((String)(kpp = XmlUtil.getValue((Element)element, (String)"@KPP")))) {
            organization.setOkpoCode(kpp.trim());
        }
        if (!TextUtil.isBlank((String)(street = XmlUtil.getValue((Element)element, (String)"@ADDRESS")))) {
            Address address = new Address();
            address.setAddressType(AddressType.LEGAL);
            L10nStringHelper.setValue((L10nString)address.getAddress(), (String)street.trim(), (Locale)LocaleUtil.LOCALE_RU);
            organization.getAddresses().add(address);
        }
        organization.setForeign(false);
        organization.getTypes().add(OrganizationType.AGENCY);
        entityContainers.put(id, organizationContainer);
    }

    private static void createSalesPointContainer(Document document, Element element, List<Message> messages) throws Exception {
        String validatorNumbersString;
        String agencyCode;
        String name;
        String id = XmlUtil.getValue((Element)element, (String)"@NSO_SID");
        if (TextUtil.isBlank((String)id)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c id \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0422\u043e\u0447\u043a\u0430 \u043f\u0440\u043e\u0434\u0430\u0436\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0422\u043e\u0447\u043a\u0430 \u043f\u0440\u043e\u0434\u0430\u0436\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0430\u0442\u0442\u0440\u0438\u0431\u0443\u0442 \"NSO_SID\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{element}));
            return;
        }
        if (entityContainers.containsKey(id)) {
            return;
        }
        String title = id;
        boolean extendedTitle = false;
        EntityContainer<SalesPoint> salesPointContainer = XMLImportTestUtil.createEntityContainer(SalesPoint.class, UUIDGenerator.generate((boolean)true).toString());
        SalesPoint salesPoint = (SalesPoint)salesPointContainer.getEntity();
        String code = XmlUtil.getValue((Element)element, (String)"@NSO_SID");
        if (!TextUtil.isBlank((String)code)) {
            salesPoint.setCode(code.trim());
        }
        if (!TextUtil.isBlank((String)(name = XmlUtil.getValue((Element)element, (String)"@NAME")))) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, name.trim());
            }
            salesPoint.setShortName(name.trim());
            salesPoint.setFullName(name.trim());
        }
        if (!TextUtil.isBlank((String)(agencyCode = XmlUtil.getValue((Element)element, (String)"@AGN_CODE")))) {
            EntityContainer<? extends BaseEntity> agency = entityContainers.get(agencyCode.trim());
            if (agency != null) {
                salesPoint.setAgency(agency.toReference());
            } else {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e \u0434\u043b\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0422\u043e\u0447\u043a\u0430 \u043f\u0440\u043e\u0434\u0430\u0436\"", (String)String.format("\u0410\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e \u0441 \u043a\u043e\u0434\u043e\u043c \"%s\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e", agencyCode), (Object[])new Object[]{element}));
            }
        }
        if (!TextUtil.isBlank((String)(validatorNumbersString = XmlUtil.getValue((Element)element, (String)"@VALDRS")))) {
            List validatorNumbers = TextUtil.split((String)validatorNumbersString.trim(), (String)",", (boolean)true, (boolean)true);
            Collections.sort(validatorNumbers);
            for (String validatorNumber : validatorNumbers) {
                Validator validator = new Validator();
                int index = validatorNumber.indexOf("-");
                validator.setNumber(index >= 0 ? validatorNumber.substring(0, index) : validatorNumber);
                EntityContainer<? extends BaseEntity> agency = entityContainers.get(MAIN_AGENCY_CODE);
                if (agency != null) {
                    validator.setAgency(agency.toReference());
                }
                salesPoint.getValidators().add(validator);
            }
        }
        entityContainers.put(code, salesPointContainer);
    }

    private static final <T extends BaseEntity> EntityContainer<T> createEntityContainer(Class<T> entityClass, String uid) throws Exception {
        EntityContainer entityContainer = new EntityContainer(entityClass, uid);
        entityContainer.setCreatedBy(IMPORTER);
        entityContainer.setModifiedBy(IMPORTER);
        VersionInfo versionInfo = entityContainer.getVersionInfo();
        String versionInfoUid = UUIDGenerator.generate((boolean)false).toString();
        versionInfo.setUid(versionInfoUid);
        versionInfo.setCreatedBy(IMPORTER);
        versionInfo.setModifiedBy(IMPORTER);
        String dataSource = "file";
        versionInfo.setDataSource(dataSource);
        return entityContainer;
    }

    private static final <T extends BaseDictionary> T createDictionaryContainer(Class<T> dictionaryClass, String uid) throws Exception {
        BaseDictionary dictionaryContainer = (BaseDictionary)dictionaryClass.newInstance();
        dictionaryContainer.setUid(uid);
        dictionaryContainer.setCode(uid);
        dictionaryContainer.setCreatedBy(IMPORTER);
        dictionaryContainer.setModifiedBy(IMPORTER);
        return (T)dictionaryContainer;
    }

    private static <T extends BaseEntity> Element createEntityContainerElement(Document convertDocument, EntityContainer<T> entityContainer) throws Exception {
        Element entityContainerElement = convertDocument.createElementNS(null, "object");
        entityContainerElement.setAttribute("class", EntityContainer.class.getName());
        entityContainer.toXML(entityContainerElement);
        return entityContainerElement;
    }

    private static <D extends BaseDictionary> Element createDictionatyContainerElement(Document convertDocument, D dictionaryContainer) throws Exception {
        Element dictionaryContainerElement = convertDocument.createElementNS(null, "object");
        dictionaryContainerElement.setAttribute("class", dictionaryContainer.getClass().getName());
        dictionaryContainer.toXML(dictionaryContainerElement);
        return dictionaryContainerElement;
    }

    public static Document getSourceDocument(File file) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        return document;
    }

    public static String toString(Node node) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Transformer transformer = XUtil.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.transform(new DOMSource(node), new StreamResult(baos));
        return baos.toString("utf-8");
    }

    public static String toStructure(Node node) throws Exception {
        return XMLImportTestUtil.toStructure(node, 0);
    }

    public static String toStructure(Node node, int depth) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TextUtil.repeat((String)"    ", (int)depth));
        stringBuilder.append(node.getNodeName());
        stringBuilder.append("\n");
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            stringBuilder.append(XMLImportTestUtil.toStructure(children.item(i), depth + 1));
        }
        return stringBuilder.toString();
    }

    public static void verbose(Document sourceDocument, Document convertDocument) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("= SOURCE STRING ===============================");
        stringBuilder.append("\n");
        stringBuilder.append(XMLImportTestUtil.toString(sourceDocument));
        stringBuilder.append("= CONVERT STRING ==============================");
        stringBuilder.append("\n");
        stringBuilder.append(XMLImportTestUtil.toString(convertDocument));
        stringBuilder.append("= SOURCE STRUCTURE ============================");
        stringBuilder.append("\n");
        stringBuilder.append(XMLImportTestUtil.toStructure(sourceDocument));
        stringBuilder.append("= CONVERT STRUCTURE ===========================");
        stringBuilder.append("\n");
        stringBuilder.append(XMLImportTestUtil.toStructure(convertDocument));
        System.out.println(stringBuilder.toString());
    }
}

