/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.rest.jenkins;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.AuthUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.model.rest.jenkins.IbusJenkinsContextKeys;
import com.gridnine.xtrip.server.web.rest.AuthRestInterceptor;
import com.gridnine.xtrip.server.web.rest.GenericRestInterceptorAdapter;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class JenkinsAuthInterceptor
extends GenericRestInterceptorAdapter
implements AuthRestInterceptor {
    private static final String LOGIN = "login";
    private static final String PASSWORD = "password";
    private static final String AUTH_HEADER = "MOM_AUTH";

    public void authorize(RestContext context, Map<String, Object> data) {
        String password;
        String login;
        String authHeader = context.getRequest().getHeader(AUTH_HEADER);
        if (!StringUtils.isBlank((String)authHeader)) {
            String[] tokens = AuthUtil.decryptToken((Serializable)((Object)authHeader));
            login = tokens[0];
            password = tokens[1];
        } else {
            login = context.getRequest().getHeader(LOGIN);
            password = context.getRequest().getHeader(PASSWORD);
        }
        if (StringUtils.isBlank((String)login)) {
            throw Xeption.forEndUser((String)"Login shouldn't be empty!", (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((String)password)) {
            throw Xeption.forEndUser((String)"Password shouldn't be empty!", (Object[])new Object[0]);
        }
        try {
            LogicalStorage.get().authorize(login, password.toCharArray());
        }
        catch (Exception e) {
            context.setStatus(403);
            throw Xeption.forEndUser((String)"Invalid login or password", (Throwable)e, (Object[])new Object[0]);
        }
        data.put(IbusJenkinsContextKeys.LOGIN.name(), login);
    }
}

