/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.rest.migration;

import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.db.storage.model.PhysicalDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.migration.MigrationDeleteObjectRequest;
import com.gridnine.xtrip.server.model.rest.migration.MigrationDeletedObject;
import com.gridnine.xtrip.server.model.rest.migration.MigrationOperationResponse;
import com.gridnine.xtrip.server.model.rest.migration.MigrationSaveEntityProcessor;
import java.util.List;

public class MigrationDeleteDictionaryProcessor
extends BaseProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageContext ctx) throws Exception {
        MigrationDeleteObjectRequest request = (MigrationDeleteObjectRequest)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        MigrationOperationResponse result = new MigrationOperationResponse();
        PhysicalStorage primaryStorage = MigrationSaveEntityProcessor.getPrimaryStorage();
        List deletedObjects = (List)MigrationSaveEntityProcessor.readObject(request.getObjects());
        if (deletedObjects.size() > 0) {
            LogicalSession ls = LogicalStorage.get().beginUnitOfWork();
            try {
                for (MigrationDeletedObject deletedObject : deletedObjects) {
                    PhysicalDictionaryData existingDictionary = primaryStorage.getDictionaryStorage().findDictionaryByUid(deletedObject.getCls(), deletedObject.getUid(), false, ls.getSession());
                    if (existingDictionary == null) continue;
                    primaryStorage.getDictionaryStorage().deleteDictionary(existingDictionary, ls.getSession());
                }
                LogicalStorage.get().endUnitOfWork(ls, true);
            }
            finally {
                LogicalStorage.get().cancelUnitOfWork(ls);
            }
        }
        result.setSuccessfull(true);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

