/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.rest.migration;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.cache.asset.ModifiedObjectReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.standard.helpers.URLConnectionHelper;
import com.gridnine.xtrip.common.model.system.BillingTransactionChange;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.migration.MigrationTaskConfiguration;
import com.gridnine.xtrip.common.model.tasks.standard.DeletedObjectReference;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.common.util.AuthUtil;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernatePhysicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernateSessionManager;
import com.gridnine.xtrip.server.db.storage.model.AssetPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DictionaryData;
import com.gridnine.xtrip.server.db.storage.model.DictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.db.storage.model.PhysicalAssetData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.model.PhysicalVersionData;
import com.gridnine.xtrip.server.model.rest.migration.MigrationDeletedObject;
import com.gridnine.xtrip.server.model.rest.migration.MigrationEntityBatch;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.w3c.dom.Element;

public class MigrationLongRunningTask
extends BaseLongRunningTask<MigrationTaskConfiguration> {
    private int threadsCount;
    private int batchSize;
    private boolean secondPass;
    private String url;
    private String login;
    private String password;
    private volatile int totalCount = -1;
    private volatile AtomicInteger doneCount = new AtomicInteger(0);
    private Date startDate;
    private volatile List<Part> partList = null;
    private Date doneTo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob(final LongRunningTask.EventsCallback callback) throws Exception {
        this.log.info("Migration started ---------------------------------------------------------------");
        this.remoteCall("checkAvailability", null);
        Date startDate = this.getDate(callback);
        Date finishDate = new Date();
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0443\u0441\u043a\u0430: ", (Object[])new Object[0]));
        DateFormat dateTimeFormat = MigrationLongRunningTask.createDateTimeFormat();
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"  \u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430: {0}", (Object[])new Object[]{dateTimeFormat.format(startDate)}));
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"  \u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430: {0}", (Object[])new Object[]{dateTimeFormat.format(finishDate)}));
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"  \u0412\u0442\u043e\u0440\u043e\u0439 \u043f\u0440\u043e\u0445\u043e\u0434: {0}", (Object[])new Object[]{this.secondPass}));
        this.partList = this.getPartList(startDate, finishDate);
        Collection<Class<?>> entityTypeList = this.getEntityTypeList();
        int typeCount = entityTypeList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("part count %d, type count %d", this.partList.size(), typeCount));
        }
        final AtomicReference exceptionHolder = new AtomicReference();
        ExecutorServiceFacade service = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newFixedThreadPool(this.getClass().getName(), this.threadsCount);
        try {
            final int maxCount = this.partList.size() * typeCount;
            if (this.totalCount == -1 || this.totalCount < maxCount) {
                this.totalCount = maxCount;
            }
            this.doneCount.set(this.totalCount - maxCount);
            final int resumeDelta = this.doneCount.get();
            final CountDownLatch countDown = new CountDownLatch(maxCount);
            final int pd = Math.max(maxCount / 20, 1);
            final AtomicLong lastUpdate = new AtomicLong(System.currentTimeMillis());
            for (final Part part : this.partList) {
                part.getDownCount().set(typeCount);
                Part part1 = part;
                for (final Class<?> entityType : entityTypeList) {
                    service.submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            block11: {
                                block10: {
                                    if (!MigrationLongRunningTask.this.isToBeStopped() && exceptionHolder.get() == null) break block10;
                                    countDown.countDown();
                                    return;
                                }
                                if (MigrationLongRunningTask.this.processEntityType(entityType, part, callback)) break block11;
                                countDown.countDown();
                                return;
                            }
                            try {
                                try {
                                    part.getDownCount().decrementAndGet();
                                    long current = (long)maxCount - countDown.getCount() + 1L;
                                    byte progress = (byte)(100L * (current + (long)resumeDelta) / (long)(maxCount + resumeDelta));
                                    if ((current + (long)resumeDelta) % (long)pd == 0L || progress >= 100 || MigrationLongRunningTask.this.isToBeStopped() || System.currentTimeMillis() - lastUpdate.get() > 300000L) {
                                        lastUpdate.set(System.currentTimeMillis());
                                        callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e {0} \u0438\u0437 {1}", (Object[])new Object[]{current + (long)resumeDelta, maxCount + resumeDelta}));
                                        callback.updateProgress(progress);
                                    }
                                }
                                catch (Throwable t) {
                                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0437\u0430\u0434\u0430\u0447\u0438", (Throwable)t, (Object[])new Object[0]));
                                    exceptionHolder.set(t instanceof Exception ? (Exception)t : new Exception(t));
                                    try {
                                        MigrationLongRunningTask.this.stop();
                                    }
                                    catch (Exception e) {
                                        MigrationLongRunningTask.this.log.error("unable to stop task", (Throwable)e);
                                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", (Object[])new Object[0]));
                                        exceptionHolder.set(e);
                                    }
                                }
                            }
                            finally {
                                countDown.countDown();
                            }
                        }
                    });
                }
            }
            countDown.await();
        }
        finally {
            service.dispose();
        }
        if (this.partList != null) {
            Date date = null;
            boolean hasUnfinishedPeriods = false;
            for (Part part : this.partList) {
                if (part.getDownCount().get() != 0) {
                    hasUnfinishedPeriods = true;
                    break;
                }
                date = part.getFrom();
            }
            if (date == null || !hasUnfinishedPeriods) {
                date = finishDate;
            }
            this.log.info("doneTo=" + MigrationLongRunningTask.createDateTimeFormat().format(date));
            LogicalStorage.get().getDbPropertiesStorage().putValue("migration.doneTo", MigrationLongRunningTask.createDateTimeFormat().format(date));
        }
        if (exceptionHolder.get() != null) {
            this.stop();
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0437\u0430\u0434\u0430\u0447\u0430 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0438\u0437 \u0437\u0430 \u043e\u0448\u0438\u0431\u043a\u0438", (Object[])new Object[0]));
            return;
        }
        callback.taskFinished();
        this.log.info("Migration  procedure finished ---------------------------------------------------------------");
    }

    private boolean processEntityType(Class<?> entityType, Part part, LongRunningTask.EventsCallback callback) throws Exception {
        if (BaseDictionary.class.isAssignableFrom(entityType)) {
            return this.processStorage(entityType, part, callback, new MigrationProcessStorageAdapter<BaseDictionary>(){

                @Override
                public List<String> getUids(Part part, Class<BaseDictionary> clazz, PhysicalStorage primaryPhysicalStorage, PhysicalStorageSession session) throws Exception {
                    return primaryPhysicalStorage.getDictionaryStorage().getDictionaryUids(clazz, part.getFrom(), part.getTo(), false, false, SortOrder.DESC, null, session);
                }

                @Override
                public Object getObject(Class<BaseDictionary> dictionaryClass, String uid, PhysicalStorage primaryPhysicalStorage) throws Exception {
                    return MigrationLongRunningTask.this.createDictionaryObject(dictionaryClass, uid, primaryPhysicalStorage);
                }
            }, "saveDictionary", "deleteDictionary");
        }
        if (BaseAsset.class.isAssignableFrom(entityType)) {
            return this.processStorage(entityType, part, callback, new MigrationProcessStorageAdapter<BaseAsset>(){

                @Override
                public List<String> getUids(Part part, Class<BaseAsset> clazz, PhysicalStorage primaryPhysicalStorage, PhysicalStorageSession session) throws Exception {
                    return primaryPhysicalStorage.getAssetStorage().getAssetUids(clazz, part.getFrom(), part.getTo(), SortOrder.DESC, null, session);
                }

                @Override
                public Object getObject(Class<BaseAsset> dictionaryClass, String uid, PhysicalStorage primaryPhysicalStorage) throws Exception {
                    return MigrationLongRunningTask.this.createAssetObject(dictionaryClass, uid, primaryPhysicalStorage);
                }
            }, "saveAsset", "deleteAsset");
        }
        return this.processStorage(entityType, part, callback, new MigrationProcessStorageAdapter<BaseEntity>(){

            @Override
            public List<String> getUids(Part part, Class<BaseEntity> clazz, PhysicalStorage primaryPhysicalStorage, PhysicalStorageSession session) throws Exception {
                return primaryPhysicalStorage.getEntityStorage().getEntityUids(clazz, part.getFrom(), part.getTo(), false, false, SortOrder.DESC, null, session);
            }

            @Override
            public Object getObject(Class<BaseEntity> dictionaryClass, String uid, PhysicalStorage primaryPhysicalStorage) throws Exception {
                return MigrationLongRunningTask.this.createEntityObject(dictionaryClass, uid, primaryPhysicalStorage);
            }
        }, "saveEntity", "deleteEntity");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createAssetObject(Class<BaseAsset> dictionaryClass, String uid, PhysicalStorage primaryPhysicalStorage) throws Exception {
        try (PhysicalStorageSession session = primaryPhysicalStorage.createSession(null);){
            PhysicalAssetData asset = primaryPhysicalStorage.getAssetStorage().loadAsset(dictionaryClass, uid, session);
            asset.getContext().clear();
            PhysicalAssetData physicalAssetData = asset;
            return physicalAssetData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createDictionaryObject(Class<BaseDictionary> dictionaryClass, String uid, PhysicalStorage primaryPhysicalStorage) throws Exception {
        try (PhysicalStorageSession session = primaryPhysicalStorage.createSession(null);){
            PhysicalDictionaryData dict = primaryPhysicalStorage.getDictionaryStorage().findDictionaryByUid(dictionaryClass, uid, false, session);
            dict.getContext().clear();
            PhysicalDictionaryData physicalDictionaryData = dict;
            return physicalDictionaryData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createEntityObject(Class<BaseEntity> dictionaryClass, String uid, PhysicalStorage primaryPhysicalStorage) throws Exception {
        MigrationEntityBatch batch = new MigrationEntityBatch();
        try (PhysicalStorageSession session = primaryPhysicalStorage.createSession(null);){
            PhysicalEntityData entityData = primaryPhysicalStorage.getEntityStorage().loadEntity(dictionaryClass, uid, null, session);
            int[] versions = new int[entityData.getVersionsCount()];
            for (int n = 0; n < entityData.getVersionsCount(); ++n) {
                versions[n] = n;
            }
            for (PhysicalVersionData version : primaryPhysicalStorage.getEntityStorage().getVersions(entityData, session, versions)) {
                if (entityData.getVersions().stream().anyMatch(v -> v.getVersionNumber() == version.getVersionNumber())) continue;
                entityData.getVersions().add(version);
            }
            for (IndexHandler indexHandler : LogicalStorageRegistry.get().getIndexHandlers(dictionaryClass)) {
                Map indexesMap = primaryPhysicalStorage.getEntityStorage().getIndexes(indexHandler.getIndexClass(), uid, session);
                if (indexesMap.isEmpty() || ((List)indexesMap.entrySet().iterator().next().getValue()).isEmpty()) continue;
                batch.getIndexes().put(indexHandler.getDataClass().getName(), (List<BaseIndexData<BaseEntity, EntityIndex<BaseEntity>>>)indexesMap.entrySet().iterator().next().getValue());
            }
            entityData.getContext().clear();
            for (PhysicalVersionData version : entityData.getVersions()) {
                version.getContext().clear();
            }
            batch.setEntity((PhysicalEntityData<BaseEntity>)entityData);
            MigrationEntityBatch migrationEntityBatch = batch;
            return migrationEntityBatch;
        }
    }

    private void remoteCall(String path, byte[] payload) throws Exception {
        boolean successfull = false;
        String errorMessage = null;
        try {
            URLConnection connection = URLConnectionHelper.prepareURLConnection((URL)new URL(String.format("%s/xtrip-migration/%s", this.url.startsWith("http://") ? this.url : "http://" + this.url, path)), null);
            connection.setDoInput(true);
            connection.setDoOutput(payload != null);
            connection.setUseCaches(false);
            ((HttpURLConnection)connection).setRequestMethod(payload == null ? "GET" : "POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("MOM_AUTH", AuthUtil.buildAuthToken((String)this.login, (char[])this.password.toCharArray()));
            if (payload != null) {
                try (OutputStream os = connection.getOutputStream();){
                    IoUtil.copyStream((InputStream)new ByteArrayInputStream(payload), (OutputStream)os, (int)256);
                    os.flush();
                }
            }
            JSONObject json = null;
            try (InputStream is = connection.getInputStream();){
                json = new JSONObject(new JSONTokener(is));
            }
            JSONObject result = json.getJSONObject("result");
            successfull = result.getBoolean("successfull");
            errorMessage = result.has("errorMessage") ? result.getString("errorMessage") : null;
        }
        catch (Exception e) {
            throw Xeption.forAdmin((String)"\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u044f \u043a \u043c\u0430\u0448\u0438\u043d\u0435 \u0441 \u043d\u043e\u0432\u044b\u043c \u041c\u041e\u041c", (Throwable)e, (Object[])new Object[0]);
        }
        if (!successfull) {
            throw Xeption.forAdmin((String)"\u043e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0432 \u043d\u043e\u0432\u044b\u0439 \u041c\u041e\u041c: {0}", (Object[])new Object[]{errorMessage});
        }
    }

    @Override
    public void configure(MigrationTaskConfiguration configuration) throws Exception {
        this.threadsCount = configuration.getThreadsCount() == null ? 1 : configuration.getThreadsCount();
        this.batchSize = configuration.getBatchSize() == null ? 10 : configuration.getBatchSize();
        this.url = configuration.getUrl();
        this.login = configuration.getLogin();
        this.secondPass = configuration.isSecondPass();
        this.password = configuration.getPassword();
        this.startDate = configuration.getStartDate();
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)MetaRegistryHelper.getDisplayName(MigrationTaskConfiguration.class), (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
        XHelper.writeInt((Element)elm, (String)"threadsCount", (int)this.threadsCount);
        XHelper.writeInt((Element)elm, (String)"batchSize", (int)this.batchSize);
        XHelper.writeInt((Element)elm, (String)"totalCount", (int)this.totalCount);
        XHelper.writeBoolean((Element)elm, (String)"secondPass", (boolean)this.secondPass);
        XHelper.writeString((Element)elm, (String)"url", (String)this.url);
        XHelper.writeString((Element)elm, (String)"login", (String)this.login);
        XHelper.writeString((Element)elm, (String)"password", (String)this.password);
        if (this.partList != null) {
            Date date = null;
            for (Part part : this.partList) {
                if (part.getDownCount().get() != 0) break;
                date = part.getFrom();
                this.doneCount.getAndIncrement();
            }
            if (date != null) {
                XHelper.writeDate((Element)elm, (String)"doneTo", date);
            }
        }
        XHelper.writeInt((Element)elm, (String)"doneCount", (int)this.doneCount.get());
        XHelper.writeDate((Element)elm, (String)"startDate", (Date)this.startDate);
    }

    public void fromXML(Element elm) throws Exception {
        this.totalCount = XHelper.readInt((Element)elm, (String)"totalCount", (int)-1);
        this.doneCount.set(XHelper.readInt((Element)elm, (String)"doneCount", (int)0));
        this.threadsCount = XHelper.readInt((Element)elm, (String)"threadsCount", (int)1);
        this.batchSize = XHelper.readInt((Element)elm, (String)"batchSize", (int)10);
        this.doneTo = XHelper.readDate((Element)elm, (String)"doneTo");
        this.secondPass = XHelper.readBoolean((Element)elm, (String)"secondPass", (boolean)false);
        this.url = XHelper.readString((Element)elm, (String)"url");
        this.login = XHelper.readString((Element)elm, (String)"login");
        this.password = XHelper.readString((Element)elm, (String)"password");
        this.startDate = XHelper.readDate((Element)elm, (String)"startDate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <D> boolean processStorage(Class<D> dictionaryClass, Part part, LongRunningTask.EventsCallback callback, MigrationProcessStorageAdapter adapter, String savePath, String deletePath) throws Exception {
        Object sb;
        PhysicalStorage primaryPhysicalStorage;
        block40: {
            if (this.isToBeStopped()) {
                return false;
            }
            primaryPhysicalStorage = LogicalStorageRegistry.get().getStorage(LogicalStorage.get().getPrimaryStorageUid());
            try (PhysicalStorageSession primaryUidsSession2 = primaryPhysicalStorage.createSession(null);){
                SearchResult searchResult;
                SearchQuery searchQuery = new SearchQuery();
                searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)DeletedObjectReference.Property.refType.name(), (Object)dictionaryClass.getName()));
                searchQuery.getCriteria().getCriterions().add(SearchCriterion.ge((String)DeletedObjectReference.Property.refDeleted.name(), (Object)part.getFrom()));
                searchQuery.getCriteria().getCriterions().add(SearchCriterion.le((String)DeletedObjectReference.Property.refDeleted.name(), (Object)part.getTo()));
                try {
                    searchResult = primaryPhysicalStorage.getAssetStorage().searchAssets(DeletedObjectReference.class, searchQuery, primaryUidsSession2);
                }
                catch (Exception e) {
                    this.log.error(String.format("unable to get deleted objects %s start = %s, end = %s", dictionaryClass.getSimpleName(), part.getFrom(), part.getTo()));
                    throw e;
                }
                List deletedList = searchResult.getData();
                if (deletedList.isEmpty()) break block40;
                List deletedBatches = CollectionUtil.split((Collection)deletedList, (int)this.batchSize);
                for (List deleteBatch : deletedBatches) {
                    ArrayList<MigrationDeletedObject> objects = new ArrayList<MigrationDeletedObject>();
                    for (DeletedObjectReference item : deleteBatch) {
                        MigrationDeletedObject migrationDeletedObject = new MigrationDeletedObject();
                        migrationDeletedObject.setCls(dictionaryClass);
                        migrationDeletedObject.setUid(item.getRefUid());
                        objects.add(migrationDeletedObject);
                    }
                    sb = new StringBuilder();
                    ((StringBuilder)sb).append("{parameters: {objects: \"");
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Throwable throwable = null;
                    try (ObjectOutputStream strm = new ObjectOutputStream(baos);){
                        strm.writeObject(objects);
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                    byte[] gzip = GZIPUtil.gzip((byte[])baos.toByteArray());
                    ((StringBuilder)sb).append(new String(Base64.getEncoder().encode(gzip)));
                    ((StringBuilder)sb).append("\"}}");
                    this.remoteCall(deletePath, ((StringBuilder)sb).toString().getBytes());
                }
            }
        }
        List<String> uidList = null;
        try (PhysicalStorageSession primaryUidsSession = primaryPhysicalStorage.createSession(null);){
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < TimeUnit.MINUTES.toMillis(2L)) {
                try {
                    if (primaryUidsSession == null) {
                        primaryUidsSession = primaryPhysicalStorage.createSession(null);
                        this.log.info("session recovered");
                    }
                    uidList = adapter.getUids(part, dictionaryClass, primaryPhysicalStorage, primaryUidsSession);
                    break;
                }
                catch (Exception e) {
                    this.log.error("unable to execute getUids", (Throwable)e);
                    try {
                        if (primaryUidsSession != null) {
                            primaryUidsSession.close();
                        }
                    }
                    catch (Exception objects) {
                        // empty catch block
                    }
                    primaryUidsSession = null;
                    Thread.sleep(TimeUnit.SECONDS.toMillis(30L));
                }
            }
        }
        if (uidList == null) {
            throw new Exception("unable to get uids list");
        }
        List batches = CollectionUtil.split(uidList, (int)this.batchSize);
        for (List batch : batches) {
            ArrayList toSave = new ArrayList();
            for (String uid : batch) {
                try {
                    Iterator dict = adapter.getObject(dictionaryClass, uid, primaryPhysicalStorage);
                    toSave.add(dict);
                }
                catch (Exception exception) {
                    this.log.error(String.format("unable to process %s %s uid = %s", this.getEntityDescription(dictionaryClass, uid, primaryPhysicalStorage), dictionaryClass.getSimpleName(), uid), (Throwable)exception);
                    if (!this.isPostgresStoppedException(primaryPhysicalStorage)) continue;
                    this.stop();
                    return false;
                }
            }
            if (toSave.isEmpty()) continue;
            sb = new StringBuilder();
            int idx = 0;
            ((StringBuilder)sb).append("{parameters: {objects:[");
            for (Object e : toSave) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream strm = new ObjectOutputStream(baos);
                strm.writeObject(e);
                byte[] gzip = GZIPUtil.gzip((byte[])baos.toByteArray());
                if (idx > 0) {
                    ((StringBuilder)sb).append(", ");
                }
                ((StringBuilder)sb).append("\"");
                ((StringBuilder)sb).append(new String(Base64.getEncoder().encode(gzip)));
                ((StringBuilder)sb).append("\"");
                ++idx;
            }
            ((StringBuilder)sb).append("]}}");
            try {
                this.remoteCall(savePath, ((StringBuilder)sb).toString().getBytes());
            }
            catch (Exception e) {
                this.log.error("exception", (Throwable)e);
                throw e;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <D> Object getEntityDescription(Class<D> dictionaryClass, String uid, PhysicalStorage primaryPhysicalStorage) throws Exception {
        try (PhysicalStorageSession session = primaryPhysicalStorage.createSession(null);){
            if (BookingFile.class.isAssignableFrom(dictionaryClass)) {
                SearchQuery query = new SearchQuery();
                query.getPreferredProperties().add(CommonProductIndex.Property.systemNumbers.name());
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)uid));
                List products = primaryPhysicalStorage.getEntityStorage().searchEntity(CommonProductIndex.class, query, session).getData();
                if (products.isEmpty()) {
                    String string = "";
                    return string;
                }
                ArrayList<String> productNumbers = new ArrayList<String>();
                for (CommonProductIndex prod : products) {
                    productNumbers.add(prod.getSystemNumbers().size() == 1 ? (String)prod.getSystemNumbers().iterator().next() : prod.getFirstSystemNumber());
                }
                String string = String.format("booking %s products %s", ((CommonProductIndex)products.get(0)).getSource(), productNumbers);
                return string;
            }
            if (BaseEntity.class.isAssignableFrom(dictionaryClass)) {
                Iterator query = LogicalStorageRegistry.get().getIndexHandlers(dictionaryClass).iterator();
                if (query.hasNext()) {
                    IndexHandler indexHandler = (IndexHandler)query.next();
                    Class cls = indexHandler.getIndexClass();
                    SearchQuery query2 = new SearchQuery();
                    query2.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)uid));
                    List indexes = primaryPhysicalStorage.getEntityStorage().searchEntity(cls, query2, session).getData();
                    String string = indexes.isEmpty() ? "" : ((EntityIndex)indexes.get(0)).getSource().getCaption();
                    return string;
                }
                query = "";
                return query;
            }
            String query = "";
            return query;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPostgresStoppedException(PhysicalStorage primaryStorage) {
        try (HibernateSessionManager.HibernatePhysicalStorageSession session = (HibernateSessionManager.HibernatePhysicalStorageSession)primaryStorage.createSession(null);){
            List list = session.getSession().createQuery("select count(*) from " + DictionaryData.class.getName()).list();
        }
        catch (Exception e1) {
            this.log.error("it seems that postgres is stopped", (Throwable)e1);
            return true;
        }
        return false;
    }

    protected Date getDate(LongRunningTask.EventsCallback callback) throws Exception {
        if (this.secondPass) {
            String value = LogicalStorage.get().getDbPropertiesStorage().getValue("migration.doneTo");
            if (value == null) {
                throw Xeption.forAdmin((String)"\u043f\u0435\u0440\u0432\u044b\u0439 \u043f\u0440\u043e\u0445\u043e\u0434 \u0435\u0449\u0435 \u043d\u0435 \u043e\u043a\u043e\u043d\u0447\u0435\u043d", (Object[])new Object[0]);
            }
            return MigrationLongRunningTask.createDateTimeFormat().parse(value);
        }
        if (this.doneTo != null) {
            return this.doneTo;
        }
        if (this.startDate != null) {
            return MiscUtil.clearTime((Date)this.startDate);
        }
        LinkedBlockingDeque dateList = new LinkedBlockingDeque();
        this.executeForAllEntityTypes(entityType -> {
            PhysicalStorage primaryStorage = LogicalStorageRegistry.get().getStorage(LogicalStorage.get().getPrimaryStorageUid());
            try (PhysicalStorageSession session = primaryStorage.createSession(null);){
                Date typeDate;
                if (BaseDictionary.class.isAssignableFrom((Class<?>)entityType)) {
                    DictionaryPhysicalStorage primaryDictionaryPhysicalStorage = primaryStorage.getDictionaryStorage();
                    List uidList1 = primaryDictionaryPhysicalStorage.getDictionaryUids(entityType, null, null, false, false, SortOrder.ASC, Integer.valueOf(1), session);
                    typeDate = null;
                    if (uidList1.size() >= 1) {
                        PhysicalDictionaryData dictionary1 = primaryDictionaryPhysicalStorage.findDictionaryByUid(entityType, (String)uidList1.get(0), false, session);
                        typeDate = dictionary1 != null ? dictionary1.getModified() : null;
                    }
                } else if (BaseEntity.class.isAssignableFrom((Class<?>)entityType)) {
                    Class clazz = entityType;
                    EntityPhysicalStorage primaryEntityPhysicalStorage = primaryStorage.getEntityStorage();
                    List uidList1 = primaryEntityPhysicalStorage.getEntityUids(clazz, null, null, false, false, SortOrder.ASC, Integer.valueOf(1), session);
                    typeDate = null;
                    if (uidList1.size() >= 1) {
                        PhysicalEntityData entity1 = primaryEntityPhysicalStorage.loadEntity(clazz, (String)uidList1.get(0), null, session);
                        typeDate = entity1 != null ? entity1.getModified() : null;
                    }
                } else {
                    Class clazz = entityType;
                    AssetPhysicalStorage primaryAssetPhysicalStorage = primaryStorage.getAssetStorage();
                    List uidList1 = primaryAssetPhysicalStorage.getAssetUids(clazz, null, null, SortOrder.ASC, Integer.valueOf(1), session);
                    typeDate = null;
                    if (uidList1.size() >= 1) {
                        PhysicalAssetData asset1 = primaryAssetPhysicalStorage.loadAsset(clazz, (String)uidList1.get(0), session);
                        typeDate = asset1.getAsset().getModified();
                    }
                }
                if (typeDate != null) {
                    this.log.debug(String.format("start date for %s is %s", entityType, typeDate));
                    dateList.add(typeDate);
                }
            }
        });
        Date result = null;
        for (Date typeDate : dateList) {
            if (typeDate == null || result != null && !result.after(typeDate)) continue;
            result = typeDate;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeForAllEntityTypes(final LockUtil.RunnableWithParameterAndException<Class<?>, Exception> runnable) throws Exception {
        Collection<Class<?>> entityTypeList = this.getEntityTypeList();
        LinkedBlockingDeque dateList = new LinkedBlockingDeque();
        ExecutorServiceFacade service = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newFixedThreadPool(this.getClass().getName(), this.threadsCount);
        final CountDownLatch countDown = new CountDownLatch(entityTypeList.size());
        final AtomicReference exceptionHolder = new AtomicReference();
        try {
            for (final Class<?> entityType : entityTypeList) {
                service.submit(new Runnable(){

                    @Override
                    public void run() {
                        block8: {
                            if (!MigrationLongRunningTask.this.isToBeStopped()) break block8;
                            countDown.countDown();
                            return;
                        }
                        try {
                            try {
                                runnable.run((Object)entityType);
                            }
                            catch (Throwable t) {
                                try {
                                    MigrationLongRunningTask.this.stop();
                                }
                                catch (Exception e) {
                                    MigrationLongRunningTask.this.log.error("unable to stop task", (Throwable)e);
                                    exceptionHolder.set(e);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            countDown.countDown();
                        }
                    }
                });
            }
            countDown.await();
        }
        finally {
            service.dispose();
        }
        if (exceptionHolder.get() != null) {
            throw (Exception)exceptionHolder.get();
        }
    }

    Collection<Class<?>> getEntityTypeList() throws Exception {
        HashSet result = new HashSet();
        MetaRegistry metaRegistry = MetaRegistry.get();
        for (EntityType value : metaRegistry.getEntities().values()) {
            if (!MetaRegistryHelper.isRoot((EntityType)value) || value.isAbstract()) continue;
            result.add(Class.forName(value.getId()));
        }
        for (EntityType value : metaRegistry.getDictionaries().values()) {
            if (value.isAbstract()) continue;
            result.add(Class.forName(value.getId()));
        }
        HibernatePhysicalStorageRegistry hpsr = null;
        try {
            hpsr = (HibernatePhysicalStorageRegistry)Environment.getPublished(HibernatePhysicalStorageRegistry.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (hpsr != null) {
            for (Class assetClass : hpsr.getAssetDataClasses().keySet()) {
                result.add(assetClass);
            }
        }
        result.remove(ModifiedObjectReference.class);
        result.remove(DeletedObjectReference.class);
        result.remove(BillingTransactionChange.class);
        return result;
    }

    private static DateFormat createDateTimeFormat() {
        return new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS");
    }

    protected List<Part> getPartList(Date configDate, Date date) throws Exception {
        ArrayList<Part> result = new ArrayList<Part>();
        if (configDate == null) {
            return result;
        }
        int hours = 24;
        Calendar current = Calendar.getInstance();
        current.setTime(configDate);
        Calendar next = Calendar.getInstance();
        while (current.getTimeInMillis() < date.getTime()) {
            next.setTimeInMillis(current.getTimeInMillis());
            next.add(10, 24);
            if (next.getTimeInMillis() > date.getTime()) {
                next.setTimeInMillis(date.getTime());
            }
            result.add(new Part(current.getTime(), next.getTime()));
            current.add(10, 24);
        }
        return result;
    }

    private static /* synthetic */ boolean lambda$createEntityObject$1(PhysicalEntityData entityData, PhysicalVersionData v) {
        return v.getVersionNumber() == entityData.getVersionsCount() - 1;
    }

    static class Part {
        private final Date from;
        private final Date to;
        private final AtomicInteger downCount = new AtomicInteger(-1);

        public Part(Date src, Date target) {
            this.from = src;
            this.to = target;
        }

        public Date getFrom() {
            return this.from;
        }

        public Date getTo() {
            return this.to;
        }

        public AtomicInteger getDownCount() {
            return this.downCount;
        }
    }

    static interface MigrationProcessStorageAdapter<D> {
        public List<String> getUids(Part var1, Class<D> var2, PhysicalStorage var3, PhysicalStorageSession var4) throws Exception;

        public Object getObject(Class<D> var1, String var2, PhysicalStorage var3) throws Exception;
    }
}

