/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.rest.migration;

import com.gridnine.xtrip.common.model.assets.SysLogItem;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.db.storage.model.PhysicalAssetData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.migration.IbusMigrationContextKeys;
import com.gridnine.xtrip.server.model.rest.migration.MigrationOperationResponse;
import com.gridnine.xtrip.server.model.rest.migration.MigrationSaveEntityProcessor;
import com.gridnine.xtrip.server.model.rest.migration.MigrationSaveObjectRequest;
import java.util.Date;

public class MigrationSaveAssetProcessor
extends BaseProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageContext ctx) throws Exception {
        MigrationSaveObjectRequest request = (MigrationSaveObjectRequest)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        MigrationOperationResponse result = new MigrationOperationResponse();
        PhysicalStorage primaryStorage = MigrationSaveEntityProcessor.getPrimaryStorage();
        LogicalSession logicalSession = LogicalStorage.get().beginUnitOfWork();
        try {
            for (byte[] data : request.getObjects()) {
                PhysicalAssetData existingAsset;
                UserAccount ua;
                PhysicalAssetData assetData = (PhysicalAssetData)MigrationSaveEntityProcessor.readObject(data);
                if (assetData.getAsset() instanceof UserAccount && ("system".equals((ua = (UserAccount)assetData.getAsset()).getLoginName()) || "admin".equals(ua.getLoginName()) || ua.getLoginName().equals(ctx.getObject((Enum)IbusMigrationContextKeys.LOGIN)))) continue;
                if (assetData.getAsset() instanceof SysLogItem && (ua = (SysLogItem)assetData.getAsset()).getDate() == null) {
                    ua.setDate(new Date());
                }
                if ((existingAsset = primaryStorage.getAssetStorage().loadAsset(assetData.getAsset().getClass(), assetData.getAsset().getUid(), logicalSession.getSession())) != null) {
                    LogicalStorage.get().endUnitOfWork(logicalSession, false);
                    primaryStorage.getAssetStorage().deleteAsset(existingAsset, logicalSession.getSession());
                    LogicalStorage.get().endUnitOfWork(logicalSession, false);
                }
                primaryStorage.getAssetStorage().saveAsset(assetData, null, logicalSession.getSession());
            }
            LogicalStorage.get().endUnitOfWork(logicalSession, true);
        }
        finally {
            LogicalStorage.get().cancelUnitOfWork(logicalSession);
        }
        result.setSuccessfull(true);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

