/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.rest.migration;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalVersionData;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.migration.MigrationEntityBatch;
import com.gridnine.xtrip.server.model.rest.migration.MigrationOperationResponse;
import com.gridnine.xtrip.server.model.rest.migration.MigrationSaveObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class MigrationSaveEntityProcessor
extends BaseProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageContext ctx) throws Exception {
        MigrationSaveObjectRequest request = (MigrationSaveObjectRequest)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        MigrationOperationResponse result = new MigrationOperationResponse();
        PhysicalStorage primaryStorage = MigrationSaveEntityProcessor.getPrimaryStorage();
        LogicalSession ls = LogicalStorage.get().beginUnitOfWork();
        try {
            for (byte[] data : request.getObjects()) {
                MigrationEntityBatch entity = (MigrationEntityBatch)MigrationSaveEntityProcessor.readObject(data);
                if (entity.getEntity().getModified() == null) {
                    entity.getEntity().setModified(new Date());
                }
                if (entity.getEntity().getCreated() == null) {
                    entity.getEntity().setCreated(new Date());
                }
                for (PhysicalVersionData version : entity.getEntity().getVersions()) {
                    if (version.getCreated() == null) {
                        version.setCreated(entity.getEntity().getModified());
                    }
                    if (version.getCreatedBy() == null) {
                        version.setCreatedBy("admin");
                    }
                    if (version.getModified() == null) {
                        version.setModified(entity.getEntity().getModified());
                    }
                    if (version.getModifiedBy() != null) continue;
                    version.setModifiedBy("admin");
                }
                PhysicalEntityData existingEntity = primaryStorage.getEntityStorage().loadEntity(entity.getEntity().getEntityType(), entity.getEntity().getUid(), null, ls.getSession());
                if (existingEntity != null) {
                    LogicalStorage.get().endUnitOfWork(ls, false);
                    primaryStorage.getEntityStorage().deleteEntity(existingEntity, ls.getSession());
                    LinkedHashSet<Class> indexes = new LinkedHashSet<Class>();
                    for (IndexHandler handler : LogicalStorageRegistry.get().getIndexHandlers(entity.getEntity().getEntityType())) {
                        indexes.add(handler.getIndexClass());
                    }
                    for (Class idx : indexes) {
                        primaryStorage.getEntityStorage().deleteIndexes(idx, entity.getEntity().getUid(), primaryStorage.getEntityStorage().getIndexes(idx, entity.getEntity().getUid(), ls.getSession()), ls.getSession());
                    }
                    LogicalStorage.get().endUnitOfWork(ls, false);
                }
                primaryStorage.getEntityStorage().saveEntity(entity.getEntity(), null, ls.getSession());
                for (Map.Entry<String, List<BaseIndexData<BaseEntity, EntityIndex<BaseEntity>>>> entry : entity.getIndexes().entrySet()) {
                    primaryStorage.getEntityStorage().saveIndexes(XHelper.getClass((String)entry.getKey()), Collections.singletonMap(primaryStorage.getEntityStorage(), entry.getValue()), entity.getEntity().getUid(), ls.getSession());
                }
            }
            LogicalStorage.get().endUnitOfWork(ls, true);
        }
        finally {
            LogicalStorage.get().cancelUnitOfWork(ls);
        }
        result.setSuccessfull(true);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    static PhysicalStorage getPrimaryStorage() {
        String primaryStorageUid = LogicalStorage.get().getPrimaryStorageUid();
        return LogicalStorageRegistry.get().getStorage(primaryStorageUid);
    }

    static <T> T readObject(byte[] data) throws Exception {
        try (ObjectInputStream strm = new ObjectInputStream(new ByteArrayInputStream(GZIPUtil.gunzip((byte[])data)));){
            Object object = strm.readObject();
            return (T)object;
        }
    }
}

