/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.rest.migration;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.AuthUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.model.rest.migration.IbusMigrationContextKeys;
import com.gridnine.xtrip.server.web.rest.AuthRestInterceptor;
import com.gridnine.xtrip.server.web.rest.GenericRestInterceptorAdapter;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class XtripMigrationAuthInterceptor
extends GenericRestInterceptorAdapter
implements AuthRestInterceptor {
    private static final String AUTH_HEADER = "MOM_AUTH";

    public void authorize(RestContext context, Map<String, Object> data) {
        String authHeader = context.getRequest().getHeader(AUTH_HEADER);
        String[] tokens = AuthUtil.decryptToken((Serializable)((Object)authHeader));
        String login = tokens[0];
        String password = tokens[1];
        if (StringUtils.isBlank((String)login)) {
            throw Xeption.forEndUser((String)"Login shouldn't be empty!", (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((String)password)) {
            throw Xeption.forEndUser((String)"Password shouldn't be empty!", (Object[])new Object[0]);
        }
        try {
            LogicalStorage.get().authorize(login, password.toCharArray());
        }
        catch (Exception e) {
            context.setStatus(403);
            throw Xeption.forEndUser((String)"Invalid login or password", (Throwable)e, (Object[])new Object[0]);
        }
        data.put(IbusMigrationContextKeys.LOGIN.name(), login);
    }
}

