/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.rest.standard;

import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.BaseType;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.EnumType;
import com.gridnine.xtrip.common.meta.rest.RestEntityType;
import com.gridnine.xtrip.common.meta.rest.RestEnumType;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.rest.DocGenerator;
import com.gridnine.xtrip.common.rest.RestDocType;
import com.gridnine.xtrip.common.rest.RestDocTypeItem;
import com.gridnine.xtrip.common.rest.RestDocsHelper;
import com.gridnine.xtrip.common.rest.l10n.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

public class StandardDocGenerator
implements DocGenerator {
    public DocGenerator.JsonTypeDescriptor getFieldDescriptors(final BaseMetaElement metaElement, final Locale locale) {
        if (metaElement instanceof EnumType || metaElement instanceof RestEnumType) {
            return new RefTypeDescriptor(locale){

                @Override
                protected String getTypeId() {
                    return metaElement.getId();
                }

                public String getTypeName() {
                    return L10n.getWithParams((String)"REST_DOCS_ENUM_REFERENCE_OF_TYPE", (Locale)locale, (Object[])new Object[]{RestDocsHelper.getLink((String)this.getRefTypeId())});
                }

                @Override
                protected String getDocumentation() {
                    return L10n.getWithParams((String)"REST_DOCS_ENUM_REFERENCE", (Locale)locale, (Object[])new Object[]{RestDocsHelper.getLink((String)this.getTypeId())});
                }

                @Override
                protected boolean doAddOriginType() {
                    return true;
                }
            };
        }
        if (metaElement instanceof EntityType) {
            return new RefTypeDescriptor(locale){

                @Override
                protected String getTypeId() {
                    return metaElement.getId();
                }

                public String getTypeName() {
                    return L10n.getWithParams((String)"REST_DOCS_ENTITY_REFERENCE_OF_TYPE", (Locale)locale, (Object[])new Object[]{RestDocsHelper.getLink((String)this.getRefTypeId())});
                }

                @Override
                protected String getDocumentation() {
                    BaseType type2 = RestDocsHelper.getMetaType((String)this.getTypeId());
                    String description = RestDocsHelper.getDescription((BaseMetaElement)type2, (Locale)locale);
                    description = L10n.getWithParams((String)"REST_DOCS_ENTITY_REFERENCE", (Locale)locale, (Object[])new Object[]{description});
                    return description;
                }

                @Override
                protected boolean doAddOriginType() {
                    return false;
                }

                @Override
                protected void collectDocTypeItems(RestDocType docType) {
                    super.collectDocTypeItems(docType);
                    RestDocTypeItem item = new RestDocTypeItem();
                    item.setDeprecated(false);
                    item.setName("accessible");
                    item.setDocumentation(L10n.get((String)"REST_DOCS_ACCESSIBLE", (Locale)locale));
                    item.setTypeName(L10n.get((String)"REST_DOCS_BOOLEAN", (Locale)locale));
                    item.setRequired("1");
                    docType.getItems().add(item);
                }
            };
        }
        if (metaElement instanceof DictionaryType) {
            if (GeoLocation.class.getName().equals(metaElement.getId())) {
                return new GeoLocationRefTypeDescriptor(locale){

                    @Override
                    protected String getTypeId() {
                        return metaElement.getId();
                    }
                };
            }
            if (Aircraft.class.getName().equals(metaElement.getId())) {
                return new AircraftRefTypeDescriptor(locale){

                    @Override
                    protected String getTypeId() {
                        return metaElement.getId();
                    }
                };
            }
            return new RefTypeDescriptor(locale){

                @Override
                protected String getTypeId() {
                    return metaElement.getId();
                }

                @Override
                protected String getUidDocumentation() {
                    return L10n.get((String)"REST_DOCS_DICTIONARY_CODE", (Locale)locale);
                }

                public String getTypeName() {
                    return L10n.getWithParams((String)"REST_DOCS_DICTIONARY_REFERENCE_OF_TYPE", (Locale)locale, (Object[])new Object[]{RestDocsHelper.getLink((String)this.getRefTypeId())});
                }

                @Override
                protected String getDocumentation() {
                    BaseType type2 = RestDocsHelper.getMetaType((String)this.getTypeId());
                    String description = RestDocsHelper.getDescription((BaseMetaElement)type2, (Locale)locale);
                    description = L10n.getWithParams((String)"REST_DOCS_DICTIONARY_REFERENCE", (Locale)locale, (Object[])new Object[]{description});
                    return description;
                }

                @Override
                protected boolean doAddOriginType() {
                    return false;
                }
            };
        }
        if (metaElement instanceof RestEntityType) {
            return new DocGenerator.JsonTypeDescriptor(){

                public String getTypeName() {
                    return null;
                }

                public Collection<RestDocType> getTypes() {
                    ArrayList<RestDocType> result = new ArrayList<RestDocType>();
                    RestDocType docType = RestDocsHelper.getDocType((String)metaElement.getId(), null, (Locale)locale);
                    result.add(docType);
                    return result;
                }
            };
        }
        return null;
    }

    protected static abstract class AircraftRefTypeDescriptor
    implements DocGenerator.JsonTypeDescriptor {
        private Locale locale;

        public AircraftRefTypeDescriptor(Locale locale) {
            this.locale = locale;
        }

        protected abstract String getTypeId();

        protected String getRefTypeId() {
            return this.getTypeId() + "Reference";
        }

        public String getTypeName() {
            return L10n.getWithParams((String)"REST_DOCS_AIRCRAFT_REFERENCE_OF_TYPE", (Locale)this.locale, (Object[])new Object[]{RestDocsHelper.getLink((String)this.getRefTypeId())});
        }

        protected String getDocumentation() {
            String description = L10n.get((String)"REST_DOCS_AIRCRAFT_REFERENCE", (Locale)this.locale);
            return description;
        }

        public Collection<RestDocType> getTypes() {
            ArrayList<RestDocType> result = new ArrayList<RestDocType>();
            RestDocType docType = new RestDocType();
            docType.setDeprecated(false);
            docType.setEnum(false);
            String id = this.getRefTypeId();
            docType.setId(id);
            docType.setName(GenUtil.getSimpleClassName((String)id));
            docType.setId(this.getRefTypeId());
            docType.setDocumentation(this.getDocumentation());
            RestDocTypeItem item = new RestDocTypeItem();
            item.setDeprecated(false);
            item.setName("uid");
            item.setDocumentation(L10n.get((String)"REST_DOCS_DICTIONARY_CODE", (Locale)this.locale));
            item.setTypeName(L10n.get((String)Messages.REST_DOCS_STRING, (Locale)this.locale));
            item.setRequired("1");
            docType.getItems().add(item);
            item = new RestDocTypeItem();
            item.setDeprecated(false);
            item.setName("caption");
            item.setDocumentation(L10n.get((String)"REST_DOCS_TITLE", (Locale)this.locale));
            item.setTypeName(L10n.get((String)Messages.REST_DOCS_STRING, (Locale)this.locale));
            item.setRequired("0/1");
            docType.getItems().add(item);
            result.add(docType);
            return result;
        }
    }

    protected static abstract class GeoLocationRefTypeDescriptor
    implements DocGenerator.JsonTypeDescriptor {
        private Locale locale;

        public GeoLocationRefTypeDescriptor(Locale locale) {
            this.locale = locale;
        }

        protected abstract String getTypeId();

        protected String getRefTypeId() {
            return this.getTypeId() + "Reference";
        }

        public String getTypeName() {
            return L10n.getWithParams((String)"REST_DOCS_GEOLOCATION_REFERENCE_OF_TYPE", (Locale)this.locale, (Object[])new Object[]{RestDocsHelper.getLink((String)this.getRefTypeId())});
        }

        protected String getDocumentation() {
            String description = L10n.get((String)"REST_DOCS_GEOLOCATION_REFERENCE", (Locale)this.locale);
            return description;
        }

        public Collection<RestDocType> getTypes() {
            ArrayList<RestDocType> result = new ArrayList<RestDocType>();
            RestDocType docType = RestDocsHelper.getDocType((String)LocationType.class.getName(), null, (Locale)this.locale);
            if (docType != null) {
                result.add(docType);
            }
            docType = new RestDocType();
            docType.setDeprecated(false);
            docType.setEnum(false);
            String id = this.getRefTypeId();
            docType.setId(id);
            docType.setName(GenUtil.getSimpleClassName((String)id));
            docType.setId(this.getRefTypeId());
            docType.setDocumentation(this.getDocumentation());
            RestDocTypeItem item = new RestDocTypeItem();
            item.setDeprecated(false);
            item.setName("uid");
            item.setDocumentation(L10n.get((String)"REST_DOCS_DICTIONARY_CODE", (Locale)this.locale));
            item.setTypeName(L10n.get((String)Messages.REST_DOCS_STRING, (Locale)this.locale));
            item.setRequired("1");
            docType.getItems().add(item);
            item = new RestDocTypeItem();
            item.setDeprecated(false);
            item.setName("displayCode");
            item.setDocumentation(L10n.get((String)"REST_DOCS_GEOLOCATION_CODE", (Locale)this.locale));
            item.setTypeName(L10n.get((String)Messages.REST_DOCS_STRING, (Locale)this.locale));
            item.setRequired("1");
            docType.getItems().add(item);
            item = new RestDocTypeItem();
            item.setDeprecated(false);
            item.setName("type");
            item.setDocumentation(L10n.get((String)"REST_DOCS_GEOLOCATION_TYPE", (Locale)this.locale));
            item.setTypeName(RestDocsHelper.getPropertyFormat((String)LocationType.class.getName(), (Locale)this.locale));
            item.setRequired("1");
            docType.getItems().add(item);
            item = new RestDocTypeItem();
            item.setDeprecated(false);
            item.setName("caption");
            item.setDocumentation(L10n.get((String)"REST_DOCS_TITLE", (Locale)this.locale));
            item.setTypeName(L10n.get((String)Messages.REST_DOCS_STRING, (Locale)this.locale));
            item.setRequired("0/1");
            docType.getItems().add(item);
            item = new RestDocTypeItem();
            item.setDeprecated(false);
            item.setName("cityName");
            item.setDocumentation(L10n.get((String)"REST_DOCS_GEOLOCATION_CITY", (Locale)this.locale));
            item.setTypeName(L10n.get((String)Messages.REST_DOCS_STRING, (Locale)this.locale));
            item.setRequired("1");
            docType.getItems().add(item);
            item = new RestDocTypeItem();
            item.setDeprecated(false);
            item.setName("cityUid");
            item.setDocumentation(L10n.get((String)"REST_DOCS_GEOLOCATION_CITY_CODE", (Locale)this.locale));
            item.setTypeName(L10n.get((String)Messages.REST_DOCS_STRING, (Locale)this.locale));
            item.setRequired("0/1");
            docType.getItems().add(item);
            item = new RestDocTypeItem();
            item.setDeprecated(false);
            item.setName("countryName");
            item.setDocumentation(L10n.get((String)"REST_DOCS_GEOLOCATION_COUNTRY", (Locale)this.locale));
            item.setTypeName(L10n.get((String)Messages.REST_DOCS_STRING, (Locale)this.locale));
            item.setRequired("1");
            docType.getItems().add(item);
            result.add(docType);
            return result;
        }
    }

    protected static abstract class RefTypeDescriptor
    implements DocGenerator.JsonTypeDescriptor {
        private Locale locale;

        protected abstract String getTypeId();

        protected abstract String getDocumentation();

        protected abstract boolean doAddOriginType();

        protected String getRefTypeId() {
            return this.getTypeId() + "Reference";
        }

        protected String getUidDocumentation() {
            return L10n.get((String)"REST_DOCS_IDENTIFIER", (Locale)this.locale);
        }

        public RefTypeDescriptor(Locale locale) {
            this.locale = locale;
        }

        public Collection<RestDocType> getTypes() {
            RestDocType docType;
            ArrayList<RestDocType> result = new ArrayList<RestDocType>();
            if (this.doAddOriginType() && (docType = RestDocsHelper.getDocType((String)this.getTypeId(), null, (Locale)this.locale)) != null) {
                result.add(docType);
            }
            docType = new RestDocType();
            docType.setDeprecated(false);
            docType.setEnum(false);
            String id = this.getRefTypeId();
            docType.setId(id);
            docType.setName(GenUtil.getSimpleClassName((String)id));
            docType.setId(this.getRefTypeId());
            docType.setDocumentation(this.getDocumentation());
            this.collectDocTypeItems(docType);
            result.add(docType);
            return result;
        }

        protected void collectDocTypeItems(RestDocType docType) {
            RestDocTypeItem item = new RestDocTypeItem();
            item.setDeprecated(false);
            item.setName("uid");
            item.setDocumentation(this.getUidDocumentation());
            item.setTypeName(L10n.get((String)Messages.REST_DOCS_STRING, (Locale)this.locale));
            item.setRequired("1");
            docType.getItems().add(item);
            item = new RestDocTypeItem();
            item.setDeprecated(false);
            item.setName("caption");
            item.setDocumentation(L10n.get((String)"REST_DOCS_TITLE", (Locale)this.locale));
            item.setTypeName(L10n.get((String)Messages.REST_DOCS_STRING, (Locale)this.locale));
            item.setRequired("0/1");
            docType.getItems().add(item);
        }
    }
}

