/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.restriction;

import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.restriction.RestrictionGroup;
import com.gridnine.xtrip.common.restriction.RestrictionGroupType;
import com.gridnine.xtrip.common.restriction.RestrictionValue;
import com.gridnine.xtrip.common.restriction.helper.RestrictionsHelper;
import com.gridnine.xtrip.common.restriction.model.DateCorrection;
import com.gridnine.xtrip.common.restriction.model.DateCorrectionUnit;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourcePropertyConditions;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourcePropertyDynamicValueHandlers;
import com.gridnine.xtrip.common.restriction.util.RestrictionsUtil;
import com.gridnine.xtrip.common.search.PredefinedKeyWords;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.junit.Ignore;
import org.junit.Test;

public class RestrictionsUtilTest
extends ModelTestBase {
    @Ignore
    @Test
    public void testToQueryFromRestrictionGroups() throws Exception {
        Date date = new Date();
        ArrayList<RestrictionGroup> restrictionGroups = new ArrayList<RestrictionGroup>();
        restrictionGroups.clear();
        restrictionGroups.add(this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.EQUALS.getId(), date)));
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().clear();
        query.getCriteria().getCriterions().addAll(RestrictionsUtil.toQueryFromRestrictionGroups(restrictionGroups, ProductIndex.class, Collections.emptyList()));
        this.print("SIMPLE RESTRICTION GROUPS", restrictionGroups, query);
        restrictionGroups.clear();
        restrictionGroups.add(this.createNotRestrictionGroup(this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.EQUALS.getId(), date))));
        query = new SearchQuery();
        query.getCriteria().getCriterions().clear();
        query.getCriteria().getCriterions().addAll(RestrictionsUtil.toQueryFromRestrictionGroups(restrictionGroups, ProductIndex.class, Collections.emptyList()));
        this.print("NOT RESTRICTION GROUPS", restrictionGroups, query);
        restrictionGroups.clear();
        restrictionGroups.add(this.createAndRestrictionGroup(this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.EQUALS.getId(), date))));
        query = new SearchQuery();
        query.getCriteria().getCriterions().clear();
        query.getCriteria().getCriterions().addAll(RestrictionsUtil.toQueryFromRestrictionGroups(restrictionGroups, ProductIndex.class, Collections.emptyList()));
        this.print("AND RESTRICTION GROUPS 1", restrictionGroups, query);
        restrictionGroups.clear();
        restrictionGroups.add(this.createAndRestrictionGroup(this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.sncs.name()), StandardRestrictionResourcePropertyConditions.CONTAINS.getId(), Collections.singletonList("123"))), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.sncs.name()), StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId(), Collections.singletonList("456"))), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.sncs.name()), StandardRestrictionResourcePropertyConditions.BEGINS.getId(), Collections.singletonList("789"))), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.sncs.name()), StandardRestrictionResourcePropertyConditions.NOT_BEGINS.getId(), Collections.singletonList("123"))), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.sncs.name()), StandardRestrictionResourcePropertyConditions.ENDS.getId(), Collections.singletonList("456"))), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.sncs.name()), StandardRestrictionResourcePropertyConditions.NOT_ENDS.getId(), Collections.singletonList("789"))), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.sncs.name()), StandardRestrictionResourcePropertyConditions.EMPTY.getId(), null)), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.sncs.name()), StandardRestrictionResourcePropertyConditions.NOT_EMPTY.getId(), null))));
        query = new SearchQuery();
        query.getCriteria().getCriterions().clear();
        query.getCriteria().getCriterions().addAll(RestrictionsUtil.toQueryFromRestrictionGroups(restrictionGroups, ProductIndex.class, Collections.emptyList()));
        this.print("AND RESTRICTION GROUPS 2", restrictionGroups, query);
        restrictionGroups.clear();
        restrictionGroups.add(this.createAndRestrictionGroup(this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.hasErrors.name()), StandardRestrictionResourcePropertyConditions.YES.getId(), null)), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.hasErrors.name()), StandardRestrictionResourcePropertyConditions.NO.getId(), null)), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.GREATER.getId(), date)), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId(), date)), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.equivalentFare.name()), StandardRestrictionResourcePropertyConditions.LOWER.getId(), BigDecimal.valueOf(100L))), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.equivalentFare.name()), StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId(), BigDecimal.valueOf(200L))), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.WITHIN.getId(), new DateInterval(MiscUtil.addDaysToDate((Date)MiscUtil.clearTime((Date)date), (int)-1), MiscUtil.addDaysToDate((Date)MiscUtil.setDayEndTime((Date)date), (int)1)))), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.equivalentFare.name()), StandardRestrictionResourcePropertyConditions.BEYOND.getId(), new Pair((Object)BigDecimal.valueOf(300L), (Object)BigDecimal.valueOf(400L))))));
        query = new SearchQuery();
        query.getCriteria().getCriterions().clear();
        query.getCriteria().getCriterions().addAll(RestrictionsUtil.toQueryFromRestrictionGroups(restrictionGroups, ProductIndex.class, Collections.emptyList()));
        this.print("AND RESTRICTION GROUPS 3", restrictionGroups, query);
        restrictionGroups.clear();
        restrictionGroups.add(this.createOrRestrictionGroup(this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.NOW.getId(), null)), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.TODAY.getId(), null)), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.YESTERDAY.getId(), null)), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.CURRENT_WEEK_BSP.getId(), null)), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.PREVIOUS_WEEK_BSP.getId(), null)), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.CURRENT_DECADE.getId(), null)), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.PREVIOUS_DECADE.getId(), null)), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.CURRENT_MONTH.getId(), null)), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.PREVIOUS_MONTH.getId(), null)), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.LAST_7_DAYS.getId(), null)), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.LAST_30_DAYS.getId(), null)), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.LAST_6_MONTHS.getId(), null)), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.NULL.getId(), null)), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.NOT_NULL.getId(), null))));
        query = new SearchQuery();
        query.getCriteria().getCriterions().clear();
        query.getCriteria().getCriterions().addAll(RestrictionsUtil.toQueryFromRestrictionGroups(restrictionGroups, ProductIndex.class, Collections.emptyList()));
        this.print("OR RESTRICTION GROUPS 1", restrictionGroups, query);
        restrictionGroups.clear();
        restrictionGroups.add(this.createOrRestrictionGroup(this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.EQUALS.getId(), this.createDynamicValue(StandardRestrictionResourcePropertyDynamicValueHandlers.NOW.getId(), this.createDateCorrection(5, DateCorrectionUnit.DAY)))), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), this.createDynamicValue(StandardRestrictionResourcePropertyDynamicValueHandlers.TODAY.getId(), null))), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.GREATER.getId(), this.createDynamicValue(StandardRestrictionResourcePropertyDynamicValueHandlers.YESTERDAY.getId(), null))), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId(), this.createDynamicValue(StandardRestrictionResourcePropertyDynamicValueHandlers.CURRENT_WEEK_BSP.getId(), null))), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.LOWER.getId(), this.createDynamicValue(StandardRestrictionResourcePropertyDynamicValueHandlers.PREVIOUS_WEEK_BSP.getId(), null))), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId(), this.createDynamicValue(StandardRestrictionResourcePropertyDynamicValueHandlers.CURRENT_DECADE.getId(), null))), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.EQUALS.getId(), this.createDynamicValue(StandardRestrictionResourcePropertyDynamicValueHandlers.PREVIOUS_DECADE.getId(), null))), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), this.createDynamicValue(StandardRestrictionResourcePropertyDynamicValueHandlers.CURRENT_MONTH.getId(), null))), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.GREATER.getId(), this.createDynamicValue(StandardRestrictionResourcePropertyDynamicValueHandlers.PREVIOUS_MONTH.getId(), null))), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId(), this.createDynamicValue(StandardRestrictionResourcePropertyDynamicValueHandlers.LAST_7_DAYS.getId(), null))), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.LOWER.getId(), this.createDynamicValue(StandardRestrictionResourcePropertyDynamicValueHandlers.LAST_30_DAYS.getId(), null))), this.createSimpleRestrictionGroup(this.createRestrictionValue(String.format("%s.%s", ProductIndex.class.getName(), ProductIndex.Property.issueDate.name()), StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId(), this.createDynamicValue(StandardRestrictionResourcePropertyDynamicValueHandlers.LAST_6_MONTHS.getId(), null)))));
        query = new SearchQuery();
        query.getCriteria().getCriterions().clear();
        query.getCriteria().getCriterions().addAll(RestrictionsUtil.toQueryFromRestrictionGroups(restrictionGroups, ProductIndex.class, Collections.emptyList()));
        this.print("OR RESTRICTION GROUPS 2", restrictionGroups, query);
    }

    @Ignore
    @Test
    public void testToRestrictionGroupsFromQuery() throws Exception {
        Date date = new Date();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().clear();
        Collection restrictionGroups = RestrictionsUtil.toRestrictionGroupsFromQuery((Collection)query.getCriteria().getCriterions(), ProductIndex.class, Collections.emptyList());
        this.print("CHECK CRITERIONS", query, restrictionGroups);
        query.getCriteria().getCriterions().clear();
        query.getCriteria().getCriterions().add(SearchCriterion.between((String)ProductIndex.Property.issueDate.name(), (Object)MiscUtil.addDaysToDate((Date)MiscUtil.clearTime((Date)date), (int)-1), (Object)MiscUtil.addDaysToDate((Date)MiscUtil.setDayEndTime((Date)date), (int)1)));
        query.getCriteria().getCriterions().add(SearchCriterion.notbetween((String)ProductIndex.Property.equivalentFare.name(), (Object)BigDecimal.valueOf(100L), (Object)BigDecimal.valueOf(200L)));
        restrictionGroups = RestrictionsUtil.toRestrictionGroupsFromQuery((Collection)query.getCriteria().getCriterions(), ProductIndex.class, Collections.emptyList());
        this.print("BETWEEN / NOT BETWEEN CRITERIONS", query, restrictionGroups);
        query.getCriteria().getCriterions().clear();
        restrictionGroups = RestrictionsUtil.toRestrictionGroupsFromQuery((Collection)query.getCriteria().getCriterions(), ProductIndex.class, Collections.emptyList());
        this.print("IN CRITERIONS", query, restrictionGroups);
        query.getCriteria().getCriterions().clear();
        restrictionGroups = RestrictionsUtil.toRestrictionGroupsFromQuery((Collection)query.getCriteria().getCriterions(), ProductIndex.class, Collections.emptyList());
        this.print("NOT CRITERIONS", query, restrictionGroups);
        query.getCriteria().getCriterions().clear();
        restrictionGroups = RestrictionsUtil.toRestrictionGroupsFromQuery((Collection)query.getCriteria().getCriterions(), ProductIndex.class, Collections.emptyList());
        this.print("AND CRITERIONS", query, restrictionGroups);
        query.getCriteria().getCriterions().clear();
        restrictionGroups = RestrictionsUtil.toRestrictionGroupsFromQuery((Collection)query.getCriteria().getCriterions(), ProductIndex.class, Collections.emptyList());
        this.print("OR CRITERIONS", query, restrictionGroups);
        query.getCriteria().getCriterions().clear();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.hasErrors.name(), (Object)Boolean.TRUE));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.equivalentFare.name(), (Object)BigDecimal.valueOf(1000L)));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.issueDate.name(), (Object)new Date()));
        restrictionGroups = RestrictionsUtil.toRestrictionGroupsFromQuery((Collection)query.getCriteria().getCriterions(), ProductIndex.class, Collections.emptyList());
        this.print("SIMPLE CRITERIONS 1", query, restrictionGroups);
        query.getCriteria().getCriterions().clear();
        query.getCriteria().getCriterions().add(SearchCriterion.gt((String)ProductIndex.Property.equivalentFare.name(), (Object)"100"));
        query.getCriteria().getCriterions().add(SearchCriterion.lt((String)ProductIndex.Property.equivalentFare.name(), (Object)"200"));
        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ProductIndex.Property.equivalentFare.name(), (Object)"300"));
        query.getCriteria().getCriterions().add(SearchCriterion.le((String)ProductIndex.Property.equivalentFare.name(), (Object)"400"));
        restrictionGroups = RestrictionsUtil.toRestrictionGroupsFromQuery((Collection)query.getCriteria().getCriterions(), ProductIndex.class, Collections.emptyList());
        this.print("SIMPLE CRITERIONS 2", query, restrictionGroups);
        query.getCriteria().getCriterions().clear();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)ProductIndex.Property.ticketNumbers.name(), (Object)"123"));
        query.getCriteria().getCriterions().add(SearchCriterion.icontains((String)ProductIndex.Property.ticketNumbers.name(), (String)"234"));
        query.getCriteria().getCriterions().add(SearchCriterion.begins((String)ProductIndex.Property.ticketNumbers.name(), (Object)"345"));
        query.getCriteria().getCriterions().add(SearchCriterion.ends((String)ProductIndex.Property.ticketNumbers.name(), (Object)"456"));
        restrictionGroups = RestrictionsUtil.toRestrictionGroupsFromQuery((Collection)query.getCriteria().getCriterions(), ProductIndex.class, Collections.emptyList());
        this.print("SIMPLE CRITERIONS 3", query, restrictionGroups);
        query.getCriteria().getCriterions().clear();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.issueDate.name(), (Object)PredefinedKeyWords.TODAY));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.issueDate.name(), (Object)PredefinedKeyWords.YESTERDAY));
        query.getCriteria().getCriterions().add(SearchCriterion.gt((String)ProductIndex.Property.issueDate.name(), (Object)PredefinedKeyWords.CURRENT_WEEK_BSP));
        query.getCriteria().getCriterions().add(SearchCriterion.lt((String)ProductIndex.Property.issueDate.name(), (Object)PredefinedKeyWords.LAST_WEEK_BSP));
        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ProductIndex.Property.issueDate.name(), (Object)PredefinedKeyWords.CURRENT_DECADE));
        query.getCriteria().getCriterions().add(SearchCriterion.le((String)ProductIndex.Property.issueDate.name(), (Object)PredefinedKeyWords.LAST_DECADE));
        restrictionGroups = RestrictionsUtil.toRestrictionGroupsFromQuery((Collection)query.getCriteria().getCriterions(), ProductIndex.class, Collections.emptyList());
        this.print("KEYWORD CRITERIONS 1", query, restrictionGroups);
        query.getCriteria().getCriterions().clear();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.issueDate.name(), (Object)PredefinedKeyWords.CURRENT_MONTH));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.issueDate.name(), (Object)PredefinedKeyWords.LAST_MONTH));
        query.getCriteria().getCriterions().add(SearchCriterion.gt((String)ProductIndex.Property.issueDate.name(), (Object)PredefinedKeyWords.LAST_7_DAYS));
        query.getCriteria().getCriterions().add(SearchCriterion.lt((String)ProductIndex.Property.issueDate.name(), (Object)PredefinedKeyWords.LAST_30_DAYS));
        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ProductIndex.Property.issueDate.name(), (Object)PredefinedKeyWords.LAST_HALF_YEAR));
        restrictionGroups = RestrictionsUtil.toRestrictionGroupsFromQuery((Collection)query.getCriteria().getCriterions(), ProductIndex.class, Collections.emptyList());
        this.print("KEYWORD CRITERIONS 2", query, restrictionGroups);
    }

    private DateCorrection createDateCorrection(int value, DateCorrectionUnit unit) {
        DateCorrection dateCorrection = new DateCorrection();
        dateCorrection.setValue(value);
        dateCorrection.setUnit(unit);
        return dateCorrection;
    }

    private RestrictionValue createRestrictionValue(String propertyId, String conditionId, Object value) {
        RestrictionValue restrictionValue = new RestrictionValue();
        restrictionValue.setPropertyId(propertyId);
        restrictionValue.setConditionId(conditionId);
        restrictionValue.setValue(value);
        return restrictionValue;
    }

    private RestrictionValue.DynamicValue createDynamicValue(String handlerId, Object parameters) {
        RestrictionValue.DynamicValue dynamicValue = new RestrictionValue.DynamicValue();
        dynamicValue.setHandlerId(handlerId);
        dynamicValue.setParameters(parameters);
        return dynamicValue;
    }

    private RestrictionGroup createSimpleRestrictionGroup(RestrictionValue restrictionValue) {
        RestrictionGroup restrictionGroup = new RestrictionGroup();
        restrictionGroup.setType(RestrictionGroupType.SIMPLE);
        restrictionGroup.setValue((Object)restrictionValue);
        return restrictionGroup;
    }

    private RestrictionGroup createNotRestrictionGroup(RestrictionGroup ... restrictionGroups) {
        RestrictionGroup restrictionGroup = new RestrictionGroup();
        restrictionGroup.setType(RestrictionGroupType.NOT);
        restrictionGroup.setValue(Arrays.asList(restrictionGroups));
        return restrictionGroup;
    }

    private RestrictionGroup createAndRestrictionGroup(RestrictionGroup ... restrictionGroups) {
        RestrictionGroup restrictionGroup = new RestrictionGroup();
        restrictionGroup.setType(RestrictionGroupType.AND);
        restrictionGroup.setValue(Arrays.asList(restrictionGroups));
        return restrictionGroup;
    }

    private RestrictionGroup createOrRestrictionGroup(RestrictionGroup ... restrictionGroups) {
        RestrictionGroup restrictionGroup = new RestrictionGroup();
        restrictionGroup.setType(RestrictionGroupType.OR);
        restrictionGroup.setValue(Arrays.asList(restrictionGroups));
        return restrictionGroup;
    }

    private void print(String title, SearchQuery query, Collection<RestrictionGroup> restrictionGroups) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DebugUtil.decorate((String)query.toString(), null, (String)"criterions", (boolean)true));
        for (RestrictionGroup restrictionGroup : restrictionGroups) {
            stringBuilder.append(DebugUtil.decorate((String)RestrictionsHelper.toString((RestrictionGroup)restrictionGroup), null, (String)"restrictions", (boolean)true));
        }
        System.out.println(DebugUtil.decorate((String)stringBuilder.toString(), null, (String)title, (boolean)true));
    }

    private void print(String title, Collection<RestrictionGroup> restrictionGroups, SearchQuery query) {
        StringBuilder stringBuilder = new StringBuilder();
        for (RestrictionGroup restrictionGroup : restrictionGroups) {
            stringBuilder.append(DebugUtil.decorate((String)RestrictionsHelper.toString((RestrictionGroup)restrictionGroup), null, (String)"restrictions", (boolean)true));
        }
        stringBuilder.append(DebugUtil.decorate((String)query.toString(), null, (String)"criterions", (boolean)true));
        System.out.println(DebugUtil.decorate((String)stringBuilder.toString(), null, (String)title, (boolean)true));
    }
}

