/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.rpc;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.DeskEntry;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.booking.BookingCommissionCalculationResult;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductSearchIndex;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBookingHelper;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsResult;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsSettings;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageDeleteParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSaveParameters;
import com.gridnine.xtrip.common.model.export.BaseExportSettings;
import com.gridnine.xtrip.common.model.export.BasicExportSettingsIndex;
import com.gridnine.xtrip.common.model.helpers.BillingTransactionHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.PasswordPolicyHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.model.profile.SabreProfilesSynchronizationResult;
import com.gridnine.xtrip.common.model.profile.SabreProfilesValidationResult;
import com.gridnine.xtrip.common.model.profile.TrashBinItem;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.rpc.ModelService;
import com.gridnine.xtrip.common.model.rules.Parameter;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclEntityResources;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.standard.helpers.SystemSettingsHelper;
import com.gridnine.xtrip.common.model.system.ArchivedEntity;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.SecurityAccountPolicySettings;
import com.gridnine.xtrip.common.model.system.SecuritySettings;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionGroupResources;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.AuthUtil;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.model.export.ExportHandler;
import com.gridnine.xtrip.server.model.export.RootEntityExportHandler;
import com.gridnine.xtrip.server.model.export.service.ExportDocumentsHelper;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.model.helpers.TrashBinHelper;
import com.gridnine.xtrip.server.model.rules.RulesHelper;
import com.gridnine.xtrip.server.model.synchronization.sabrepassive.SabrePassiveSegmentsHelper;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationHelper;
import com.gridnine.xtrip.server.restriction.helper.RestrictionsHelper;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.time.DateUtils;

public class ModelServiceImpl
extends BaseSecureServiceImpl
implements ModelService {
    public Collection<Message> applyContracts(ServiceInvocationContext ctx, Collection<EntityReference<BookingFile>> bookingFiles) throws ServiceException {
        DebugUtil.setThreadName((String)"ModelServiceImpl-applyContracts-multiple-ref");
        try {
            this.checkContext(ctx);
            ArrayList<Message> result = new ArrayList<Message>();
            try {
                this.log.debug("applyContracts() BEGIN");
                for (EntityReference<BookingFile> ref : bookingFiles) {
                    this.applyContracts(ref, result);
                }
                this.log.debug("applyContracts() END");
                ArrayList<Message> arrayList = result;
                return arrayList;
            }
            catch (Throwable t) {
                this.log.error("failed applying contracts to products", t);
                throw new ServiceException("failed applying contracts to products", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public BookingCommissionCalculationResult applyContracts(ServiceInvocationContext ctx, BookingFile bookingFile, Map<Parameter, Object> params) throws ServiceException {
        DebugUtil.setThreadName((String)"ModelServiceImpl-applyContracts-single-entity-with-params");
        try {
            this.checkContext(ctx);
            try {
                BookingCommissionCalculationResult result = new BookingCommissionCalculationResult();
                this.log.debug("applyContracts() BEGIN");
                EntityContainer ctr = EntityContainer.create((BaseEntity)bookingFile);
                DebugInfo debugInfo = new DebugInfo();
                RulesHelper.applyRules((EntityContainer<BookingFile>)ctr, true, true, result.getMessages(), params, debugInfo);
                result.setDebugInfo(debugInfo);
                this.log.debug("applyContracts() END");
                result.setBooking(bookingFile);
                BookingCommissionCalculationResult bookingCommissionCalculationResult = result;
                return bookingCommissionCalculationResult;
            }
            catch (Throwable t) {
                this.log.error("failed applying contracts to products", t);
                throw new ServiceException("failed applying contracts to products", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyContracts(EntityReference<BookingFile> ref, List<Message> result) {
        DebugUtil.setThreadName((String)"ModelServiceImpl-applyContracts-single-ref");
        try {
            EntityContainer ctr;
            block9: {
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)DeskEntry.Property.targetType.name(), (Object)ref.getType().getName()));
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)DeskEntry.Property.targetUid.name(), (Object)ref.getUid()));
                LogicalStorage sm = LogicalStorage.get();
                for (DeskEntry deskEntry : AssetsStorage.get().search(DeskEntry.class, query).getData()) {
                    if (deskEntry.getLockedSince() == null || sm.getUser().equals(deskEntry.getOwner())) continue;
                    SysLogHelper.audit(ref, "entity-modification", SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ModelServiceImpl_ruleNotApplyEdit, (Object[])new Object[]{deskEntry.getOwner()}));
                    result.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)String.format("booking file %s locked by %s", ref, deskEntry.getOwner()), (Object[])new Object[0]));
                }
                ctr = EntityStorage.get().resolve(ref);
                if (ctr != null) break block9;
                result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)("failed loading booking file " + ref), (Object[])new Object[0]));
                return;
            }
            try {
                Map proxies = RestrictionsHelper.buildProxies((EntityContainer)ctr, (String)ModelRestrictionEntityResources.ENTITY_BOOKING_FILE.getId());
                String user = UserData.get().getCurrentUser();
                boolean granted = AclHelper.isGranted((RestrictionResourceProxy)((RestrictionResourceProxy)proxies.get(((BookingFile)ctr.getEntity()).getUid())), (String)ModelAclEntityResources.ENTITY_BOOKING_FILE.getId(), (String)user, (String)StandardRestrictionResourceOperations.EDIT.getId(), Collections.emptyList());
                if (!granted) {
                    SysLogHelper.audit(ref, "entity-modification", SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ModelServiceImpl_rulesDontApplyBecause, (Object[])new Object[0]));
                    result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ModelServiceImpl_noRightToChange, (Object[])new Object[]{ctr.toReference()}));
                }
                RulesHelper.applyRules((EntityContainer<BookingFile>)ctr, true, false, result);
                ctr.getVersionInfo().setDataSource("apply-contracts-tool");
                EntityStorage.get().save(ctr, true);
                SysLogHelper.audit(ref, "entity-modification", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.ModelServiceImpl_ruleSuccessApply, (Object[])new Object[0]));
            }
            catch (Throwable t) {
                this.log.error("failed processing booking file " + ref, t);
                SysLogHelper.audit(ref, "entity-modification", MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ModelServiceImpl_applyRuleError, (Throwable)t, (Object[])new Object[0]));
                result.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)("failed processing booking file " + ref), (Throwable)t, (Object[])new Object[0]));
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable updateUserAccount(ServiceInvocationContext ctx, UserAccount account, char[] oldPassword, char[] newPassword, boolean createNewAccount) throws ServiceException {
        DebugUtil.setThreadName((String)"ModelServiceImpl-updateUserAccount");
        try {
            this.checkContext(ctx);
            Serializable serializable = this.fillUserAccountParams(account, oldPassword, newPassword, createNewAccount);
            return serializable;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public Serializable fillUserAccountParams(UserAccount account, char[] oldPassword, char[] newPassword, boolean createNewAccount) throws ServiceException {
        boolean granted;
        this.log.debug("updateUserAccount() BEGIN account=" + account.getLoginName());
        String loginName = account.getLoginName();
        if (TextUtil.isBlank((String)loginName)) {
            throw new ServiceException(L10nResourcesManager.getStr((String)Messages.ModelServiceImpl_loginNotDefine, (Object[])new Object[0]));
        }
        if (createNewAccount) {
            String fullName = account.getFullName();
            if (TextUtil.isBlank((String)fullName)) {
                throw new ServiceException(L10nResourcesManager.getStr((String)Messages.ModelServiceImpl_accountNameNotDefine, (Object[])new Object[0]));
            }
            if (!loginName.matches("[0-9a-zA-Z\\_\\-\\~\\!\\#\\$\\%\\^\\&\\*\\(\\)\\{\\}\\[\\]\\+\\=\\;\\:\\<\\>\\?\\/\\@\\.\\,\\|]+")) {
                throw new ServiceException(L10nResourcesManager.getStr((String)Messages.ModelServiceImpl_accountNameCanContain, (Object[])new Object[0]), true);
            }
            this.setPassword(account, newPassword);
            this.saveAccount(account);
            this.log.debug("updateUserAccount() END account=" + account.getLoginName());
            return null;
        }
        UserAccount oldAccount = this.findAccount(loginName);
        if (oldAccount == null) {
            throw new ServiceException(L10nResourcesManager.getStr((String)Messages.ModelServiceImpl_cantFindAccount, (Object[])new Object[]{loginName}));
        }
        try {
            granted = AclHelper.isGranted(null, (String)StandardRestrictionGroupResources.GROUP_USER_ACCOUNTS.getId(), (String)UserData.get().getCurrentUser(), (String)StandardRestrictionResourceOperations.USE.getId(), Collections.emptyList());
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        if (!granted && !this.checkPassword(oldAccount, oldPassword)) {
            throw new ServiceException(L10nResourcesManager.getStr((String)Messages.ModelServiceImpl_wrongPassword, (Object[])new Object[0]));
        }
        oldAccount.setActive(account.isActive());
        oldAccount.setFullName(account.getFullName());
        oldAccount.setNotes(account.getNotes());
        oldAccount.setEmail(account.getEmail());
        oldAccount.setLastLoginDate(account.getLastLoginDate());
        oldAccount.setExpiryDate(account.getExpiryDate());
        Serializable result = null;
        if (newPassword != null) {
            result = this.setPassword(oldAccount, newPassword);
        }
        this.saveAccount(oldAccount);
        this.log.debug("updateUserAccount() END account=" + account.getLoginName());
        return LogicalStorage.get().getUser().equals(loginName) ? result : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable updatePassword(ServiceInvocationContext ctx, String login, char[] password) throws ServiceException {
        DebugUtil.setThreadName((String)"ModelServiceImpl-updatePassword");
        try {
            this.checkContext(ctx);
            this.log.debug("updateUserAccount() BEGIN account=" + login);
            UserAccount account = this.findAccount(login);
            if (account == null) {
                throw new ServiceException(L10nResourcesManager.getStr((String)Messages.ModelServiceImpl_cantFindAccount, (Object[])new Object[]{login}));
            }
            Serializable authToken = this.setPassword(account, password);
            this.saveAccount(account);
            this.log.debug("updatePassword END account=" + login);
            Serializable serializable = LogicalStorage.get().getUser().equals(login) ? authToken : null;
            return serializable;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPasswordExpired(ServiceInvocationContext ctx, String login) throws ServiceException {
        DebugUtil.setThreadName((String)"ModelServiceImpl-isPasswordExpired");
        try {
            this.checkContext(ctx);
            this.log.debug("isPasswordExpired() BEGIN account=" + login);
            SecurityAccountPolicySettings settings = Optional.ofNullable(SystemSettingsHelper.getSecuritySettings()).map(SecuritySettings::getAccountPolicySettings).orElse(null);
            if (settings != null && settings.isEnabled() && settings.getPasswordExpireDays() > 0) {
                UserAccount account = this.findAccount(login);
                if (account == null) {
                    throw new ServiceException(L10nResourcesManager.getStr((String)Messages.ModelServiceImpl_cantFindAccount, (Object[])new Object[]{login}));
                }
                if (account.getPasswordLastUpdateDate() == null || MiscUtil.addDaysToDate((Date)account.getPasswordLastUpdateDate(), (int)settings.getPasswordExpireDays()).before(new Date())) {
                    this.log.debug("isPasswordExpired() END account=" + login);
                    boolean bl = true;
                    return bl;
                }
            }
            this.log.debug("isPasswordExpired() END account=" + login);
            boolean bl = false;
            return bl;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPasswordMatchPrevious(ServiceInvocationContext ctx, String login, char[] password) throws ServiceException {
        DebugUtil.setThreadName((String)"ModelServiceImpl-isPasswordMatchPrevious");
        try {
            this.checkContext(ctx);
            this.log.debug("isPasswordMatchPrevious() BEGIN account=" + login);
            SecurityAccountPolicySettings settings = Optional.ofNullable(SystemSettingsHelper.getSecuritySettings()).map(SecuritySettings::getAccountPolicySettings).orElse(null);
            if (settings != null && settings.isEnabled() && settings.getPasswordHistoryLength() > 0) {
                byte[] digest;
                UserAccount account = this.findAccount(login);
                if (account == null) {
                    throw new ServiceException(L10nResourcesManager.getStr((String)Messages.ModelServiceImpl_cantFindAccount, (Object[])new Object[]{login}));
                }
                try {
                    digest = UserAccount.digest((char[])password);
                }
                catch (Exception e) {
                    throw new ServiceException("failed to caclulate digest");
                }
                for (int i = Math.max(0, account.getPasswordDigests().size() - settings.getPasswordHistoryLength()); i < account.getPasswordDigests().size(); ++i) {
                    byte[] previousDigest = (byte[])account.getPasswordDigests().get(i);
                    if (!Arrays.equals(digest, previousDigest)) continue;
                    this.log.debug("isPasswordMatchPrevious() END account=" + login);
                    boolean bl = true;
                    return bl;
                }
            }
            this.log.debug("isPasswordMatchPrevious() END account=" + login);
            boolean bl = false;
            return bl;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserAccount findUserAccount(ServiceInvocationContext ctx, String loginName) throws ServiceException {
        DebugUtil.setThreadName((String)"ModelServiceImpl-findUserAccount");
        try {
            this.checkContext(ctx);
            this.log.debug("findUserAccount() BEGIN account=" + loginName);
            UserAccount result = this.findAccount(loginName);
            this.log.debug("findUserAccount() END account=" + loginName);
            UserAccount userAccount = result;
            return userAccount;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUserAccount(ServiceInvocationContext ctx, String loginName) throws ServiceException {
        DebugUtil.setThreadName((String)"ModelServiceImpl-deleteUserAccount");
        try {
            this.checkContext(ctx);
            this.log.debug("deleteUserAccount() BEGIN account=" + loginName);
            UserAccount oldAccount = this.findAccount(loginName);
            if (oldAccount == null) {
                throw new ServiceException(L10nResourcesManager.getStr((String)Messages.ModelServiceImpl_cantFindAccount, (Object[])new Object[]{loginName}));
            }
            try {
                AssetsStorage.get().delete((BaseAsset)oldAccount);
            }
            catch (Throwable t) {
                this.log.error(String.format("failed deleting account %s", loginName), t);
                throw new ServiceException(L10nResourcesManager.getStr((String)Messages.ModelServiceImpl_cantDeleteAccount, (Object[])new Object[]{loginName}), t);
            }
            this.log.debug("deleteUserAccount() END account=" + loginName);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private UserAccount findAccount(String loginName) throws ServiceException {
        try {
            return com.gridnine.xtrip.server.model.helpers.ProfileDao.findAccount(loginName);
        }
        catch (Exception e) {
            this.log.error(String.format("failed searching account %s", loginName), (Throwable)e);
            throw new ServiceException(L10nResourcesManager.getStr((String)Messages.ModelServiceImpl_cantSearchAccount, (Object[])new Object[]{loginName}), (Throwable)e);
        }
    }

    private Serializable setPassword(UserAccount account, char[] pswd) throws ServiceException {
        if (pswd == null || pswd.length == 0) {
            throw new ServiceException(L10nResourcesManager.getStr((String)Messages.ModelServiceImpl_passwordShouldBeNotEmpty, (Object[])new Object[0]), true);
        }
        if (!PasswordPolicyHelper.checkPassword((char[])pswd) || PasswordPolicyHelper.hasInvalidCharacters((String)new String(pswd))) {
            throw new ServiceException(L10nResourcesManager.getStr((String)Messages.ModelServiceImpl_passwordShouldBeValid, (Object[])new Object[0]), true);
        }
        try {
            account.setPassword(pswd);
            return AuthUtil.buildAuthToken((String)account.getLoginName(), (char[])pswd);
        }
        catch (Throwable t) {
            this.log.error(String.format("failed setting password for account %s", account.getLoginName()), t);
            throw new ServiceException(L10nResourcesManager.getStr((String)Messages.ModelServiceImpl_cantChangePassword, (Object[])new Object[]{account.getLoginName()}), t);
        }
    }

    private boolean checkPassword(UserAccount oldAccount, char[] oldPassword) throws ServiceException {
        try {
            return oldAccount.isPasswordValid(oldPassword);
        }
        catch (Exception e) {
            this.log.error(String.format("failed checking password for account %s", oldAccount.getLoginName()), (Throwable)e);
            throw new ServiceException(L10nResourcesManager.getStr((String)Messages.ModelServiceImpl_cantCheckPassword, (Object[])new Object[]{oldAccount.getLoginName()}), (Throwable)e);
        }
    }

    private void saveAccount(UserAccount account) throws ServiceException {
        try {
            AssetsStorage.get().save((BaseAsset)account);
        }
        catch (Throwable t) {
            this.log.error(String.format("failed saving account %s", account.getLoginName()), t);
            throw new ServiceException(L10nResourcesManager.getStr((String)Messages.ModelServiceImpl_cantSaveAccount, (Object[])new Object[]{account.getLoginName()}), t);
        }
    }

    protected SearchCriterion composeIssueDateCriterion(Product product) {
        return SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductSearchIndex.Property.issueDate.name(), (Object)DateUtils.addYears((Date)product.getIssueDate(), (int)-1)), SearchCriterion.le((String)ProductSearchIndex.Property.issueDate.name(), (Object)DateUtils.addYears((Date)product.getIssueDate(), (int)1))});
    }

    protected SearchCriterion composeUniqueTicketSearchCriteria(Product product) {
        return SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductSearchIndex.Property.productCategory.name(), (Object)ProductCategory.AIR), SearchCriterion.eq((String)ProductSearchIndex.Property.status.name(), (Object)product.getStatus()), SearchCriterion.eq((String)ProductSearchIndex.Property.blankType.name(), (Object)product.getBlankType())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)ProductSearchIndex.Property.productCategory.name(), (Object)ProductCategory.AIR), SearchCriterion.eq((String)ProductSearchIndex.Property.status.name(), (Object)product.getStatus()), SearchCriterion.eq((String)ProductSearchIndex.Property.blankType.name(), (Object)product.getBlankType())})});
    }

    public BigDecimal getBalance(ServiceInvocationContext ctx, ContractType contractType, EntityReference<? extends BaseProfile> clientReference, EntityReference<? extends BaseProfile> agencyReference, EntityReference<? extends BaseProfile> agentReference, BillingTransactionCategory category, BillingTransactionStatus status, Date startDate, Date endDate) throws ServiceException {
        return this.getBalance(ctx, contractType, clientReference, agencyReference, agentReference, category, status, startDate, endDate, false);
    }

    public BigDecimal getBalance(ServiceInvocationContext ctx, ContractType contractType, EntityReference<? extends BaseProfile> clientReference, EntityReference<? extends BaseProfile> agencyReference, EntityReference<? extends BaseProfile> agentReference, BillingTransactionCategory category, BillingTransactionStatus status, Date startDate, Date endDate, boolean forceOldFinModule) throws ServiceException {
        DebugUtil.setThreadName((String)"ModelServiceImpl-getBalance");
        try {
            this.checkContext(ctx);
            BigDecimal bigDecimal = BillingTransactionHelper.calculateBillingTransactionsSum((ContractType)contractType, clientReference, agencyReference, agentReference, (BillingTransactionCategory)category, (BillingTransactionStatus)status, (String)DictHelper.getLocalCurrency(), (Date)startDate, (Date)endDate, (boolean)false, (boolean)false, (boolean)forceOldFinModule);
            return bigDecimal;
        }
        catch (Throwable t) {
            this.log.error("failed calculating balance", t);
            throw new ServiceException("failed calculating balance", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getPhysicalStorageList(ServiceInvocationContext ctx) throws ServiceException {
        DebugUtil.setThreadName((String)"ModelServiceImpl-getPhysicalStorageList");
        try {
            this.checkContext(ctx);
            HashMap<String, String> result = new HashMap<String, String>();
            try {
                LogicalStorageRegistry storageRegistry = LogicalStorageRegistry.get();
                for (PhysicalStorage storage : storageRegistry.getStorageList()) {
                    result.put(storage.getUid(), storage.getUid());
                }
            }
            catch (Throwable t) {
                this.log.error("Failed to get storage list: " + t.getMessage(), t);
            }
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends BaseEntity> void createExportDocument(ServiceInvocationContext ctx, EntityReference<T> ref) throws ServiceException {
        DebugUtil.setThreadName((String)"ModelServiceImpl-createExportDocument");
        try {
            this.checkContext(ctx);
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicExportSettingsIndex.Property.createDocuments.name(), (Object)true));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicExportSettingsIndex.Property.sendData.name(), (Object)true));
            SearchResult res = EntityStorage.get().search(BasicExportSettingsIndex.class, query);
            if (res.getTotalCount() == 0) {
                this.log.error("reexporting: no settings with createDocuments and sendData equals true");
                throw new ServiceException("no settings with createDocuments and sendData equals true");
            }
            String title = ref.getUid();
            try {
                EntityContainer ctr = EntityStorage.get().resolve(ref);
                if (ctr != null) {
                    title = ctr.getEntity().toString();
                    this.log.debug("reexporting " + title);
                    ExportDocumentsHelper.createExportDocuments(ctr, false, null);
                } else {
                    this.log.debug(String.format("failed to resolve EntityReference %s during reexporting ", title));
                }
            }
            catch (Throwable t) {
                this.log.error(String.format("failed create export document for %s: %s", title, t.getMessage()), t);
                throw new ServiceException("failed create export document", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> unArchiveBooking(ServiceInvocationContext ctx, EntityReference<ArchivedBooking> bookingRef) throws ServiceException {
        DebugUtil.setThreadName((String)"ModelServiceImpl-unarchivingBooking");
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            EntityContainer bookingCtr;
            block11: {
                this.checkContext(ctx);
                this.log.debug("unarchiving booking " + bookingRef);
                bookingCtr = EntityStorage.get().resolve(bookingRef);
                if (!BookingFile.class.equals((Object)bookingCtr.getEntityType())) break block11;
                messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0437\u0430\u043a\u0430\u0437 {0} \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0430\u0440\u0445\u0438\u0432\u043d\u044b\u043c", (Object[])new Object[]{bookingRef}));
                ArrayList<Message> arrayList = messages;
                return arrayList;
            }
            try {
                LogicalSession ls = LogicalStorage.get().beginUnitOfWork();
                try {
                    ArrayList<ArchivedEntity> entities = new ArrayList<ArchivedEntity>();
                    entities.add(((ArchivedBooking)bookingCtr.getEntity()).getBooking());
                    entities.addAll(((ArchivedBooking)bookingCtr.getEntity()).getAdditionalEntities());
                    for (ArchivedEntity item : entities) {
                        EntityContainer ettCtr = ArchivedBookingHelper.getLastVersion((ArchivedEntity)item);
                        ettCtr.getVersionInfo().setDataSource("unarchive-booking");
                        EntityStorage.get().save(ettCtr, true, (EntityStorageSaveParameters)new EntityStorageSaveParameters().ignoreInterceptors(true));
                        AssetsStorage.get().save((Iterable)item.getAssets(), true);
                    }
                    EntityStorage.get().delete(bookingCtr, (EntityStorageDeleteParameters)new EntityStorageDeleteParameters().ignoreInterceptors(true));
                    LogicalStorage.get().endUnitOfWork(ls, true);
                }
                finally {
                    LogicalStorage.get().cancelUnitOfWork(ls);
                }
            }
            catch (Throwable t) {
                this.log.error(String.format("failed unarchiving booking %s", bookingRef), t);
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0437\u0430\u0440\u0445\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043a\u0430\u0437 {0}", (Throwable)t, (Object[])new Object[]{bookingRef}));
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return messages;
    }

    public SabreProfilesSynchronizationResult sendTravelerToSabreProfiles(ServiceInvocationContext ctx, EntityReference<Person> perRef, EntityReference<Organization> orgRef, List<EntityReference<Organization>> orgRefs, SabreProfilesPccSettings pccSettings, SabreProfilesValidationResult validationResult) throws ServiceException {
        DebugUtil.setThreadName((String)"ModelServiceImpl-sendTravelerToSabreProfiles");
        try {
            this.checkContext(ctx);
            try {
                this.log.debug("sending Person profile to Sabre Profiles: " + perRef);
                EntityContainer perCont = EntityStorage.get().resolve(perRef);
                SabreProfilesSynchronizationResult sabreProfilesSynchronizationResult = SabreProfilesSynchronizationHelper.sendPerson((EntityContainer<Person>)perCont, orgRef, orgRefs, pccSettings, validationResult);
                return sabreProfilesSynchronizationResult;
            }
            catch (Throwable t) {
                this.log.error(String.format("failed sending person profile to Sabre Profiles for %s", perRef), t);
                throw new ServiceException(t.getMessage(), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public <E extends BaseEntity> EntityContainer<E> restore(ServiceInvocationContext ctx, EntityReference<TrashBinItem> ref) throws ServiceException {
        DebugUtil.setThreadName((String)"EntityServiceImpl-restore");
        try {
            this.log.debug("restoring " + ref);
            this.checkContext(ctx);
            try {
                this.log.debug("restore() BEGIN: " + ref);
                EntityContainer ctr = EntityStorage.get().resolve(ref);
                EntityContainer result = TrashBinHelper.restoreTrashBinItem((EntityContainer<TrashBinItem>)ctr);
                this.log.debug("restore() END: " + ref);
                EntityContainer entityContainer = result;
                return entityContainer;
            }
            catch (Throwable t) {
                this.log.error("failed restoring " + ref, t);
                throw new ServiceException("failed restoring " + ref, t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public EntityContainer<BookingFile> unarchiveBookingFile(ServiceInvocationContext ctx, EntityReference<ArchivedBooking> archivedBookingRef) throws ServiceException {
        DebugUtil.setThreadName((String)"ModelServiceImpl-unarchiveBookingFile");
        try {
            this.log.debug("unarchiving " + archivedBookingRef);
            this.checkContext(ctx);
            try {
                this.log.debug("unarchiveBookingFile() BEGIN: " + archivedBookingRef);
                EntityContainer<BookingFile> result = BookingDao.unarchiveBookingFile(archivedBookingRef);
                this.log.debug("unarchiveBookingFile() END: " + archivedBookingRef);
                EntityContainer<BookingFile> entityContainer = result;
                return entityContainer;
            }
            catch (Throwable t) {
                this.log.error("failed unarchiving " + archivedBookingRef, t);
                throw new ServiceException("failed unarchiving " + archivedBookingRef, t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private String getLockerUser(EntityReference<? extends BaseEntity> entityReference) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)DeskEntry.Property.targetUid.name(), (Object)entityReference.getUid()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)DeskEntry.Property.targetType.name(), (Object)entityReference.getType().getName()));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)DeskEntry.Property.lockedSince.name(), null));
        List deskEntries = AssetsStorage.get().search(DeskEntry.class, query).getData();
        LogicalStorage sm = LogicalStorage.get();
        for (DeskEntry deskEntry : deskEntries) {
            if (sm.getUser().equals(deskEntry.getOwner()) || deskEntry.getOwner() == null) continue;
            return deskEntry.getOwner();
        }
        return null;
    }

    public Collection<EntityReference<BaseExportSettings>> getExportSettings(ServiceInvocationContext ctx, Class<?> type) throws ServiceException {
        return (Collection)this.doIt(ctx, () -> {
            ArrayList<EntityReference> result = new ArrayList<EntityReference>();
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicExportSettingsIndex.Property.createDocuments.name(), (Object)Boolean.TRUE));
            for (BasicExportSettingsIndex idx : EntityStorage.get().search(BasicExportSettingsIndex.class, query).getData()) {
                RootEntityExportHandler rootEntityExportHandler;
                EntityReference settingsRef = idx.getSource();
                EntityContainer settingsCtr = EntityStorage.get().resolve(settingsRef);
                if (settingsCtr == null) {
                    this.log.warn("unable to load " + idx.getSource());
                    continue;
                }
                ExportHandler handler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findExportHandlerBySettings(settingsRef.getType());
                if (handler == null) {
                    this.log.warn("unable to find export handler for " + settingsRef);
                    continue;
                }
                if (!(handler instanceof RootEntityExportHandler) || !(rootEntityExportHandler = (RootEntityExportHandler)handler).getEntityType().equals(type)) continue;
                result.add(settingsCtr.toReference());
            }
            return result;
        });
    }

    public SabrePassiveSegmentsResult createPassiveSegmentsInSabre(ServiceInvocationContext ctx, EntityReference<BookingFile> bfRef, SabrePassiveSegmentsSettings settings, List<Message> msgs) throws ServiceException {
        DebugUtil.setThreadName((String)"ModelServiceImpl-createSabrePassiveSegments");
        try {
            this.checkContext(ctx);
            try {
                this.log.debug("creating passive segments in Sabre for booking file: " + (bfRef != null ? bfRef.getCaption() : ""));
                SabrePassiveSegmentsResult sabrePassiveSegmentsResult = SabrePassiveSegmentsHelper.createPassiveSegments(bfRef, settings, msgs);
                return sabrePassiveSegmentsResult;
            }
            catch (Throwable t) {
                this.log.error(String.format("failed creating passive segments for booking file %s", bfRef != null ? bfRef.getCaption() : ""), t);
                throw new ServiceException(t.getMessage(), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTechnicalProviderContractCustomer(ServiceInvocationContext ctx) throws ServiceException {
        DebugUtil.setThreadName((String)"ModelServiceImpl-updateTechnicalProviderContractCustomer");
        try {
            this.checkContext(ctx);
            try {
                EntityReference technicalProviderContractRef = ProfileHelper.findTechnicalProviderContract();
                EntityContainer technicalProviderContractCtr = EntityStorage.get().resolve(technicalProviderContractRef);
                if (technicalProviderContractCtr != null) {
                    Contract technicalProviderContract = (Contract)technicalProviderContractCtr.getEntity();
                    technicalProviderContract.setCustomer(ProfileDao.findAllAgenciesProfile());
                    technicalProviderContractCtr.getVersionInfo().setDataSource("update-customer");
                    EntityStorage.get().save(technicalProviderContractCtr, true);
                }
            }
            catch (Throwable t) {
                this.log.error("Failed to update customer in technical provider contract", t);
                throw new ServiceException(t.getMessage(), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }
}

