/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.rpc;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.assets.LongRunningTaskInfo;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.rpc.TaskService;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.server.model.tasks.LongRunningTasksManager;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.io.Serializable;
import java.util.Date;

public class TaskServiceImpl
extends BaseSecureServiceImpl
implements TaskService {
    public LongRunningTaskInfo addTask(ServiceInvocationContext ctx, String taskClassName, Date startDate, String instance, Serializable configuration) throws ServiceException {
        DebugUtil.setThreadName((String)"TaskServiceImpl-addTask");
        try {
            this.checkContext(ctx);
            try {
                this.log.debug("addTask() BEGIN taskClassName=" + taskClassName);
                LongRunningTaskInfo result = ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).addTask(Class.forName(taskClassName), startDate, instance, configuration);
                this.log.debug("addTask() END taskClassName=" + taskClassName);
                LongRunningTaskInfo longRunningTaskInfo = result;
                return longRunningTaskInfo;
            }
            catch (Throwable t) {
                this.log.error("failed adding task, taskClassName=" + taskClassName);
                throw new ServiceException(LocaleManager.get().getL10nResourceManager().getMessage(Messages.TaskServiceImpl_cantCreateTask, new Object[0]), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public LongRunningTaskInfo addTask(ServiceInvocationContext ctx, String taskClassName, Date startDate, String configuration) throws ServiceException {
        DebugUtil.setThreadName((String)"TaskServiceImpl-addTask-string");
        try {
            this.checkContext(ctx);
            try {
                this.log.debug("addTask() BEGIN taskClassName=" + taskClassName);
                LongRunningTaskInfo result = ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).addTask(Class.forName(taskClassName), startDate, configuration);
                this.log.debug("addTask() END taskClassName=" + taskClassName);
                LongRunningTaskInfo longRunningTaskInfo = result;
                return longRunningTaskInfo;
            }
            catch (Throwable t) {
                this.log.error("failed adding task, taskClassName=" + taskClassName);
                throw new ServiceException(LocaleManager.get().getL10nResourceManager().getMessage(Messages.TaskServiceImpl_cantCreateTask, new Object[0]), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeTask(ServiceInvocationContext ctx, String taskUid) throws ServiceException {
        DebugUtil.setThreadName((String)"TaskServiceImpl-resumeTask");
        try {
            this.checkContext(ctx);
            try {
                this.log.debug("resumeTask() BEGIN taskUid=" + taskUid);
                ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).resumeTask(taskUid);
                this.log.debug("resumeTask() END taskUid=" + taskUid);
            }
            catch (Throwable t) {
                this.log.error("failed resuming task, taskUid=" + taskUid);
                throw new ServiceException(LocaleManager.get().getL10nResourceManager().getMessage(Messages.TaskServiceImpl_cantRenewTask, new Object[0]), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTask(ServiceInvocationContext ctx, String taskUid) throws ServiceException {
        DebugUtil.setThreadName((String)"TaskServiceImpl-stopTask");
        try {
            this.checkContext(ctx);
            try {
                this.log.debug("stopTask() BEGIN taskUid=" + taskUid);
                ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).stopTask(taskUid);
                this.log.debug("stopTask() END taskUid=" + taskUid);
            }
            catch (Throwable t) {
                this.log.error("failed stopping task, taskUid=" + taskUid);
                throw new ServiceException(LocaleManager.get().getL10nResourceManager().getMessage(Messages.TaskServiceImpl_cantStapTask, new Object[0]), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTask(ServiceInvocationContext ctx, String taskUid) throws ServiceException {
        DebugUtil.setThreadName((String)"TaskServiceImpl-deleteTask");
        try {
            this.checkContext(ctx);
            try {
                this.log.debug("deleteTask() BEGIN taskUid=" + taskUid);
                ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).deleteTask(taskUid);
                this.log.debug("deleteTask() END taskUid=" + taskUid);
            }
            catch (Throwable t) {
                this.log.error("failed deleting task, taskUid=" + taskUid);
                throw new ServiceException(LocaleManager.get().getL10nResourceManager().getMessage(Messages.TaskServiceImpl_cantDeleteTask, new Object[0]), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }
}

