/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.rules;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AppliedRule;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.rules.Parameter;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.rules.RulesCache;
import com.gridnine.xtrip.server.model.rules.BookingCommissionsCalculator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class RulesHelper {
    public static void applyRules(EntityContainer<BookingFile> bookingCtr, boolean forced, boolean simulate, List<Message> messages) throws Exception {
        ((BookingCommissionsCalculator)Environment.getPublished(BookingCommissionsCalculator.class)).applyRules(bookingCtr, forced, simulate, messages, new HashMap<Parameter, Object>(), null);
    }

    public static void applyRules(EntityContainer<BookingFile> bookingCtr, boolean forced, boolean simulate, List<Message> messages, Map<Parameter, Object> params, DebugInfo debugInfo) throws Exception {
        ((BookingCommissionsCalculator)Environment.getPublished(BookingCommissionsCalculator.class)).applyRules(bookingCtr, forced, simulate, messages, params, debugInfo);
    }

    public static void applyRules(EntityContainer<BookingFile> bookingCtr, Map<BaseProduct, RulesCache<?>> rulesCacheMap, boolean forced, boolean simulate, List<Message> messages, boolean calcAppliedRulesToBooking) throws Exception {
        ((BookingCommissionsCalculator)Environment.getPublished(BookingCommissionsCalculator.class)).applyRules(bookingCtr, rulesCacheMap, forced, simulate, messages, new HashMap<Parameter, Object>(), null, calcAppliedRulesToBooking);
    }

    @Deprecated
    public static ValidationMessage createValidationMessage(String key, String details, Object ... parameters) {
        return RulesHelper.createValidationMessage(ValidationMessageSeverity.MESSAGE, key, details, parameters);
    }

    @Deprecated
    public static ValidationMessage createValidationWarningMessage(String key, String details, Object ... parameters) {
        return RulesHelper.createValidationMessage(ValidationMessageSeverity.WARNING, key, details, parameters);
    }

    @Deprecated
    public static ValidationMessage createValidationErrorMessage(String key, String details, Object ... parameters) {
        return RulesHelper.createValidationMessage(ValidationMessageSeverity.ERROR, key, details, parameters);
    }

    @Deprecated
    public static ValidationMessage createValidationMessage(ValidationMessageSeverity severity, String key, String details, Object ... parameters) {
        ValidationMessage validationMessage = new ValidationMessage();
        validationMessage.setSeverity(severity);
        validationMessage.setCategory(ValidationMessageCategory.RULES);
        validationMessage.setMessage(L10nResourcesManager.createL10nMessage((String)key, (Object[])parameters));
        validationMessage.setDetails(details);
        return validationMessage;
    }

    public static void deleteLostAppliedRules(EntityContainer<BookingFile> bookingContainer) {
        BookingFile bookingFile = (BookingFile)bookingContainer.getEntity();
        Iterator iterator = ((BookingFile)bookingContainer.getEntity()).getAppliedRules().iterator();
        while (iterator.hasNext()) {
            AppliedRule appliedRule = (AppliedRule)iterator.next();
            boolean found = false;
            block1: for (Reservation reservation : bookingFile.getReservations()) {
                for (BaseProduct baseProduct : reservation.getProducts()) {
                    if (!appliedRule.getProductUid().equals(baseProduct.getUid())) continue;
                    found = true;
                    break block1;
                }
            }
            if (found) continue;
            iterator.remove();
        }
    }

    public static List<AppliedRule> getProductRules(BookingFile bookingFile, String productUid) {
        if (TextUtil.isBlank((String)productUid)) {
            return Collections.emptyList();
        }
        return bookingFile.getAppliedRules().stream().filter(Objects::nonNull).filter(rule -> productUid.equals(rule.getProductUid())).collect(Collectors.toList());
    }

    public static <P, A> List<RuleSettings> getAppliedRuleSettings(RuleProxy<P, A> proxy, RuleSet ruleset) {
        ArrayList<RuleSettings> result = new ArrayList<RuleSettings>();
        for (String rsUid : proxy.getAppliedRules()) {
            for (RuleSettings rs : ruleset.getRules()) {
                if (!rsUid.equals(rs.getUid())) continue;
                result.add(rs);
            }
        }
        return result;
    }

    public static void applyRules(EntityContainer<BookingFile> bookingFileContainer) throws Exception {
        RulesHelper.applyRules(bookingFileContainer, false, false, new ArrayList<Message>());
    }

    public static <P extends BaseProduct> PaymentType getSellFeeFopType(P refund, EntityReference<ContractRelationDescription> relationDescription) {
        ProductHandler handler = GeneralProductHelper.getHandler(refund);
        if (handler.getPreviousProduct(refund) == null) {
            return null;
        }
        List relations = handler.getUnmodifiableContractRelations(handler.getPreviousProduct(refund));
        GeneralProductContractRelationData contractRelation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation((List)relations, relationDescription);
        if (contractRelation == null) {
            return null;
        }
        for (GeneralProductFop fop : contractRelation.getFops()) {
            if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) continue;
            return fop.getType();
        }
        return null;
    }
}

