/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.rules;

import com.gridnine.xtrip.common.Publisher;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescriptionIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.cache.EntityCacheListener;
import com.gridnine.xtrip.common.model.entity.cache.EntityCacheManager;
import com.gridnine.xtrip.common.model.rules.standard.UniversalProductRuleEnvironment;
import com.gridnine.xtrip.common.model.rules.standard.nomenclatures.UniversalProductNomenclatureRulesEnvironment;
import com.gridnine.xtrip.common.search.SearchQuery;
import java.util.ArrayList;

public class ServerUniversalProductRulesEnvironmentPublisher
implements Publisher {
    public void publish() throws Exception {
        ArrayList<EntityReference> descriptionsRefs = new ArrayList<EntityReference>();
        ArrayList<EntityContainer> descriptionsCtrs = new ArrayList<EntityContainer>();
        for (UniversalProductDescriptionIndex idx : EntityStorage.get().search(UniversalProductDescriptionIndex.class, new SearchQuery()).getData()) {
            descriptionsRefs.add(idx.getSource());
            descriptionsCtrs.add(EntityStorage.get().resolve(idx.getSource()));
        }
        UniversalProductRuleEnvironment environment = new UniversalProductRuleEnvironment();
        environment.initializeEnvironment(descriptionsRefs);
        EntityCacheManager.get().registerCacheListener((EntityCacheListener)new UniversalProductRuleEnvironment.UniversalProductDescriptionEntityCacheListener(environment));
        UniversalProductNomenclatureRulesEnvironment nomenclatureEnvironment = new UniversalProductNomenclatureRulesEnvironment();
        nomenclatureEnvironment.initializeEnvironment(descriptionsCtrs);
        EntityCacheManager.get().registerCacheListener((EntityCacheListener)new UniversalProductNomenclatureRulesEnvironment.UniversalProductDescriptionNomenclatureEntityCacheListener(nomenclatureEnvironment));
    }
}

