/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.rules;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.rules.Parameter;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.ibus.IntegrationBusRegistry;
import com.gridnine.xtrip.server.model.handlers.RulesHandler;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.rules.RulesCache;
import com.gridnine.xtrip.server.model.handlers.rules.ShipmentsDateRulesHelper;
import com.gridnine.xtrip.server.model.rules.BookingCommissionsCalculator;
import com.gridnine.xtrip.server.model.rules.RulesHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StandardBookingCommissionsCalculator
implements BookingCommissionsCalculator {
    @Override
    public void applyRules(EntityContainer<BookingFile> bookingFileContainer, Map<BaseProduct, RulesCache<?>> rulesCacheMap, boolean forced, boolean simulate, List<Message> messages, Map<Parameter, Object> params, DebugInfo debugHandler, boolean calcAppliedRulesToBooking) throws Exception {
        RulesHelper.deleteLostAppliedRules(bookingFileContainer);
        Map<BaseProduct, Boolean> contractRulesAppliedInfo = ((BookingFile)bookingFileContainer.getEntity()).getReservations().stream().flatMap(item -> item.getProducts().stream()).collect(Collectors.toMap(item -> item, item -> ProductHandler.of((BaseProduct)item).isContractRulesApplied(item)));
        for (RulesHandler handler : ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).getAllRulesHandlers()) {
            handler.applyRules(bookingFileContainer, rulesCacheMap, forced, simulate, messages, params, debugHandler, calcAppliedRulesToBooking);
        }
        ShipmentsDateRulesHelper.applyRules(bookingFileContainer, contractRulesAppliedInfo, forced, simulate, messages);
        String routeId = "booking:apply-rules-post-actions";
        if (!Environment.isTest() || ((IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class)).getNode(routeId) != null) {
            HashMap<String, Object> ctx = new HashMap<String, Object>();
            ctx.put(IBusBookingContextKeys.BOOKING_FILE_CONTAINER.name(), bookingFileContainer);
            ctx.put(IBusBookingContextKeys.APPLIED_CONTRACT_INFO.name(), contractRulesAppliedInfo);
            ctx.put(IBusBookingContextKeys.FORCED_RULES_APPLICATION.name(), forced);
            IntegrationBusFacade.get().processRouteSync(routeId, ctx);
        }
    }

    public void dispose() {
    }
}

