/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.rules;

import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.rules.RulesOptimizationHandler;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;

public class StandardRulesOptimizationHandler
implements RulesOptimizationHandler {
    private static final Comparator<RuleRestriction> COMPARATOR = (rr1, rr2) -> MiscUtil.compare((Comparable)Double.valueOf(rr1.getProperty().getRank()), (Comparable)Double.valueOf(rr2.getProperty().getRank()));

    @Override
    public void optimize(RuleSettings ruleSettings) {
        StandardRulesOptimizationHandler.optimizeFareBasisMatchesPattern(ruleSettings);
        ruleSettings.getRestrictions().sort(COMPARATOR);
    }

    private static void optimizeFareBasisMatchesPattern(RuleSettings ruleSettings) {
        for (int i = 0; i < ruleSettings.getRestrictions().size(); ++i) {
            RuleRestriction rr = (RuleRestriction)ruleSettings.getRestrictions().get(i);
            Set patterns = RulesHelper.toStringCollection((Object)rr.getValue()).stream().map(String::trim).collect(Collectors.toSet());
            HashSet original = new HashSet(patterns);
            boolean modified = false;
            for (String pattern : new HashSet(patterns)) {
                String pattern1;
                Iterator iter1;
                if (RulesHelper.isIncludePattern((String)pattern)) {
                    iter1 = patterns.iterator();
                    while (iter1.hasNext()) {
                        pattern1 = (String)iter1.next();
                        if (pattern1.equals(pattern) || !pattern1.contains(pattern.substring(1, pattern.length() - 1))) continue;
                        iter1.remove();
                        modified = true;
                    }
                    continue;
                }
                if (RulesHelper.isBeginsWithPattern((String)pattern)) {
                    iter1 = patterns.iterator();
                    while (iter1.hasNext()) {
                        pattern1 = (String)iter1.next();
                        if (pattern1.equals(pattern) || !pattern1.startsWith(pattern.substring(0, pattern.length() - 1))) continue;
                        iter1.remove();
                        modified = true;
                    }
                    continue;
                }
                if (!RulesHelper.isEndsWithPattern((String)pattern)) continue;
                iter1 = patterns.iterator();
                while (iter1.hasNext()) {
                    pattern1 = (String)iter1.next();
                    if (pattern1.equals(pattern) || !pattern1.endsWith(pattern.substring(1))) continue;
                    iter1.remove();
                    modified = true;
                }
            }
            if (patterns.stream().allMatch(s -> s.indexOf(63) < 0)) {
                if (patterns.stream().allMatch(RulesHelper::isEqualsPattern)) {
                    rr.setCondition((RuleCondition)Conditions.EQUALS);
                    if (!modified) continue;
                    rr.setValue((Object)patterns.stream().sorted().collect(Collectors.joining(",")));
                    continue;
                }
                if (patterns.stream().allMatch(RulesHelper::isIncludePattern)) {
                    rr.setCondition((RuleCondition)Conditions.INCLUDE);
                    rr.setValue((Object)patterns.stream().map(s -> s.substring(1, s.length() - 1)).sorted().collect(Collectors.joining(",")));
                    continue;
                }
                if (patterns.stream().allMatch(RulesHelper::isBeginsWithPattern)) {
                    rr.setCondition((RuleCondition)Conditions.BEGINS_WITH);
                    rr.setValue((Object)patterns.stream().map(s -> s.substring(0, s.length() - 1)).sorted().collect(Collectors.joining(",")));
                    continue;
                }
                if (patterns.stream().allMatch(RulesHelper::isEndsWithPattern)) {
                    rr.setCondition((RuleCondition)Conditions.ENDS_WITH);
                    rr.setValue((Object)patterns.stream().map(s -> s.substring(1)).sorted().collect(Collectors.joining(",")));
                    continue;
                }
            }
            if (!modified) continue;
            rr.setValue((Object)patterns.stream().sorted().collect(Collectors.joining(",")));
        }
    }
}

