/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.security.acl;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorInfo;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationSystemInfo;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclBookingFileResourceProperties;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclEntityResources;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclOrganizationResourceProperties;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclProductResourceProperties;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclReservationResourceProperties;
import com.gridnine.xtrip.common.security.acl.entry.AclEntry;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.security.acl.helper.StandardAclPermissionsHelper;
import com.gridnine.xtrip.common.security.acl.principal.AclGroup;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.security.acl.resource.AclPropertyRestrictionGroupType;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceOperationPermission;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProxy;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourceOperations;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourcePropertyConditions;
import com.gridnine.xtrip.common.security.acl.rule.AclAction;
import com.gridnine.xtrip.common.security.acl.rule.AclPropertyRestriction;
import com.gridnine.xtrip.common.security.acl.rule.AclPropertyRestrictionGroup;
import com.gridnine.xtrip.common.security.acl.rule.AclRule;
import com.gridnine.xtrip.common.security.acl.util.AclUtil;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import java.util.Arrays;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AclPermissionTest
extends ModelTestBase {
    private static final String user01Id = "user01";
    private static final String user02Id = "user02";
    private static final String user03Id = "user03";
    private static final String groupGuestId = "guests";
    private static final String groupUsersId = "users";
    private static final String groupAdminsId = "admins";
    private static final String groupAgentsId = "agents";
    private static final String BOOKING_FILE_UID = "booking_file_id";
    private static final String RESERVATION_UID = "reservation_id";
    private static final String PRODUCT_UID = "product_id";
    private static final String ORGANIZATION_UID = "organization_id";
    private static final String PERSON_UID = "person_id";
    private static final String BOOKING_FILE_NUMBER_01 = "booking_file_number_01";
    private static final String BOOKING_FILE_NUMBER_02 = "booking_file_number_02";
    private static final EntityReference<Organization> BOOKING_FILE_AGENCY_REFERENCE_01 = new EntityReference("booking_file_agency_01", Organization.class, "Booking File Agency 01");
    private static final EntityReference<Organization> BOOKING_FILE_AGENCY_REFERENCE_02 = new EntityReference("booking_file_agency_02", Organization.class, "Booking File Agency 02");
    private static final EntityReference<Organization> BOOKING_FILE_CLIENT_REFERENCE_01 = new EntityReference("booking_file_client_01", Organization.class, "Booking File Client 01");
    private static final EntityReference<Organization> BOOKING_FILE_CLIENT_REFERENCE_02 = new EntityReference("booking_file_client_02", Organization.class, "Booking File Client 02");
    private static final EntityReference<Organization> BOOKING_FILE_CLIENT_REFERENCE_03 = new EntityReference("booking_file_client_03", Organization.class, "Booking File Client 03");
    private static final String RESERVATION_RECORD_LOCATOR = "ABCDEF";
    private static final ProductStatus PRODUCT_STATUS_01 = ProductStatus.SELL;
    private static final ProductStatus PRODUCT_STATUS_02 = ProductStatus.REFUND;
    private static final ProductStatus PRODUCT_STATUS_03 = ProductStatus.VOID;
    private static final EntityReference<Organization> PRODUCT_BLANK_OWNER_REFERENCE_01 = new EntityReference("product_blank_owner_01", Organization.class, "Product Blank Owner 01");
    private static final EntityReference<Organization> PRODUCT_BLANK_OWNER_REFERENCE_02 = new EntityReference("product_blank_owner_02", Organization.class, "Product Blank Owner 02");
    private static final EntityReference<Organization> PRODUCT_BLANK_OWNER_REFERENCE_03 = new EntityReference("product_blank_owner_03", Organization.class, "Product Blank Owner 03");
    private static final OrganizationType ORGANIZATION_TYPE = OrganizationType.AGENCY;
    private static final PersonType PERSON_TYPE = PersonType.PASSENGER;

    @Test
    public void testPermissionUserSimple() throws Exception {
        BookingFile bookingFile = new BookingFile();
        bookingFile.setUid(BOOKING_FILE_UID);
        bookingFile.setNumber(BOOKING_FILE_NUMBER_01);
        bookingFile.setCustomerProfile(BOOKING_FILE_CLIENT_REFERENCE_01);
        Map proxies = AclHelper.buildProxies((Object)bookingFile, (String)ModelAclEntityResources.ENTITY_BOOKING_FILE.getId());
        AclResourceProxy bookingFileProxy = (AclResourceProxy)proxies.get(BOOKING_FILE_UID);
        Assert.assertEquals((Object)AclResourceOperationPermission.GRANT, (Object)StandardAclPermissionsHelper.getPermission((AclResourceProxy)bookingFileProxy, (String)ModelAclEntityResources.ENTITY_BOOKING_FILE.getId(), (String)user01Id, (String)StandardAclResourceOperations.VIEW.getId()));
        Assert.assertEquals((Object)AclResourceOperationPermission.DENY, (Object)StandardAclPermissionsHelper.getPermission((AclResourceProxy)bookingFileProxy, (String)ModelAclEntityResources.ENTITY_BOOKING_FILE.getId(), (String)user01Id, (String)StandardAclResourceOperations.EDIT.getId()));
        bookingFile.setNumber(BOOKING_FILE_NUMBER_02);
        bookingFile.setCustomerProfile(BOOKING_FILE_CLIENT_REFERENCE_02);
        proxies = AclHelper.buildProxies((Object)bookingFile, (String)ModelAclEntityResources.ENTITY_BOOKING_FILE.getId());
        bookingFileProxy = (AclResourceProxy)proxies.get(BOOKING_FILE_UID);
        Assert.assertEquals(null, (Object)StandardAclPermissionsHelper.getPermission((AclResourceProxy)bookingFileProxy, (String)ModelAclEntityResources.ENTITY_BOOKING_FILE.getId(), (String)user01Id, (String)StandardAclResourceOperations.VIEW.getId()));
        Assert.assertEquals(null, (Object)StandardAclPermissionsHelper.getPermission((AclResourceProxy)bookingFileProxy, (String)ModelAclEntityResources.ENTITY_BOOKING_FILE.getId(), (String)user01Id, (String)StandardAclResourceOperations.EDIT.getId()));
    }

    @Test
    public void testPermissionUserMultiGroup() throws Exception {
        BookingFile bookingFile = new BookingFile();
        bookingFile.setUid(BOOKING_FILE_UID);
        Reservation reservation = new Reservation();
        reservation.setUid(RESERVATION_UID);
        reservation.setBookingFile(bookingFile);
        bookingFile.getReservations().add(reservation);
        Product product01 = new Product();
        product01.setUid(PRODUCT_UID);
        product01.setProductCategory(ProductCategory.AIR);
        product01.setReservation(reservation);
        reservation.getProducts().add(product01);
        bookingFile.setAgency(BOOKING_FILE_AGENCY_REFERENCE_01);
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.SABRE, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)RESERVATION_RECORD_LOCATOR);
        ((RecordLocatorInfo)((ReservationSystemInfo)reservation.getGdsNameInfo().getSystemInfos().get(0)).getRecordLocators().get(0)).setDisplay(true);
        reservation.getGdsNameInfo().setRulesGdsName(GdsName.SABRE);
        product01.setStatus(PRODUCT_STATUS_02);
        product01.setBlankOwnerRef(PRODUCT_BLANK_OWNER_REFERENCE_01);
        Map proxies = AclHelper.buildProxies((Object)bookingFile, (String)ModelAclEntityResources.ENTITY_BOOKING_FILE.getId());
        AclResourceProxy productProxy = (AclResourceProxy)proxies.get(PRODUCT_UID);
        Assert.assertEquals((Object)AclResourceOperationPermission.GRANT, (Object)StandardAclPermissionsHelper.getPermission((AclResourceProxy)productProxy, (String)ModelAclEntityResources.ENTITY_PRODUCT.getId(), (String)user02Id, (String)StandardAclResourceOperations.VIEW.getId()));
        Assert.assertEquals((Object)AclResourceOperationPermission.GRANT, (Object)StandardAclPermissionsHelper.getPermission((AclResourceProxy)productProxy, (String)ModelAclEntityResources.ENTITY_PRODUCT.getId(), (String)user02Id, (String)StandardAclResourceOperations.EDIT.getId()));
        bookingFile.setAgency(BOOKING_FILE_AGENCY_REFERENCE_02);
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.SABRE, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)RESERVATION_RECORD_LOCATOR);
        ((RecordLocatorInfo)((ReservationSystemInfo)reservation.getGdsNameInfo().getSystemInfos().get(0)).getRecordLocators().get(0)).setDisplay(true);
        reservation.getGdsNameInfo().setRulesGdsName(GdsName.SABRE);
        product01.setStatus(PRODUCT_STATUS_03);
        product01.setBlankOwnerRef(PRODUCT_BLANK_OWNER_REFERENCE_02);
        proxies = AclHelper.buildProxies((Object)bookingFile, (String)ModelAclEntityResources.ENTITY_BOOKING_FILE.getId());
        productProxy = (AclResourceProxy)proxies.get(PRODUCT_UID);
        Assert.assertEquals(null, (Object)StandardAclPermissionsHelper.getPermission((AclResourceProxy)productProxy, (String)ModelAclEntityResources.ENTITY_PRODUCT.getId(), (String)user02Id, (String)StandardAclResourceOperations.VIEW.getId()));
        Assert.assertEquals(null, (Object)StandardAclPermissionsHelper.getPermission((AclResourceProxy)productProxy, (String)ModelAclEntityResources.ENTITY_PRODUCT.getId(), (String)user02Id, (String)StandardAclResourceOperations.EDIT.getId()));
    }

    @Test
    public void testPermissionUserEmptyAndNotEmptyRestrictions() throws Exception {
        Organization organization = new Organization();
        organization.setUid(ORGANIZATION_UID);
        organization.getTypes().add(ORGANIZATION_TYPE);
        Map proxies = AclHelper.buildProxies((Object)organization, (String)ModelAclEntityResources.ENTITY_ORGANIZATION.getId());
        AclResourceProxy organizationProxy = (AclResourceProxy)proxies.get(ORGANIZATION_UID);
        Assert.assertEquals((Object)AclResourceOperationPermission.DENY, (Object)StandardAclPermissionsHelper.getPermission((AclResourceProxy)organizationProxy, (String)ModelAclEntityResources.ENTITY_ORGANIZATION.getId(), (String)user03Id, (String)StandardAclResourceOperations.CREATE.getId()));
        Assert.assertEquals(null, (Object)StandardAclPermissionsHelper.getPermission(null, (String)ModelAclEntityResources.ENTITY_ORGANIZATION.getId(), (String)user03Id, (String)StandardAclResourceOperations.CREATE.getId()));
        Person person = new Person();
        person.setUid(PERSON_UID);
        person.getTypes().add(PERSON_TYPE);
        proxies = AclHelper.buildProxies((Object)person, (String)ModelAclEntityResources.ENTITY_PERSON.getId());
        AclResourceProxy personProxy = (AclResourceProxy)proxies.get(PERSON_UID);
        Assert.assertEquals((Object)AclResourceOperationPermission.GRANT, (Object)StandardAclPermissionsHelper.getPermission((AclResourceProxy)personProxy, (String)ModelAclEntityResources.ENTITY_PERSON.getId(), (String)user03Id, (String)StandardAclResourceOperations.CREATE.getId()));
        Assert.assertEquals((Object)AclResourceOperationPermission.GRANT, (Object)StandardAclPermissionsHelper.getPermission(null, (String)ModelAclEntityResources.ENTITY_PERSON.getId(), (String)user03Id, (String)StandardAclResourceOperations.CREATE.getId()));
    }

    @Before
    public void createAcl() {
        this.createAclPrincipals();
        this.createAclEntries();
        System.out.println("= RESOURCES TREE ========================");
        System.out.println(AclUtil.toResourcesTreeString((boolean)false));
        System.out.println("= PRINCIPALS TREE =======================");
        System.out.println(AclUtil.toPrincipalsTreeString());
    }

    private void createAclPrincipals() {
        AclUser user01 = new AclUser();
        user01.setId(user01Id);
        user01.setName("User01");
        user01.getGroupIds().add(groupGuestId);
        AclUser user02 = new AclUser();
        user02.setId(user02Id);
        user02.setName("User02");
        user02.getGroupIds().add(groupAdminsId);
        user02.getGroupIds().add(groupAgentsId);
        AclUser user03 = new AclUser();
        user03.setId(user03Id);
        user03.setName("User03");
        user03.getGroupIds().add(groupAgentsId);
        AclGroup guestsGroup = new AclGroup();
        guestsGroup.setId(groupGuestId);
        guestsGroup.setName("Guests");
        guestsGroup.setParentId(AclHelper.all.getId());
        AclGroup usersGroup = new AclGroup();
        usersGroup.setId(groupUsersId);
        usersGroup.setName("Users");
        usersGroup.setParentId(AclHelper.all.getId());
        AclGroup adminsGroup = new AclGroup();
        adminsGroup.setId(groupAdminsId);
        adminsGroup.setName("Admins");
        adminsGroup.setParentId(usersGroup.getId());
        AclGroup agentsGroup = new AclGroup();
        agentsGroup.setId(groupAgentsId);
        agentsGroup.setName("Agents");
        agentsGroup.setParentId(usersGroup.getId());
        AclHelper.saveUser((AclUser)user01);
        AclHelper.saveUser((AclUser)user02);
        AclHelper.saveUser((AclUser)user03);
        AclHelper.saveGroup((AclGroup)AclHelper.all);
        AclHelper.saveGroup((AclGroup)guestsGroup);
        AclHelper.saveGroup((AclGroup)usersGroup);
        AclHelper.saveGroup((AclGroup)adminsGroup);
        AclHelper.saveGroup((AclGroup)agentsGroup);
    }

    private void createAclEntries() {
        AclPropertyRestriction propertyRestriction01 = new AclPropertyRestriction();
        propertyRestriction01.setPropertyId(ModelAclBookingFileResourceProperties.NUMBER.getId());
        propertyRestriction01.setConditionId(StandardAclResourcePropertyConditions.INCLUDES.getId());
        propertyRestriction01.setValue(Arrays.asList(BOOKING_FILE_NUMBER_01, BOOKING_FILE_NUMBER_02));
        AclPropertyRestriction propertyRestriction02 = new AclPropertyRestriction();
        propertyRestriction02.setPropertyId(ModelAclBookingFileResourceProperties.CLIENT.getId());
        propertyRestriction02.setConditionId(StandardAclResourcePropertyConditions.NOT_INCLUDES.getId());
        propertyRestriction02.setValue(Arrays.asList(BOOKING_FILE_CLIENT_REFERENCE_02, BOOKING_FILE_CLIENT_REFERENCE_03));
        AclPropertyRestriction propertyRestriction03 = new AclPropertyRestriction();
        AclPropertyRestrictionGroup propertyRestrictionGroup01 = new AclPropertyRestrictionGroup();
        propertyRestrictionGroup01.setType(AclPropertyRestrictionGroupType.SIMPLE);
        propertyRestrictionGroup01.setValue((Object)propertyRestriction01);
        AclPropertyRestrictionGroup propertyRestrictionGroup02 = new AclPropertyRestrictionGroup();
        propertyRestrictionGroup02.setType(AclPropertyRestrictionGroupType.SIMPLE);
        propertyRestrictionGroup02.setValue((Object)propertyRestriction02);
        AclPropertyRestrictionGroup propertyRestrictionGroup03 = new AclPropertyRestrictionGroup();
        AclAction action01 = new AclAction();
        action01.setOperationId(StandardAclResourceOperations.VIEW.getId());
        action01.setPermission(AclResourceOperationPermission.GRANT);
        AclAction action02 = new AclAction();
        action02.setOperationId(StandardAclResourceOperations.EDIT.getId());
        action02.setPermission(AclResourceOperationPermission.DENY);
        AclRule rule = new AclRule();
        rule.getPropertyRestrictionGroups().add(propertyRestrictionGroup01);
        rule.getPropertyRestrictionGroups().add(propertyRestrictionGroup02);
        rule.getActions().add(action01);
        rule.getActions().add(action02);
        AclEntry entry = new AclEntry();
        entry.setResourceId(ModelAclEntityResources.ENTITY_BOOKING_FILE.getId());
        entry.setPrincipalId(user01Id);
        entry.getRules().add(rule);
        AclHelper.saveEntry((AclEntry)entry);
        propertyRestriction01 = new AclPropertyRestriction();
        propertyRestriction01.setPropertyId(ModelAclBookingFileResourceProperties.AGENCY.getId());
        propertyRestriction01.setConditionId(StandardAclResourcePropertyConditions.INCLUDES.getId());
        propertyRestriction01.setValue(Arrays.asList(BOOKING_FILE_AGENCY_REFERENCE_01, BOOKING_FILE_AGENCY_REFERENCE_02));
        propertyRestriction02 = new AclPropertyRestriction();
        propertyRestriction02.setPropertyId(ModelAclProductResourceProperties.STATUS.getId());
        propertyRestriction02.setConditionId(StandardAclResourcePropertyConditions.INCLUDES.getId());
        propertyRestriction02.setValue(Arrays.asList(PRODUCT_STATUS_01, PRODUCT_STATUS_02, PRODUCT_STATUS_03));
        propertyRestriction03 = new AclPropertyRestriction();
        propertyRestriction03.setPropertyId(ModelAclProductResourceProperties.BLANK_OWNER.getId());
        propertyRestriction03.setConditionId(StandardAclResourcePropertyConditions.NOT_INCLUDES.getId());
        propertyRestriction03.setValue(Arrays.asList(PRODUCT_BLANK_OWNER_REFERENCE_02, PRODUCT_BLANK_OWNER_REFERENCE_03));
        propertyRestrictionGroup01 = new AclPropertyRestrictionGroup();
        propertyRestrictionGroup01.setType(AclPropertyRestrictionGroupType.SIMPLE);
        propertyRestrictionGroup01.setValue((Object)propertyRestriction01);
        propertyRestrictionGroup02 = new AclPropertyRestrictionGroup();
        propertyRestrictionGroup02.setType(AclPropertyRestrictionGroupType.SIMPLE);
        propertyRestrictionGroup02.setValue((Object)propertyRestriction02);
        propertyRestrictionGroup03 = new AclPropertyRestrictionGroup();
        propertyRestrictionGroup03.setType(AclPropertyRestrictionGroupType.SIMPLE);
        propertyRestrictionGroup03.setValue((Object)propertyRestriction03);
        action01 = new AclAction();
        action01.setOperationId(StandardAclResourceOperations.ALL.getId());
        action01.setPermission(AclResourceOperationPermission.DENY);
        rule = new AclRule();
        rule.getPropertyRestrictionGroups().add(propertyRestrictionGroup01);
        rule.getPropertyRestrictionGroups().add(propertyRestrictionGroup02);
        rule.getPropertyRestrictionGroups().add(propertyRestrictionGroup03);
        rule.getActions().add(action01);
        entry = new AclEntry();
        entry.setResourceId(ModelAclEntityResources.ENTITY_PRODUCT.getId());
        entry.setPrincipalId(groupUsersId);
        entry.getRules().add(rule);
        AclHelper.saveEntry((AclEntry)entry);
        propertyRestriction01 = new AclPropertyRestriction();
        propertyRestriction01.setPropertyId(ModelAclReservationResourceProperties.RECORD_LOCATOR.getId());
        propertyRestriction01.setConditionId(StandardAclResourcePropertyConditions.NOT_NULL.getId());
        propertyRestriction02 = new AclPropertyRestriction();
        propertyRestriction02.setPropertyId(ModelAclProductResourceProperties.BLANK_OWNER.getId());
        propertyRestriction02.setConditionId(StandardAclResourcePropertyConditions.NOT_INCLUDES.getId());
        propertyRestriction02.setValue(Arrays.asList(PRODUCT_BLANK_OWNER_REFERENCE_02));
        propertyRestrictionGroup01 = new AclPropertyRestrictionGroup();
        propertyRestrictionGroup01.setType(AclPropertyRestrictionGroupType.SIMPLE);
        propertyRestrictionGroup01.setValue((Object)propertyRestriction01);
        propertyRestrictionGroup02 = new AclPropertyRestrictionGroup();
        propertyRestrictionGroup02.setType(AclPropertyRestrictionGroupType.SIMPLE);
        propertyRestrictionGroup02.setValue((Object)propertyRestriction02);
        action01 = new AclAction();
        action01.setOperationId(StandardAclResourceOperations.VIEW.getId());
        action01.setPermission(AclResourceOperationPermission.GRANT);
        action02 = new AclAction();
        action02.setOperationId(StandardAclResourceOperations.EDIT.getId());
        action02.setPermission(AclResourceOperationPermission.GRANT);
        rule = new AclRule();
        rule.getPropertyRestrictionGroups().add(propertyRestrictionGroup01);
        rule.getPropertyRestrictionGroups().add(propertyRestrictionGroup02);
        rule.getActions().add(action01);
        rule.getActions().add(action02);
        entry = new AclEntry();
        entry.setResourceId(ModelAclEntityResources.ENTITY_PRODUCT.getId());
        entry.setPrincipalId(groupAdminsId);
        entry.getRules().add(rule);
        AclHelper.saveEntry((AclEntry)entry);
        propertyRestriction01 = new AclPropertyRestriction();
        propertyRestriction01.setPropertyId(ModelAclOrganizationResourceProperties.TYPE.getId());
        propertyRestriction01.setConditionId(StandardAclResourcePropertyConditions.INCLUDES.getId());
        propertyRestriction01.setValue(Arrays.asList(OrganizationType.AGENCY, OrganizationType.CORPORATE_CLIENT));
        propertyRestrictionGroup01 = new AclPropertyRestrictionGroup();
        propertyRestrictionGroup01.setType(AclPropertyRestrictionGroupType.SIMPLE);
        propertyRestrictionGroup01.setValue((Object)propertyRestriction01);
        action01 = new AclAction();
        action01.setOperationId(StandardAclResourceOperations.CREATE.getId());
        action01.setPermission(AclResourceOperationPermission.DENY);
        rule = new AclRule();
        rule.getPropertyRestrictionGroups().add(propertyRestrictionGroup01);
        rule.getActions().add(action01);
        entry = new AclEntry();
        entry.setResourceId(ModelAclEntityResources.ENTITY_ORGANIZATION.getId());
        entry.setPrincipalId(user03Id);
        entry.getRules().add(rule);
        AclHelper.saveEntry((AclEntry)entry);
        action01 = new AclAction();
        action01.setOperationId(StandardAclResourceOperations.CREATE.getId());
        action01.setPermission(AclResourceOperationPermission.GRANT);
        rule = new AclRule();
        rule.getActions().add(action01);
        entry = new AclEntry();
        entry.setResourceId(ModelAclEntityResources.ENTITY_PERSON.getId());
        entry.setPrincipalId(user03Id);
        entry.getRules().add(rule);
        AclHelper.saveEntry((AclEntry)entry);
    }

    protected boolean isUseNoSchemeTestStorage() {
        return false;
    }
}

