/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.security.acl;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorInfo;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationSystemInfo;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AeroexpressTicketHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclBookingFileResourceProperties;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclEntityResources;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclProductResourceProperties;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclReservationResourceProperties;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclResourceProxy;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import java.util.Date;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class AclProxyTest
extends ModelTestBase {
    private static final String BOOKING_FILE_UID = "booking_file_id";
    private static final String RESERVATION_UID = "reservation_id";
    private static final String PRODUCT_01_UID = "product_01_id";
    private static final String PRODUCT_02_UID = "product_02_id";
    private static final String BOOKING_FILE_NUMBER = "1234567890";
    private static final EntityReference<Organization> BOOKING_FILE_AGENCY_REFERENCE = new EntityReference("booking_file_agency", Organization.class, "Booking File Agency");
    private static final EntityReference<Organization> BOOKING_FILE_CLIENT_REFERENCE = new EntityReference("booking_file_client", Organization.class, "Booking File Client");
    private static final String RESERVATION_RECORD_LOCATOR = "ABCDEF";
    private static final ProductStatus PRODUCT_01_STATUS = ProductStatus.SELL;
    private static final ProductStatus PRODUCT_02_STATUS = ProductStatus.VOID;
    private static final EntityReference<Organization> PRODUCT_01_BLANK_OWNER_REFERENCE = new EntityReference("product_01_blank_owner", Organization.class, "Product 01 Blank Owner");
    private static final EntityReference<Organization> PRODUCT_02_BLANK_OWNER_REFERENCE = new EntityReference("product_02_blank_owner", Organization.class, "Product 02 Blank Owner");
    private static final EntityReference<Organization> PRODUCT_01_SUPPLIER_REFERENCE = new EntityReference("product_01_supplier", Organization.class, "Product 01 Supplier");
    private static final EntityReference<Organization> PRODUCT_02_SUPPLIER_REFERENCE = new EntityReference("product_02_supplier", Organization.class, "Product 02 Supplier");
    private static final Date PRODUCT_01_ISSUE_DATE = new Date(100000000000L);
    private static final Date PRODUCT_02_ISSUE_DATE = new Date(900000000000L);
    private static final EntityReference<Organization> PRODUCT_01_AGENCY_REFERENCE = new EntityReference("product_01_agency", Organization.class, "Product 01 Agency");
    private static final EntityReference<Organization> PRODUCT_02_AGENCY_REFERENCE = new EntityReference("product_02_agency", Organization.class, "Product 02 Agency");
    private static final EntityReference<Organization> PRODUCT_01_SUBAGENCY_REFERENCE = new EntityReference("product_01_subagency", Organization.class, "Product 01 Subagency");
    private static final EntityReference<Organization> PRODUCT_02_SUBAGENCY_REFERENCE = new EntityReference("product_02_subagency", Organization.class, "Product 02 Subagency");
    private static final EntityReference<SalesPoint> PRODUCT_01_SALES_POINT_REFERENCE = new EntityReference("product_01_sales_point", SalesPoint.class, "Product 01 Sales Point");
    private static final EntityReference<SalesPoint> PRODUCT_02_SALES_POINT_REFERENCE = new EntityReference("product_02_sales_point", SalesPoint.class, "Product 02 Sales Point");
    private static final EntityReference<Person> PRODUCT_01_AGENT_REFERENCE = new EntityReference("product_01_agent", Person.class, "Product 01 Agent");
    private static final EntityReference<Person> PRODUCT_02_AGENT_REFERENCE = new EntityReference("product_02_agent", Person.class, "Product 02 Agent");

    @Test
    public void testBuildProxies() throws Exception {
        BookingFile bookingFile = this.createBookingFile();
        Map proxies = AclHelper.buildProxies((Object)bookingFile, (String)ModelAclEntityResources.ENTITY_BOOKING_FILE.getId());
        Assert.assertEquals((long)11L, (long)proxies.size());
        ModelAclResourceProxy bookingFileProxy = (ModelAclResourceProxy)proxies.get(BOOKING_FILE_UID);
        Assert.assertNull((Object)bookingFileProxy.getParent());
        Assert.assertEquals((Object)BOOKING_FILE_NUMBER, bookingFileProxy.getProperties().get(ModelAclBookingFileResourceProperties.NUMBER.getId()));
        Assert.assertEquals(PRODUCT_01_AGENCY_REFERENCE, bookingFileProxy.getProperties().get(ModelAclBookingFileResourceProperties.AGENCY.getId()));
        Assert.assertEquals(BOOKING_FILE_CLIENT_REFERENCE, bookingFileProxy.getProperties().get(ModelAclBookingFileResourceProperties.CLIENT.getId()));
        ModelAclResourceProxy reservationProxy = (ModelAclResourceProxy)proxies.get(RESERVATION_UID);
        Assert.assertEquals((Object)bookingFileProxy.getId(), (Object)reservationProxy.getParent().getId());
        Assert.assertEquals((Object)RESERVATION_RECORD_LOCATOR, reservationProxy.getProperties().get(ModelAclReservationResourceProperties.RECORD_LOCATOR.getId()));
        ModelAclResourceProxy product01Proxy = (ModelAclResourceProxy)proxies.get(PRODUCT_01_UID);
        Assert.assertEquals((Object)reservationProxy.getId(), (Object)product01Proxy.getParent().getId());
        Assert.assertEquals((Object)ProductType.AIR_TICKET, product01Proxy.getProperties().get(ModelAclProductResourceProperties.TYPE.getId()));
        Assert.assertEquals((Object)PRODUCT_01_STATUS, product01Proxy.getProperties().get(ModelAclProductResourceProperties.STATUS.getId()));
        Assert.assertEquals(PRODUCT_01_BLANK_OWNER_REFERENCE, product01Proxy.getProperties().get(ModelAclProductResourceProperties.BLANK_OWNER.getId()));
        Assert.assertEquals(PRODUCT_01_SUPPLIER_REFERENCE, product01Proxy.getProperties().get(ModelAclProductResourceProperties.SUPPLIER.getId()));
        Assert.assertEquals((Object)PRODUCT_01_ISSUE_DATE, product01Proxy.getProperties().get(ModelAclProductResourceProperties.ISSUE_DATE.getId()));
        Assert.assertEquals(PRODUCT_01_AGENCY_REFERENCE, product01Proxy.getProperties().get(ModelAclProductResourceProperties.AGENCY.getId()));
        Assert.assertEquals(PRODUCT_01_SUBAGENCY_REFERENCE, product01Proxy.getProperties().get(ModelAclProductResourceProperties.SUBAGENCY.getId()));
        Assert.assertEquals(PRODUCT_01_SALES_POINT_REFERENCE, product01Proxy.getProperties().get(ModelAclProductResourceProperties.SALES_POINT.getId()));
        Assert.assertEquals(PRODUCT_01_AGENT_REFERENCE, product01Proxy.getProperties().get(ModelAclProductResourceProperties.AGENT.getId()));
        ModelAclResourceProxy product02Proxy = (ModelAclResourceProxy)proxies.get(PRODUCT_02_UID);
        Assert.assertEquals((Object)reservationProxy.getId(), (Object)product02Proxy.getParent().getId());
        Assert.assertEquals((Object)ProductType.AEROEXPRESS, product02Proxy.getProperties().get(ModelAclProductResourceProperties.TYPE.getId()));
        Assert.assertEquals((Object)PRODUCT_02_STATUS, product02Proxy.getProperties().get(ModelAclProductResourceProperties.STATUS.getId()));
        Assert.assertEquals(PRODUCT_02_BLANK_OWNER_REFERENCE, product02Proxy.getProperties().get(ModelAclProductResourceProperties.BLANK_OWNER.getId()));
        Assert.assertEquals(PRODUCT_02_SUPPLIER_REFERENCE, product02Proxy.getProperties().get(ModelAclProductResourceProperties.SUPPLIER.getId()));
        Assert.assertEquals((Object)PRODUCT_02_ISSUE_DATE, product02Proxy.getProperties().get(ModelAclProductResourceProperties.ISSUE_DATE.getId()));
        Assert.assertEquals(PRODUCT_02_AGENCY_REFERENCE, product02Proxy.getProperties().get(ModelAclProductResourceProperties.AGENCY.getId()));
        Assert.assertEquals(PRODUCT_02_SUBAGENCY_REFERENCE, product02Proxy.getProperties().get(ModelAclProductResourceProperties.SUBAGENCY.getId()));
        Assert.assertEquals(PRODUCT_02_SALES_POINT_REFERENCE, product02Proxy.getProperties().get(ModelAclProductResourceProperties.SALES_POINT.getId()));
        Assert.assertEquals(PRODUCT_02_AGENT_REFERENCE, product02Proxy.getProperties().get(ModelAclProductResourceProperties.AGENT.getId()));
    }

    private BookingFile createBookingFile() throws Exception {
        BookingFile bookingFile = new BookingFile();
        bookingFile.setUid(BOOKING_FILE_UID);
        bookingFile.setNumber(BOOKING_FILE_NUMBER);
        bookingFile.setAgency(BOOKING_FILE_AGENCY_REFERENCE);
        bookingFile.setCustomerProfile(BOOKING_FILE_CLIENT_REFERENCE);
        Reservation reservation = new Reservation();
        reservation.setUid(RESERVATION_UID);
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.SABRE, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)RESERVATION_RECORD_LOCATOR);
        ((RecordLocatorInfo)((ReservationSystemInfo)reservation.getGdsNameInfo().getSystemInfos().get(0)).getRecordLocators().get(0)).setDisplay(true);
        reservation.getGdsNameInfo().setRulesGdsName(GdsName.SABRE);
        reservation.setBookingFile(bookingFile);
        bookingFile.getReservations().add(reservation);
        Product product01 = new Product();
        product01.setUid(PRODUCT_01_UID);
        product01.setProductCategory(ProductCategory.AIR);
        product01.setStatus(PRODUCT_01_STATUS);
        product01.setBlankOwnerRef(PRODUCT_01_BLANK_OWNER_REFERENCE);
        AirProductHelper.setSupplier((Product)product01, PRODUCT_01_SUPPLIER_REFERENCE);
        product01.setIssueDate(PRODUCT_01_ISSUE_DATE);
        AirProductHelper.setAgency((Product)product01, PRODUCT_01_AGENCY_REFERENCE);
        AirProductHelper.setSubagency((Product)product01, PRODUCT_01_SUBAGENCY_REFERENCE);
        product01.setSalesPoint(PRODUCT_01_SALES_POINT_REFERENCE);
        product01.setCashier(PRODUCT_01_AGENT_REFERENCE);
        product01.setReservation(reservation);
        reservation.getProducts().add(product01);
        AeroexpressTicket product02 = new AeroexpressTicket();
        product02.setUid(PRODUCT_02_UID);
        product02.setStatus(PRODUCT_02_STATUS);
        product02.setBlankOwner(PRODUCT_02_BLANK_OWNER_REFERENCE);
        AeroexpressTicketHelper.setSupplier((AeroexpressTicket)product02, PRODUCT_02_SUPPLIER_REFERENCE);
        product02.setIssueDate(PRODUCT_02_ISSUE_DATE);
        AeroexpressTicketHelper.setAgency((AeroexpressTicket)product02, PRODUCT_02_AGENCY_REFERENCE);
        AeroexpressTicketHelper.setSubagency((AeroexpressTicket)product02, PRODUCT_02_SUBAGENCY_REFERENCE);
        product02.setSalesPoint(PRODUCT_02_SALES_POINT_REFERENCE);
        product02.setAgent(PRODUCT_02_AGENT_REFERENCE);
        product02.setReservation(reservation);
        reservation.getProducts().add(product02);
        return bookingFile;
    }
}

