/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.shipments;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.commission.CalculationType;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Nomenclature;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.standard.nomenclatures.NomenclatureActions;
import com.gridnine.xtrip.common.model.rules.standard.nomenclatures.StandardNomenclatureTargets;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestCommissionCategoryBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestFeePropertiesBuilder;
import com.gridnine.xtrip.server.model.test.TestModelContractBuilder;
import com.gridnine.xtrip.server.model.test.TestNomenclatureBuilder;
import com.gridnine.xtrip.server.model.test.TestNomenclatureSettingsBuilder;
import com.gridnine.xtrip.server.model.test.TestRuleSetBuilder;
import com.gridnine.xtrip.server.model.test.TestShipmentBuilder;
import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;

public class FreezeProductClientPartInterceptorTest
extends ModelTestBase {
    private DictionaryReference<Nomenclature> productNomenclature;
    private DictionaryReference<Nomenclature> feeNomenclature;

    @Test
    public void testNoChange() throws Exception {
        this.createNomenclatures();
        this.createNomenclatureSettings();
        this.createContract();
        EntityContainer bookingFileContainer = new TestBookingFileBuilder().traveller().end().reservation().airProduct().subagency(TestBookingFileBuilder.subagency).vendorContractRelation().fop().paymentType(PaymentType.CASH).end().end().subagentContractRelation().fop().paymentType(PaymentType.CASH).end().end().clientContractRelation().fop().paymentType(PaymentType.CASH).end().end().end().end().create();
        EntityReference shipmentRef = new TestShipmentBuilder().number("0001").create().toReference();
        ((BaseProduct)BookingHelper.getProducts((BookingFile)((BookingFile)bookingFileContainer.getEntity())).get(0)).getFopDetalizations().values().forEach(det -> det.getComponents().forEach(comp -> comp.setShipment(shipmentRef)));
        EntityStorage.get().save(bookingFileContainer, true);
        EntityStorage.get().save(bookingFileContainer, true);
    }

    @Test
    public void testPaymentTypeChange() throws Exception {
        this.createNomenclatures();
        this.createNomenclatureSettings();
        this.createContract();
        EntityContainer bookingFileContainer = new TestBookingFileBuilder().traveller().end().reservation().airProduct().subagency(TestBookingFileBuilder.subagency).vendorContractRelation().fop().paymentType(PaymentType.CASH).end().end().subagentContractRelation().fop().paymentType(PaymentType.CASH).end().end().clientContractRelation().fop().paymentType(PaymentType.CASH).end().end().end().end().create();
        EntityReference shipmentRef = new TestShipmentBuilder().number("0001").create().toReference();
        ((BaseProduct)BookingHelper.getProducts((BookingFile)((BookingFile)bookingFileContainer.getEntity())).get(0)).getFopDetalizations().values().forEach(det -> det.getComponents().forEach(comp -> comp.setShipment(shipmentRef)));
        EntityStorage.get().save(bookingFileContainer, true);
        Product prod = (Product)BookingHelper.getProducts((BookingFile)((BookingFile)bookingFileContainer.getEntity())).get(0);
        ((ProductFop)AirProductHelper.getClientContractRelation((Product)prod).getFops().get(0)).setType(PaymentType.INVOICE);
        boolean hasException = false;
        try {
            EntityStorage.get().save(bookingFileContainer, true);
        }
        catch (Exception e) {
            hasException = true;
        }
        Assert.assertTrue((boolean)hasException);
    }

    @Test
    public void testNewFop() throws Exception {
        this.createNomenclatures();
        this.createNomenclatureSettings();
        this.createContract();
        EntityContainer bookingFileContainer = new TestBookingFileBuilder().traveller().end().reservation().airProduct().subagency(TestBookingFileBuilder.subagency).vendorContractRelation().fop().paymentType(PaymentType.CASH).end().end().subagentContractRelation().fop().paymentType(PaymentType.CASH).end().end().clientContractRelation().fop().paymentType(PaymentType.CASH).end().end().end().end().create();
        EntityReference shipmentRef = new TestShipmentBuilder().number("0001").create().toReference();
        ((BaseProduct)BookingHelper.getProducts((BookingFile)((BookingFile)bookingFileContainer.getEntity())).get(0)).getFopDetalizations().values().forEach(det -> det.getComponents().forEach(comp -> comp.setShipment(shipmentRef)));
        EntityStorage.get().save(bookingFileContainer, true);
        Product prod = (Product)BookingHelper.getProducts((BookingFile)((BookingFile)bookingFileContainer.getEntity())).get(0);
        ProductFop productFop = new ProductFop();
        productFop.setType(PaymentType.CASH);
        productFop.setAmount(SystemHelper.getMoney((double)100.0, (String)DictHelper.getLocalCurrency()));
        AirProductHelper.getClientContractRelation((Product)prod).getFops().add(productFop);
        EntityStorage.get().save(bookingFileContainer, true);
    }

    @Test
    public void testExcludeFeeFromShipment() throws Exception {
        this.createNomenclatures();
        this.createNomenclatureSettings();
        this.createContract();
        EntityContainer bookingFileContainer = new TestBookingFileBuilder().traveller().end().reservation().airProduct().subagency(TestBookingFileBuilder.subagency).vendorContractRelation().fop().paymentType(PaymentType.CASH).end().end().subagentContractRelation().fop().paymentType(PaymentType.CASH).end().end().clientContractRelation().fop().paymentType(PaymentType.CASH).end().end().end().end().create();
        EntityReference productShipmentRef = new TestShipmentBuilder().number("0001").create().toReference();
        EntityReference feeShipmentRef = new TestShipmentBuilder().number("0002").create().toReference();
        Product prod = (Product)BookingHelper.getProducts((BookingFile)((BookingFile)bookingFileContainer.getEntity())).get(0);
        AirProductContractRelationData clientContractRelation = AirProductHelper.getClientContractRelation((Product)prod);
        ((FopDetalization)prod.getFopDetalizations().get(((ProductFop)clientContractRelation.getFops().get(0)).getUid())).getComponents().forEach(comp -> comp.setShipment(productShipmentRef));
        ((FopDetalization)prod.getFopDetalizations().get(((ProductFop)clientContractRelation.getFops().get(1)).getUid())).getComponents().forEach(comp -> comp.setShipment(feeShipmentRef));
        EntityStorage.get().save(bookingFileContainer, true);
        prod = (Product)BookingHelper.getProducts((BookingFile)((BookingFile)bookingFileContainer.getEntity())).get(0);
        clientContractRelation = AirProductHelper.getClientContractRelation((Product)prod);
        ((FopDetalization)prod.getFopDetalizations().get(((ProductFop)clientContractRelation.getFops().get(1)).getUid())).getComponents().forEach(comp -> comp.setShipment(null));
        EntityStorage.get().save(bookingFileContainer, true);
    }

    @Test
    public void testSubagentShipment() throws Exception {
        this.createNomenclatures();
        ((TestNomenclatureSettingsBuilder)((TestRuleSetBuilder)new TestNomenclatureSettingsBuilder().agency(TestBookingFileBuilder.agency).ruleSettings((RuleTarget)StandardNomenclatureTargets.NOMENCLATURE_AIR).result((RuleAction)NomenclatureActions.PRODUCT_NOMENCLATURE, this.productNomenclature).result((RuleAction)NomenclatureActions.FEE_NOMENCLATURE, this.feeNomenclature).end()).end()).create();
        DictionaryReference feeCategoryRef = ((TestCommissionCategoryBuilder)new TestCommissionCategoryBuilder().code("FEE")).create();
        EntityReference feeRef = new TestFeePropertiesBuilder().displayName("Hidden Fee").calculationType(CalculationType.TICKET).calculationType(Operation.SELL).category(feeCategoryRef).chargeToClient(true).create().toReference();
        RuleResultValue feeValue = new RuleResultValue();
        feeValue.setTarget(feeRef);
        feeValue.setCurrencyCode("RUB");
        feeValue.setValue(100.0);
        EntityReference modelCtrRef = ((TestModelContractBuilder)((TestRuleSetBuilder)new TestModelContractBuilder().ruleSet().rule().target((RuleTarget)Targets.PRODUCT_COMMISSION).result((RuleAction)Actions.SIMPLE_FEE, (Object)feeValue).end()).end()).create().toReference();
        new TestContractBuilderBuilder().contractType(ContractType.SUBAGENCY).supplier(TestBookingFileBuilder.agency).customerNewContract(TestBookingFileBuilder.subagency).newModel(true).modelContract(modelCtrRef).create();
        EntityContainer bookingFileContainer = new TestBookingFileBuilder().traveller().end().reservation().airProduct().subagency(TestBookingFileBuilder.subagency).vendorContractRelation().fop().paymentType(PaymentType.CASH).end().end().subagentContractRelation().fop().paymentType(PaymentType.CASH).end().end().clientContractRelation().fop().paymentType(PaymentType.CASH).end().end().end().end().create();
        EntityReference productShipmentRef = new TestShipmentBuilder().number("0001").create().toReference();
        Product prod = (Product)BookingHelper.getProducts((BookingFile)((BookingFile)bookingFileContainer.getEntity())).get(0);
        AirProductContractRelationData subagencyContractRelation = AirProductHelper.getSubagentContractRelation((Product)prod);
        ((FopDetalization)prod.getFopDetalizations().get(((ProductFop)subagencyContractRelation.getFops().get(0)).getUid())).getComponents().forEach(comp -> comp.setShipment(productShipmentRef));
        ((FopDetalization)prod.getFopDetalizations().get(((ProductFop)subagencyContractRelation.getFops().get(1)).getUid())).getComponents().forEach(comp -> comp.setShipment(productShipmentRef));
        EntityStorage.get().save(bookingFileContainer, true);
        prod = (Product)BookingHelper.getProducts((BookingFile)((BookingFile)bookingFileContainer.getEntity())).get(0);
        AirProductHelper.getClientContractRelation((Product)prod).getServiceData().setTotalPrice(BigDecimal.valueOf(100L));
        AirProductHelper.getClientContractRelation((Product)prod).getServiceData().setPaymentPrice(BigDecimal.valueOf(100L));
        EntityStorage.get().save(bookingFileContainer, true);
        AirProductHelper.getSubagentContractRelation((Product)prod).getServiceData().setTotalPrice(BigDecimal.valueOf(100L));
        boolean hasException = false;
        try {
            EntityStorage.get().save(bookingFileContainer, true);
        }
        catch (Exception e) {
            hasException = true;
        }
        Assert.assertTrue((boolean)hasException);
    }

    private void createContract() throws Exception {
        DictionaryReference feeCategoryRef = ((TestCommissionCategoryBuilder)new TestCommissionCategoryBuilder().code("FEE")).create();
        EntityReference feeRef = new TestFeePropertiesBuilder().displayName("Hidden Fee").calculationType(CalculationType.TICKET).calculationType(Operation.SELL).category(feeCategoryRef).chargeToClient(true).create().toReference();
        RuleResultValue feeValue = new RuleResultValue();
        feeValue.setTarget(feeRef);
        feeValue.setCurrencyCode("RUB");
        feeValue.setValue(100.0);
        EntityReference modelCtrRef = ((TestModelContractBuilder)((TestRuleSetBuilder)new TestModelContractBuilder().ruleSet().rule().target((RuleTarget)Targets.PRODUCT_COMMISSION).result((RuleAction)Actions.SIMPLE_FEE, (Object)feeValue).end()).end()).create().toReference();
        new TestContractBuilderBuilder().contractType(ContractType.CLIENT).supplier(TestBookingFileBuilder.subagency).customerNewContract(TestBookingFileBuilder.client).newModel(true).modelContract(modelCtrRef).create();
    }

    private void createNomenclatures() throws Exception {
        this.productNomenclature = new TestNomenclatureBuilder("PRODUCT").create();
        this.feeNomenclature = new TestNomenclatureBuilder("FEE").create();
    }

    private void createNomenclatureSettings() throws Exception {
        ((TestNomenclatureSettingsBuilder)((TestRuleSetBuilder)new TestNomenclatureSettingsBuilder().agency(TestBookingFileBuilder.subagency).ruleSettings((RuleTarget)StandardNomenclatureTargets.NOMENCLATURE_AIR).result((RuleAction)NomenclatureActions.PRODUCT_NOMENCLATURE, this.productNomenclature).result((RuleAction)NomenclatureActions.FEE_NOMENCLATURE, this.feeNomenclature).end()).end()).create();
    }
}

