/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.shipments;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ExtendedProductType;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.ProductDateData;
import com.gridnine.xtrip.common.model.booking.ProductDateType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ShipmentCategoryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentData;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentRecordIndex;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentsCreateTaskConfiguration;
import com.gridnine.xtrip.common.model.finance.ShipmentIndex;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.finance.Actions;
import com.gridnine.xtrip.common.model.rules.finance.Properties;
import com.gridnine.xtrip.common.model.rules.finance.Targets;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.nomenclatures.NomenclatureActions;
import com.gridnine.xtrip.common.model.rules.standard.nomenclatures.StandardNomenclatureTargets;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ResourceUtil;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import com.gridnine.xtrip.server.model.finance.FinanceTestBase;
import com.gridnine.xtrip.server.model.shipments.FinanceDocumentsCreateTaskForTesting;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestModelContractBuilder;
import com.gridnine.xtrip.server.model.test.TestNomenclatureBuilder;
import com.gridnine.xtrip.server.model.test.TestNomenclatureSettingsBuilder;
import com.gridnine.xtrip.server.model.test.TestRuleSetBuilder;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class ShipmentsAutoCreateTaskTest
extends FinanceTestBase {
    private static final EntityReference<TemplateDocument> invoiceTemplate = new EntityReference("invoiceTemplate", TemplateDocument.class, "Invoice Template");

    public void setUp() throws Exception {
        super.setUp();
        ShipmentsAutoCreateTaskTest.setSysProp((String)"org.apache.commons.logging.simplelog.log.com.gridnine.xtrip.server.ibus", (String)"debug");
    }

    @Test
    public void testTask() throws Exception {
        LocaleManager.get().setCurrentLocale(LocaleHelper.RU_LOCALE);
        ShipmentCategoryReference category01 = new ShipmentCategoryReference("air");
        ExtendedProductType productType01 = new ExtendedProductType();
        productType01.setProductType(ProductType.AIR_TICKET);
        productType01.setProductDescription(null);
        Date date = new Date();
        TestModelContractBuilder modelContractBuilder = new TestModelContractBuilder();
        ProductDateData dateData = new ProductDateData();
        dateData.setProductDateType(ProductDateType.ISSUE_DATE);
        FinanceDocumentData documentData = new FinanceDocumentData();
        documentData.setType(FinanceDocumentType.INVOICE);
        documentData.setTemplate(invoiceTemplate);
        documentData.setUseFacsimile(true);
        documentData.setUseDelegate(true);
        EntityContainer agencyctr = EntityStorage.get().resolve(TestBookingFileBuilder.agency);
        FinanceDocumentSettings invoiceSettings = new FinanceDocumentSettings();
        invoiceSettings.setUseSettings(true);
        invoiceSettings.setType(FinanceDocumentType.INVOICE);
        invoiceSettings.setTemplate(invoiceTemplate);
        ((Organization)agencyctr.getEntity()).getFinanceDocumentProperties().getFinanceDocumentsSettings().add(invoiceSettings);
        ArrayList<BankAccount> accounts = new ArrayList<BankAccount>();
        for (int n = 0; n < 3; ++n) {
            BankAccount bankAccount = new BankAccount();
            bankAccount.setBankName("bank " + n);
            bankAccount.setCorrespondentAccount("correspondentAccount" + n);
            bankAccount.setSettlementAccount("settlementAccount" + n);
            accounts.add(bankAccount);
        }
        ((Organization)agencyctr.getEntity()).getFinanceDocumentProperties().setBankAccount((BankAccount)accounts.get(1));
        EntityStorage.get().save(agencyctr, true);
        EntityContainer modelContractContainer = ((TestModelContractBuilder)((TestRuleSetBuilder)((TestRuleSetBuilder)((TestRuleSetBuilder)modelContractBuilder.ruleSet().rule().target((RuleTarget)Targets.BILLING_ITEM).restriction((RuleProperty)Properties.BILLING_ITEM_PRODUCT_TYPE, (RuleCondition)Conditions.EQUALS, Collections.singletonList(productType01)).result((RuleAction)Actions.SHIPMENT_CATEGORY, (Object)category01).end()).rule().target((RuleTarget)Targets.SHIPMENTS_DATE).result((RuleAction)Actions.SHIPMENTS_DATE, (Object)dateData).end()).rule().target((RuleTarget)Targets.SHIPMENT).result((RuleAction)Actions.FINANCE_DOCUMENT_DATA, (Object)documentData).end()).end()).create();
        EntityReference modelContract = modelContractContainer.toReference();
        TestContractBuilderBuilder contractBuilder = new TestContractBuilderBuilder();
        contractBuilder.newModel(Boolean.TRUE).contractType(ContractType.CLIENT).supplier(TestBookingFileBuilder.agency).customerNewContract(TestBookingFileBuilder.client).modelContract(modelContract).create();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        DictionaryReference productNomenclature = new TestNomenclatureBuilder("PRODUCT").create();
        ((TestNomenclatureSettingsBuilder)((TestRuleSetBuilder)new TestNomenclatureSettingsBuilder().agency(TestBookingFileBuilder.agency).ruleSettings((RuleTarget)StandardNomenclatureTargets.NOMENCLATURE_AIR).result((RuleAction)NomenclatureActions.PRODUCT_NOMENCLATURE, (Object)productNomenclature).end()).end()).create();
        Product airProduct = new Product();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        Traveller traveller = new Traveller();
        String issueDateString = TestBookingFileBuilder.getDateFormat().format(issueDate);
        airProduct.setShipmentsDate(issueDate);
        ProductFop clientFop = new ProductFop();
        bookingFileBuilder.reservation().airProduct(airProduct).traveller(traveller).issueDate(issueDateString).segmentTariff().segment().end().end().vendorContractRelation().fop().paymentType(PaymentType.INVOICE).amount(6700.0).end().end().clientContractRelation().fop(clientFop).paymentType(PaymentType.INVOICE).amount(6700.0).end().end().end().end().create();
        FinanceDocumentsCreateTaskForTesting task = new FinanceDocumentsCreateTaskForTesting();
        FinanceDocumentsCreateTaskConfiguration conf = new FinanceDocumentsCreateTaskConfiguration();
        conf.setStartDate(new Date(System.currentTimeMillis() - TimeUnit.DAYS.toMillis(20L)));
        conf.setEndDate(date);
        conf.setDate(date);
        task.configure(conf);
        task.doJob(new LongRunningTask.EventsCallback(){

            @Override
            public void addEvent(String eventId, Message description) {
            }

            @Override
            public void updateProgress(byte progress) {
            }

            @Override
            public void taskFinished() {
            }
        });
        List shipments = StorageHelper.getEntityContainers((SearchQuery)new SearchQuery(), ShipmentIndex.class);
        Assert.assertEquals((long)1L, (long)shipments.size());
        List financeDocuments = StorageHelper.getEntityContainers((SearchQuery)new SearchQuery(), FinanceDocumentRecordIndex.class);
        Assert.assertEquals((long)1L, (long)financeDocuments.size());
        FinanceDocument invoice = (FinanceDocument)((EntityContainer)financeDocuments.get(0)).getEntity();
        Assert.assertEquals((Object)((BankAccount)accounts.get(1)).getUid(), (Object)invoice.getSupplierBankAccount().getNestedEntityUid());
        Assert.assertTrue((boolean)invoice.isUseDelegate());
        Assert.assertTrue((boolean)invoice.isUseFacsimile());
    }

    protected List<URL> getEntitiesSetupFiles() throws Exception {
        List result = super.getEntitiesSetupFiles();
        result.add(ResourceUtil.getResource(((Object)((Object)this)).getClass(), (String)"Template-Invoice.xml", (boolean)true));
        return result;
    }
}

