/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.shipments;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.ExtendedProductType;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ShipmentCategory;
import com.gridnine.xtrip.common.model.dict.ShipmentCategoryReference;
import com.gridnine.xtrip.common.model.rules.finance.Actions;
import com.gridnine.xtrip.common.model.rules.finance.Properties;
import com.gridnine.xtrip.common.model.rules.finance.Targets;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.finance.FinanceTestBase;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestModelContractBuilder;
import com.gridnine.xtrip.server.model.test.TestRuleSetBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.junit.Before;

public class ShipmentsCreateTest
extends FinanceTestBase {
    private DictionaryReference<ShipmentCategory> category01 = null;
    private DictionaryReference<ShipmentCategory> category02 = null;
    private ExtendedProductType productType01 = null;
    private ExtendedProductType productType02 = null;

    @Override
    @Before
    public void initialize() throws Exception {
        super.initialize();
        this.category01 = new ShipmentCategoryReference("air");
        this.category02 = new ShipmentCategoryReference("hotel");
        this.productType01 = new ExtendedProductType();
        this.productType01.setProductType(ProductType.AIR_TICKET);
        this.productType01.setProductDescription(null);
        this.productType02 = new ExtendedProductType();
        this.productType02.setProductType(ProductType.HOTEL_RESERVATION);
        this.productType02.setProductDescription(null);
    }

    public void financeDocumentDeleteTest1() throws Exception {
        Date date = new Date();
        TestModelContractBuilder modelContractBuilder = new TestModelContractBuilder();
        EntityContainer modelContractContainer = ((TestModelContractBuilder)((TestRuleSetBuilder)((TestRuleSetBuilder)modelContractBuilder.ruleSet().rule().target((RuleTarget)Targets.BILLING_ITEM).restriction((RuleProperty)Properties.BILLING_ITEM_PRODUCT_TYPE, (RuleCondition)Conditions.EQUALS, (Object)this.productType01).result((RuleAction)Actions.SHIPMENT_CATEGORY, this.category01).end()).rule().target((RuleTarget)Targets.BILLING_ITEM).restriction((RuleProperty)Properties.BILLING_ITEM_PRODUCT_TYPE, (RuleCondition)Conditions.EQUALS, (Object)this.productType02).result((RuleAction)Actions.SHIPMENT_CATEGORY, this.category02).end()).end()).create();
        EntityReference modelContract = modelContractContainer.toReference();
        TestContractBuilderBuilder contractBuilder = new TestContractBuilderBuilder();
        EntityContainer contractContainer = contractBuilder.newModel(Boolean.TRUE).contractType(ContractType.CLIENT).supplier(TestBookingFileBuilder.agency).customerNewContract(TestBookingFileBuilder.client).modelContract(modelContract).create();
        EntityReference contract = contractContainer.toReference();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product airProduct = new Product();
        HotelProduct hotelProduct = new HotelProduct();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String issueDateString = TestBookingFileBuilder.getDateFormat().format(issueDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.reservation().airProduct(airProduct).rulesApplied(true).issueDate(issueDateString).segmentTariff().segment().end().end().vendorContractRelation().fop().paymentType(PaymentType.INVOICE).amount(6700.0).end().end().clientContractRelation().fop().paymentType(PaymentType.INVOICE).amount(6700.0).end().end().end().hotelProduct(hotelProduct).rulesApplied(true).issueDate(issueDateString).unholdDate(issueDateString).vendorContractRelation().fop().paymentType(PaymentType.INVOICE).amount(2300.0).end().end().clientContractRelation().fop().paymentType(PaymentType.INVOICE).amount(2300.0).end().end().end().end().create();
        NestedEntityReference product01 = new NestedEntityReference(bookingFileContainer, (BaseEntity)airProduct);
        NestedEntityReference product02 = new NestedEntityReference(bookingFileContainer, (BaseEntity)hotelProduct);
        ArrayList<NestedEntityReference> products = new ArrayList<NestedEntityReference>();
        products.add(product01);
        products.add(product02);
        HashMap<String, Cloneable> context = new HashMap<String, Cloneable>();
        context.put(IBusFinanceContextKeys.DATE.name(), date);
        context.put(IBusFinanceContextKeys.PRODUCT_REFERENCES.name(), products);
        IntegrationBusFacade.get().processRouteSync("shipments:create", context);
        Collection shipments = (Collection)context.get(IBusFinanceContextKeys.SHIPMENT_REFERENCES.name());
    }
}

