/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.shipments;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.NomenclatureSettings;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.CalculationType;
import com.gridnine.xtrip.common.model.booking.commission.FeeType;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.CommissionCategoryReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ShipmentCategoryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.rules.finance.Properties;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.finance.FinanceTestBase;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestFeePropertiesBuilder;
import com.gridnine.xtrip.server.model.test.TestModelContractBuilder;
import com.gridnine.xtrip.server.model.test.TestRuleSetBuilder;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ShipmentsMergeRefundTest
extends FinanceTestBase {
    @Override
    @Before
    public void initialize() throws Exception {
        super.initialize();
        ShipmentCategoryReference category = new ShipmentCategoryReference("hotel");
        NomenclatureSettings nomenclatureSettings = new NomenclatureSettings();
        nomenclatureSettings.setAgency(TestBookingFileBuilder.agency);
        EntityStorage.get().save(EntityContainer.create((BaseEntity)nomenclatureSettings), true);
        EntityReference refundFeeProp = new TestFeePropertiesBuilder().displayName("Test Fee").category((DictionaryReference)new CommissionCategoryReference("cat")).calculationType(Operation.REFUND).calculationType(CalculationType.TICKET).rate(false).productTypes(new ProductType[]{ProductType.HOTEL_RESERVATION}).type(FeeType.STANDARD).create().toReference();
        TestModelContractBuilder modelContractBuilder = new TestModelContractBuilder();
        EntityContainer modelContractContainer = ((TestModelContractBuilder)((TestRuleSetBuilder)((TestRuleSetBuilder)((TestRuleSetBuilder)modelContractBuilder.ruleSet().rule().target((RuleTarget)Targets.HOTELS_COMMISSION).commission(100.0, "RUB", refundFeeProp, (RuleAction)Actions.SIMPLE_FEE).end()).rule().target((RuleTarget)com.gridnine.xtrip.common.model.rules.finance.Targets.BILLING_ITEM).result((RuleAction)com.gridnine.xtrip.common.model.rules.finance.Actions.SHIPMENT_CATEGORY, (Object)category).end()).rule().target((RuleTarget)com.gridnine.xtrip.common.model.rules.finance.Targets.BILLING_ITEMS_CREATION).restriction((RuleProperty)Properties.BILLING_ITEM_CREATION_SUPPLIER, (RuleCondition)Conditions.EQUALS, Collections.singletonList(TestBookingFileBuilder.blankOwner)).result((RuleAction)com.gridnine.xtrip.common.model.rules.finance.Actions.MERGE_REFUND_BILLING_ITEMS, (Object)Boolean.TRUE).end()).end()).create();
        EntityReference modelContract = modelContractContainer.toReference();
        TestContractBuilderBuilder contractBuilder = new TestContractBuilderBuilder();
        contractBuilder.newModel(Boolean.TRUE).contractType(ContractType.CLIENT).supplier(TestBookingFileBuilder.agency).customerNewContract(TestBookingFileBuilder.client).modelContract(modelContract).create();
    }

    @Test
    public void testWithPenalty() throws Exception {
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        HotelProduct sellProduct = new HotelProduct();
        HotelProduct refundProduct = new HotelProduct();
        Traveller traveller = new Traveller();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String issueDateString = TestBookingFileBuilder.getDateFormat().format(issueDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller(traveller).end().reservation().hotelProduct(sellProduct).traveller(traveller).status(ProductStatus.SELL).room(2300.0).gdsCurrency("RUB").nextProduct(refundProduct).issueDate(issueDateString).updateFops().end().hotelProduct(refundProduct).traveller(traveller).status(ProductStatus.REFUND).room(2300.0).gdsCurrency("RUB").previousProduct(sellProduct).penalty(BigDecimal.valueOf(700L)).issueDate(issueDateString).updateFops().end().end().create();
        NestedEntityReference sellProductReference = new NestedEntityReference(bookingFileContainer, (BaseEntity)sellProduct);
        NestedEntityReference refundProductReference = new NestedEntityReference(bookingFileContainer, (BaseEntity)refundProduct);
        EntityContainer<Shipment> shipment = this.createShipment(Arrays.asList(sellProductReference, refundProductReference));
        List<BillingItem> billingItems = ((Shipment)shipment.getEntity()).getBillingItems().stream().map(EntityStorageHelper::resolve).collect(Collectors.toList());
        Assert.assertEquals((long)2L, (long)billingItems.size());
        BillingItem penaltyBillingItem = this.getBillingItem(billingItems, ServiceType.PENALTY);
        this.assertBigDecimals(BigDecimal.valueOf(700L), penaltyBillingItem.getAmount().getTotal());
        BillingItem feeBillingItem = this.getBillingItem(billingItems, ServiceType.FEE);
        this.assertBigDecimals(BigDecimal.valueOf(100L), feeBillingItem.getAmount().getTotal());
    }

    @Test
    public void testWithoutPenalty() throws Exception {
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        HotelProduct sellProduct = new HotelProduct();
        HotelProduct refundProduct = new HotelProduct();
        Traveller traveller = new Traveller();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String issueDateString = TestBookingFileBuilder.getDateFormat().format(issueDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller(traveller).end().reservation().hotelProduct(sellProduct).traveller(traveller).status(ProductStatus.SELL).room(2300.0).gdsCurrency("RUB").nextProduct(refundProduct).issueDate(issueDateString).updateFops().end().hotelProduct(refundProduct).traveller(traveller).status(ProductStatus.REFUND).room(2300.0).gdsCurrency("RUB").previousProduct(sellProduct).issueDate(issueDateString).updateFops().end().end().create();
        NestedEntityReference sellProductReference = new NestedEntityReference(bookingFileContainer, (BaseEntity)sellProduct);
        NestedEntityReference refundProductReference = new NestedEntityReference(bookingFileContainer, (BaseEntity)refundProduct);
        EntityContainer<Shipment> shipment = this.createShipment(Arrays.asList(sellProductReference, refundProductReference));
        List<BillingItem> billingItems = ((Shipment)shipment.getEntity()).getBillingItems().stream().map(EntityStorageHelper::resolve).collect(Collectors.toList());
        Assert.assertEquals((long)2L, (long)billingItems.size());
        BillingItem ticketBillingItem = this.getBillingItem(billingItems, ServiceType.TICKET);
        this.assertBigDecimals(BigDecimal.ZERO, ticketBillingItem.getAmount().getTotal());
        BillingItem feeBillingItem = this.getBillingItem(billingItems, ServiceType.FEE);
        this.assertBigDecimals(BigDecimal.valueOf(100L), feeBillingItem.getAmount().getTotal());
    }

    private EntityContainer<Shipment> createShipment(List<NestedEntityReference<BookingFile, BaseProduct>> products) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(IBusFinanceContextKeys.DATE.name(), new Date());
        context.put(IBusFinanceContextKeys.PRODUCT_REFERENCES.name(), products);
        context.put(IBusFinanceContextKeys.CONTRACT_TYPE.name(), ContractType.CLIENT);
        context.put(IBusFinanceContextKeys.FINANCE_DOCUMENTS_PREPAYMENT.name(), Boolean.FALSE);
        IntegrationBusFacade.get().processRouteSync("shipments:create", context);
        Collection shipments = (Collection)context.get(IBusFinanceContextKeys.SHIPMENT_REFERENCES.name());
        Assert.assertNotNull((Object)shipments);
        List shipmentsContainers = shipments.stream().map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)shipmentsContainers.size());
        return (EntityContainer)shipmentsContainers.get(0);
    }

    private BillingItem getBillingItem(List<BillingItem> billingItems, ServiceType type) {
        List result = billingItems.stream().filter(billingItem -> billingItem.getServiceType() == type).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)result.size());
        return (BillingItem)result.get(0);
    }

    private void assertBigDecimals(BigDecimal expected, BigDecimal actual) {
        Assert.assertTrue((String)String.format("expected: %s, actual: %s", expected, actual), (boolean)MiscUtil.equals((Object)expected, (Object)actual));
    }
}

