/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.shipments;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopComponentType;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.finance.FinanceTestBase;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.FopDetalizer;
import com.gridnine.xtrip.server.model.test.TestBillingItemsListBuilder;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestFinanceDocumentBuilder;
import com.gridnine.xtrip.server.model.test.TestShipmentBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;

public class ShipmentsProductsExcludeTest
extends FinanceTestBase {
    @Override
    @Before
    public void initialize() throws Exception {
        super.initialize();
        Environment.unpublish(FopDetalizer.class);
    }

    public void shipmentsProductExcludeTest01() throws Exception {
        EntityContainer shipmentContainer = EntityContainer.create((BaseEntity)new Shipment());
        EntityReference shipmentReference = shipmentContainer.toReference();
        EntityContainer financeDocumentContainer = EntityContainer.create((BaseEntity)new FinanceDocument());
        EntityReference financeDocumentReference = financeDocumentContainer.toReference();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Traveller traveller = new Traveller();
        Product product = new Product();
        FopComponent fopComponent01 = new FopComponent();
        FopComponent fopComponent02 = new FopComponent();
        ProductFop clientFop = new ProductFop();
        EntityContainer bookingFileContainer = bookingFileBuilder.reservation().airProduct(product, false).status(ProductStatus.SELL).systemNumber("0000000001").traveller(traveller).fopDetalization(clientFop).component(fopComponent01).type(FopComponentType.PRODUCT).traveller(traveller).amount(4510.0).vatAmount(410.0).vatRate(10.0).shipment(shipmentReference).end().component(fopComponent02).type(FopComponentType.PRODUCT).traveller(traveller).amount(3600.0).vatAmount(600.0).vatRate(20.0).shipment(shipmentReference).end().end().clientContractRelation().fop(clientFop).paymentType(PaymentType.CASH).amount(8110.0).end().end().end().end().create();
        EntityReference bookingFileReference = bookingFileContainer.toReference();
        NestedEntityReference productReference = new NestedEntityReference(bookingFileContainer, (BaseEntity)product);
        TestBillingItemsListBuilder billingItemsListBuilder = new TestBillingItemsListBuilder();
        BillingItem billingItem01 = new BillingItem();
        BillingItem billingItem02 = new BillingItem();
        EntityContainer billingItemsListContainer = ((TestBillingItemsListBuilder)((TestBillingItemsListBuilder)billingItemsListBuilder.billingItem(billingItem01).name("Billing item 01").serviceType(ServiceType.TICKET).amount(4510.0, 10.0).product(productReference).end()).billingItem(billingItem02).name("Billing item 02").serviceType(ServiceType.TICKET).amount(3600.0, 20.0).product(productReference).end()).create();
        EntityReference billingItemsListReference = billingItemsListContainer.toReference();
        NestedEntityReference billingItemReference01 = new NestedEntityReference(billingItemsListContainer, (BaseEntity)billingItem01);
        NestedEntityReference billingItemReference02 = new NestedEntityReference(billingItemsListContainer, (BaseEntity)billingItem02);
        TestShipmentBuilder shipmentBuilder = new TestShipmentBuilder(shipmentContainer);
        shipmentContainer = shipmentBuilder.number("0001").billingItem(billingItemReference01).billingItem(billingItemReference02).document(financeDocumentReference).create();
        TestFinanceDocumentBuilder financeDocumentBuilder = new TestFinanceDocumentBuilder(financeDocumentContainer);
        financeDocumentContainer = financeDocumentBuilder.number("000000001").type(FinanceDocumentType.ACCEPTANCE_CERTIFICATE).billingItem(billingItemReference01).billingItem(billingItemReference02).shipment(shipmentReference).create();
        HashMap<NestedEntityReference, List<EntityReference>> productBatches = new HashMap<NestedEntityReference, List<EntityReference>>();
        productBatches.put(productReference, Arrays.asList(shipmentReference));
        HashMap<String, HashMap<NestedEntityReference, List<EntityReference>>> data = new HashMap<String, HashMap<NestedEntityReference, List<EntityReference>>>();
        data.put(IBusFinanceContextKeys.PRODUCT_BATCHES.name(), productBatches);
        ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).processRouteSync("shipments:products-exclude", data);
        bookingFileContainer = EntityStorage.get().resolve(bookingFileReference);
        Assert.assertNotNull((Object)bookingFileContainer);
        List fopComponents = ((BookingFile)bookingFileContainer.getEntity()).getReservations().stream().flatMap(item -> item.getProducts().stream()).flatMap(item -> item.getFopDetalizations().values().stream()).flatMap(item -> item.getComponents().stream()).collect(Collectors.toList());
        Assert.assertEquals((long)2L, (long)fopComponents.size());
        Assert.assertNull((Object)((FopComponent)fopComponents.stream().filter(item -> MiscUtil.equals((Object)item, (Object)fopComponent01)).findFirst().orElse(null)).getShipment());
        Assert.assertNull((Object)((FopComponent)fopComponents.stream().filter(item -> MiscUtil.equals((Object)item, (Object)fopComponent02)).findFirst().orElse(null)).getShipment());
        billingItemsListContainer = EntityStorage.get().resolve(billingItemsListReference);
        Assert.assertNull((Object)billingItemsListContainer);
        shipmentContainer = EntityStorage.get().resolve(shipmentReference);
        Assert.assertNull((Object)shipmentContainer);
        financeDocumentContainer = EntityStorage.get().resolve(financeDocumentReference);
        Assert.assertNull((Object)financeDocumentContainer);
    }

    public void shipmentsProductExcludeTest02() throws Exception {
        EntityContainer shipmentContainer01 = EntityContainer.create((BaseEntity)new Shipment());
        EntityContainer shipmentContainer02 = EntityContainer.create((BaseEntity)new Shipment());
        EntityReference shipmentReference01 = shipmentContainer01.toReference();
        EntityReference shipmentReference02 = shipmentContainer02.toReference();
        EntityContainer financeDocumentContainer = EntityContainer.create((BaseEntity)new FinanceDocument());
        EntityReference financeDocumentReference = financeDocumentContainer.toReference();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Traveller traveller = new Traveller();
        Product product = new Product();
        FopComponent fopComponent01 = new FopComponent();
        FopComponent fopComponent02 = new FopComponent();
        FopComponent fopComponent03 = new FopComponent();
        ProductFop clientFop = new ProductFop();
        EntityContainer bookingFileContainer = bookingFileBuilder.reservation().airProduct(product, false).status(ProductStatus.SELL).systemNumber("0000000001").traveller(traveller).fopDetalization(clientFop).component(fopComponent01).type(FopComponentType.PRODUCT).traveller(traveller).amount(2400.0).vatAmount(400.0).vatRate(20.0).shipment(shipmentReference01).end().component(fopComponent02).type(FopComponentType.SERVICE).traveller(traveller).amount(3850.0).vatAmount(350.0).vatRate(10.0).shipment(shipmentReference02).end().component(fopComponent03).type(FopComponentType.TAXES).traveller(traveller).amount(2000.0).vatAmount(0.0).vatRate(0.0).shipment(shipmentReference02).end().end().clientContractRelation().fop(clientFop).paymentType(PaymentType.CREDIT_CARD).amount(8250.0).end().end().end().end().create();
        EntityReference bookingFileReference = bookingFileContainer.toReference();
        NestedEntityReference productReference = new NestedEntityReference(bookingFileContainer, (BaseEntity)product);
        TestBillingItemsListBuilder billingItemsListBuilder = new TestBillingItemsListBuilder();
        BillingItem billingItem01 = new BillingItem();
        BillingItem billingItem02 = new BillingItem();
        BillingItem billingItem03 = new BillingItem();
        EntityContainer billingItemsListContainer = ((TestBillingItemsListBuilder)((TestBillingItemsListBuilder)((TestBillingItemsListBuilder)billingItemsListBuilder.billingItem(billingItem01).name("Billing item 01").serviceType(ServiceType.TICKET).amount(2400.0, 20.0).product(productReference).end()).billingItem(billingItem02).name("Billing item 02").serviceType(ServiceType.TICKET).amount(3850.0, 10.0).product(productReference).end()).billingItem(billingItem03).name("Billing item 03").serviceType(ServiceType.TICKET).amount(2000.0, 0.0).product(productReference).end()).create();
        EntityReference billingItemsListReference = billingItemsListContainer.toReference();
        NestedEntityReference billingItemReference01 = new NestedEntityReference(billingItemsListContainer, (BaseEntity)billingItem01);
        NestedEntityReference billingItemReference02 = new NestedEntityReference(billingItemsListContainer, (BaseEntity)billingItem02);
        NestedEntityReference billingItemReference03 = new NestedEntityReference(billingItemsListContainer, (BaseEntity)billingItem03);
        TestShipmentBuilder shipmentBuilder01 = new TestShipmentBuilder(shipmentContainer01);
        shipmentContainer01 = shipmentBuilder01.number("0001").billingItem(billingItemReference01).document(financeDocumentReference).create();
        TestShipmentBuilder shipmentBuilder02 = new TestShipmentBuilder(shipmentContainer02);
        shipmentContainer02 = shipmentBuilder02.number("0002").billingItem(billingItemReference02).billingItem(billingItemReference03).document(financeDocumentReference).create();
        TestFinanceDocumentBuilder financeDocumentBuilder = new TestFinanceDocumentBuilder(financeDocumentContainer);
        financeDocumentContainer = financeDocumentBuilder.number("000000001").type(FinanceDocumentType.INVOICE).billingItem(billingItemReference01).billingItem(billingItemReference02).billingItem(billingItemReference03).shipment(shipmentReference01).shipment(shipmentReference02).create();
        HashMap<NestedEntityReference, List<EntityReference>> productBatches = new HashMap<NestedEntityReference, List<EntityReference>>();
        productBatches.put(productReference, Arrays.asList(shipmentReference01, shipmentReference02));
        HashMap<String, HashMap<NestedEntityReference, List<EntityReference>>> data = new HashMap<String, HashMap<NestedEntityReference, List<EntityReference>>>();
        data.put(IBusFinanceContextKeys.PRODUCT_BATCHES.name(), productBatches);
        ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).processRouteSync("shipments:products-exclude", data);
        bookingFileContainer = EntityStorage.get().resolve(bookingFileReference);
        Assert.assertNotNull((Object)bookingFileContainer);
        List fopComponents = ((BookingFile)bookingFileContainer.getEntity()).getReservations().stream().flatMap(item -> item.getProducts().stream()).flatMap(item -> item.getFopDetalizations().values().stream()).flatMap(item -> item.getComponents().stream()).collect(Collectors.toList());
        Assert.assertEquals((long)3L, (long)fopComponents.size());
        Assert.assertNull((Object)((FopComponent)fopComponents.stream().filter(item -> MiscUtil.equals((Object)item, (Object)fopComponent01)).findFirst().orElse(null)).getShipment());
        Assert.assertNull((Object)((FopComponent)fopComponents.stream().filter(item -> MiscUtil.equals((Object)item, (Object)fopComponent02)).findFirst().orElse(null)).getShipment());
        Assert.assertNull((Object)((FopComponent)fopComponents.stream().filter(item -> MiscUtil.equals((Object)item, (Object)fopComponent03)).findFirst().orElse(null)).getShipment());
        billingItemsListContainer = EntityStorage.get().resolve(billingItemsListReference);
        Assert.assertNull((Object)billingItemsListContainer);
        shipmentContainer01 = EntityStorage.get().resolve(shipmentReference01);
        Assert.assertNull((Object)shipmentContainer01);
        shipmentContainer02 = EntityStorage.get().resolve(shipmentReference02);
        Assert.assertNull((Object)shipmentContainer02);
        financeDocumentContainer = EntityStorage.get().resolve(financeDocumentReference);
        Assert.assertNull((Object)financeDocumentContainer);
    }

    public void shipmentsProductExcludeTest03() throws Exception {
        EntityContainer shipmentContainer01 = EntityContainer.create((BaseEntity)new Shipment());
        EntityContainer shipmentContainer02 = EntityContainer.create((BaseEntity)new Shipment());
        EntityReference shipmentReference01 = shipmentContainer01.toReference();
        EntityReference shipmentReference02 = shipmentContainer02.toReference();
        EntityContainer financeDocumentContainer01 = EntityContainer.create((BaseEntity)new FinanceDocument());
        EntityContainer financeDocumentContainer02 = EntityContainer.create((BaseEntity)new FinanceDocument());
        EntityReference financeDocumentReference01 = financeDocumentContainer01.toReference();
        EntityReference financeDocumentReference02 = financeDocumentContainer02.toReference();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Traveller traveller = new Traveller();
        Product product01 = new Product();
        Product product02 = new Product();
        FopComponent fopComponent01_01 = new FopComponent();
        FopComponent fopComponent02_01 = new FopComponent();
        FopComponent fopComponent01_02 = new FopComponent();
        ProductFop clientFop01_01 = new ProductFop();
        ProductFop clientFop01_02 = new ProductFop();
        EntityContainer bookingFileContainer = bookingFileBuilder.reservation().airProduct(product01, false).status(ProductStatus.SELL).systemNumber("0000000001").traveller(traveller).fopDetalization(clientFop01_01).component(fopComponent01_01).type(FopComponentType.PRODUCT).traveller(traveller).amount(8140.0).vatAmount(740.0).vatRate(10.0).shipment(shipmentReference01).end().component(fopComponent02_01).type(FopComponentType.PRODUCT).traveller(traveller).amount(1140.0).vatAmount(190.0).vatRate(20.0).shipment(shipmentReference01).end().end().clientContractRelation().fop(clientFop01_01).paymentType(PaymentType.CASH).amount(9280.0).end().end().end().airProduct(product02, false).status(ProductStatus.SELL).systemNumber("0000000002").traveller(traveller).fopDetalization(clientFop01_02).component(fopComponent01_02).type(FopComponentType.PRODUCT).traveller(traveller).amount(1320.0).vatAmount(120.0).vatRate(10.0).shipment(shipmentReference02).end().end().clientContractRelation().fop(clientFop01_02).paymentType(PaymentType.INVOICE).amount(1320.0).end().end().end().end().create();
        EntityReference bookingFileReference = bookingFileContainer.toReference();
        NestedEntityReference productReference01 = new NestedEntityReference(bookingFileContainer, (BaseEntity)product01);
        NestedEntityReference productReference02 = new NestedEntityReference(bookingFileContainer, (BaseEntity)product02);
        TestBillingItemsListBuilder billingItemsListBuilder01 = new TestBillingItemsListBuilder();
        BillingItem billingItem01_01 = new BillingItem();
        BillingItem billingItem02_01 = new BillingItem();
        EntityContainer billingItemsListContainer01 = ((TestBillingItemsListBuilder)((TestBillingItemsListBuilder)billingItemsListBuilder01.billingItem(billingItem01_01).name("Billing item 01").serviceType(ServiceType.TICKET).amount(8140.0, 10.0).product(productReference01).end()).billingItem(billingItem02_01).name("Billing item 02").serviceType(ServiceType.TICKET).amount(1140.0, 20.0).product(productReference01).end()).create();
        EntityReference billingItemsListReference01 = billingItemsListContainer01.toReference();
        NestedEntityReference billingItemReference01_01 = new NestedEntityReference(billingItemsListContainer01, (BaseEntity)billingItem01_01);
        NestedEntityReference billingItemReference02_01 = new NestedEntityReference(billingItemsListContainer01, (BaseEntity)billingItem02_01);
        TestBillingItemsListBuilder billingItemsListBuilder02 = new TestBillingItemsListBuilder();
        BillingItem billingItem01_02 = new BillingItem();
        EntityContainer billingItemsListContainer02 = ((TestBillingItemsListBuilder)billingItemsListBuilder02.billingItem(billingItem01_02).name("Billing item 01").serviceType(ServiceType.TICKET).amount(1320.0, 10.0).product(productReference02).end()).create();
        EntityReference billingItemsListReference02 = billingItemsListContainer02.toReference();
        NestedEntityReference billingItemReference01_02 = new NestedEntityReference(billingItemsListContainer02, (BaseEntity)billingItem01_02);
        TestShipmentBuilder shipmentBuilder01 = new TestShipmentBuilder(shipmentContainer01);
        shipmentContainer01 = shipmentBuilder01.number("0001").billingItem(billingItemReference01_01).billingItem(billingItemReference02_01).document(financeDocumentReference01).create();
        TestShipmentBuilder shipmentBuilder02 = new TestShipmentBuilder(shipmentContainer02);
        shipmentContainer02 = shipmentBuilder02.number("0002").billingItem(billingItemReference01_02).document(financeDocumentReference02).create();
        TestFinanceDocumentBuilder financeDocumentBuilder01 = new TestFinanceDocumentBuilder(financeDocumentContainer01);
        financeDocumentContainer01 = financeDocumentBuilder01.number("000000001").type(FinanceDocumentType.INTERNAL_BILL).billingItem(billingItemReference01_01).billingItem(billingItemReference02_01).shipment(shipmentReference01).create();
        TestFinanceDocumentBuilder financeDocumentBuilder02 = new TestFinanceDocumentBuilder(financeDocumentContainer02);
        financeDocumentContainer02 = financeDocumentBuilder02.number("000000002").type(FinanceDocumentType.ACCEPTANCE_CERTIFICATE).billingItem(billingItemReference01_02).shipment(shipmentReference02).create();
        HashMap<NestedEntityReference, List<EntityReference>> productBatches = new HashMap<NestedEntityReference, List<EntityReference>>();
        productBatches.put(productReference01, Arrays.asList(shipmentReference01));
        productBatches.put(productReference02, Arrays.asList(shipmentReference02));
        HashMap<String, HashMap<NestedEntityReference, List<EntityReference>>> data = new HashMap<String, HashMap<NestedEntityReference, List<EntityReference>>>();
        data.put(IBusFinanceContextKeys.PRODUCT_BATCHES.name(), productBatches);
        ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).processRouteSync("shipments:products-exclude", data);
        bookingFileContainer = EntityStorage.get().resolve(bookingFileReference);
        Assert.assertNotNull((Object)bookingFileContainer);
        List fopComponents = ((BookingFile)bookingFileContainer.getEntity()).getReservations().stream().flatMap(item -> item.getProducts().stream()).flatMap(item -> item.getFopDetalizations().values().stream()).flatMap(item -> item.getComponents().stream()).collect(Collectors.toList());
        Assert.assertEquals((long)3L, (long)fopComponents.size());
        Assert.assertNull((Object)((FopComponent)fopComponents.stream().filter(item -> MiscUtil.equals((Object)item, (Object)fopComponent01_01)).findFirst().orElse(null)).getShipment());
        Assert.assertNull((Object)((FopComponent)fopComponents.stream().filter(item -> MiscUtil.equals((Object)item, (Object)fopComponent02_01)).findFirst().orElse(null)).getShipment());
        Assert.assertNull((Object)((FopComponent)fopComponents.stream().filter(item -> MiscUtil.equals((Object)item, (Object)fopComponent01_02)).findFirst().orElse(null)).getShipment());
        billingItemsListContainer01 = EntityStorage.get().resolve(billingItemsListReference01);
        Assert.assertNull((Object)billingItemsListContainer01);
        billingItemsListContainer02 = EntityStorage.get().resolve(billingItemsListReference02);
        Assert.assertNull((Object)billingItemsListContainer02);
        shipmentContainer01 = EntityStorage.get().resolve(shipmentReference01);
        Assert.assertNull((Object)shipmentContainer01);
        shipmentContainer02 = EntityStorage.get().resolve(shipmentReference02);
        Assert.assertNull((Object)shipmentContainer02);
        financeDocumentContainer01 = EntityStorage.get().resolve(financeDocumentReference01);
        Assert.assertNull((Object)financeDocumentContainer01);
        financeDocumentContainer02 = EntityStorage.get().resolve(financeDocumentReference02);
        Assert.assertNull((Object)financeDocumentContainer02);
    }

    public void shipmentsProductExcludeTest04() throws Exception {
        EntityContainer shipmentContainer01 = EntityContainer.create((BaseEntity)new Shipment());
        EntityContainer shipmentContainer02 = EntityContainer.create((BaseEntity)new Shipment());
        EntityReference shipmentReference01 = shipmentContainer01.toReference();
        EntityReference shipmentReference02 = shipmentContainer02.toReference();
        EntityContainer financeDocumentContainer01 = EntityContainer.create((BaseEntity)new FinanceDocument());
        EntityContainer financeDocumentContainer02 = EntityContainer.create((BaseEntity)new FinanceDocument());
        EntityReference financeDocumentReference01 = financeDocumentContainer01.toReference();
        EntityReference financeDocumentReference02 = financeDocumentContainer02.toReference();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Traveller traveller = new Traveller();
        Product product = new Product();
        FopComponent fopComponent01 = new FopComponent();
        FopComponent fopComponent02 = new FopComponent();
        FopComponent fopComponent03 = new FopComponent();
        FopComponent fopComponent04 = new FopComponent();
        ProductFop clientFop01 = new ProductFop();
        ProductFop clientFop02 = new ProductFop();
        EntityContainer bookingFileContainer = bookingFileBuilder.reservation().airProduct(product, false).status(ProductStatus.SELL).systemNumber("0000000001").traveller(traveller).fopDetalization(clientFop01).component(fopComponent01).type(FopComponentType.PRODUCT).traveller(traveller).amount(4200.0).vatAmount(700.0).vatRate(20.0).shipment(shipmentReference01).end().component(fopComponent02).type(FopComponentType.PRODUCT).traveller(traveller).amount(2200.0).vatAmount(200.0).vatRate(10.0).shipment(shipmentReference01).end().component(fopComponent03).type(FopComponentType.PENALTY).traveller(traveller).amount(1000.0).vatAmount(0.0).vatRate(0.0).shipment(shipmentReference02).end().end().fopDetalization(clientFop02).component(fopComponent04).type(FopComponentType.PRODUCT).traveller(traveller).amount(4180.0).vatAmount(380.0).vatRate(10.0).shipment(shipmentReference01).end().end().clientContractRelation().fop(clientFop01).paymentType(PaymentType.CASH).amount(7400.0).end().fop(clientFop02).paymentType(PaymentType.INVOICE).amount(4180.0).end().end().end().end().create();
        EntityReference bookingFileReference = bookingFileContainer.toReference();
        NestedEntityReference productReference = new NestedEntityReference(bookingFileContainer, (BaseEntity)product);
        TestBillingItemsListBuilder billingItemsListBuilder = new TestBillingItemsListBuilder();
        BillingItem billingItem01 = new BillingItem();
        BillingItem billingItem02 = new BillingItem();
        BillingItem billingItem03 = new BillingItem();
        EntityContainer billingItemsListContainer = ((TestBillingItemsListBuilder)((TestBillingItemsListBuilder)((TestBillingItemsListBuilder)billingItemsListBuilder.billingItem(billingItem01).name("Billing item 01").serviceType(ServiceType.TICKET).amount(4200.0, 20.0).product(productReference).end()).billingItem(billingItem02).name("Billing item 02").serviceType(ServiceType.TICKET).amount(6380.0, 10.0).product(productReference).end()).billingItem(billingItem03).name("Billing item 03").serviceType(ServiceType.PENALTY).amount(1000.0, 0.0).product(productReference).end()).create();
        EntityReference billingItemsListReference = billingItemsListContainer.toReference();
        NestedEntityReference billingItemReference01 = new NestedEntityReference(billingItemsListContainer, (BaseEntity)billingItem01);
        NestedEntityReference billingItemReference02 = new NestedEntityReference(billingItemsListContainer, (BaseEntity)billingItem02);
        NestedEntityReference billingItemReference03 = new NestedEntityReference(billingItemsListContainer, (BaseEntity)billingItem03);
        TestShipmentBuilder shipmentBuilder01 = new TestShipmentBuilder(shipmentContainer01);
        shipmentContainer01 = shipmentBuilder01.number("0001").billingItem(billingItemReference01).billingItem(billingItemReference02).document(financeDocumentReference01).document(financeDocumentReference02).create();
        TestShipmentBuilder shipmentBuilder02 = new TestShipmentBuilder(shipmentContainer02);
        shipmentContainer02 = shipmentBuilder02.number("0002").billingItem(billingItemReference03).document(financeDocumentReference01).create();
        TestFinanceDocumentBuilder financeDocumentBuilder01 = new TestFinanceDocumentBuilder(financeDocumentContainer01);
        financeDocumentContainer01 = financeDocumentBuilder01.number("000000001").type(FinanceDocumentType.INVOICE).billingItem(billingItemReference01).billingItem(billingItemReference03).shipment(shipmentReference01).shipment(shipmentReference02).create();
        TestFinanceDocumentBuilder financeDocumentBuilder02 = new TestFinanceDocumentBuilder(financeDocumentContainer02);
        financeDocumentContainer02 = financeDocumentBuilder02.number("000000002").type(FinanceDocumentType.INVOICE_FACTURA).billingItem(billingItemReference02).shipment(shipmentReference01).create();
        HashMap<NestedEntityReference, List<EntityReference>> productBatches = new HashMap<NestedEntityReference, List<EntityReference>>();
        productBatches.put(productReference, Arrays.asList(shipmentReference01));
        HashMap<String, HashMap<NestedEntityReference, List<EntityReference>>> data = new HashMap<String, HashMap<NestedEntityReference, List<EntityReference>>>();
        data.put(IBusFinanceContextKeys.PRODUCT_BATCHES.name(), productBatches);
        ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).processRouteSync("shipments:products-exclude", data);
        bookingFileContainer = EntityStorage.get().resolve(bookingFileReference);
        Assert.assertNotNull((Object)bookingFileContainer);
        List fopComponents = ((BookingFile)bookingFileContainer.getEntity()).getReservations().stream().flatMap(item -> item.getProducts().stream()).flatMap(item -> item.getFopDetalizations().values().stream()).flatMap(item -> item.getComponents().stream()).collect(Collectors.toList());
        Assert.assertEquals((long)4L, (long)fopComponents.size());
        Assert.assertNull((Object)((FopComponent)fopComponents.stream().filter(item -> MiscUtil.equals((Object)item, (Object)fopComponent01)).findFirst().orElse(null)).getShipment());
        Assert.assertNull((Object)((FopComponent)fopComponents.stream().filter(item -> MiscUtil.equals((Object)item, (Object)fopComponent02)).findFirst().orElse(null)).getShipment());
        Assert.assertEquals((Object)shipmentReference02, (Object)((FopComponent)fopComponents.stream().filter(item -> MiscUtil.equals((Object)item, (Object)fopComponent03)).findFirst().orElse(null)).getShipment());
        Assert.assertNull((Object)((FopComponent)fopComponents.stream().filter(item -> MiscUtil.equals((Object)item, (Object)fopComponent04)).findFirst().orElse(null)).getShipment());
        billingItemsListContainer = EntityStorage.get().resolve(billingItemsListReference);
        Assert.assertNotNull((Object)billingItemsListContainer);
        Assert.assertEquals((long)1L, (long)((BillingItemsList)billingItemsListContainer.getEntity()).getData().size());
        Assert.assertTrue((boolean)((BillingItemsList)billingItemsListContainer.getEntity()).getData().contains(billingItem03));
        shipmentContainer01 = EntityStorage.get().resolve(shipmentReference01);
        Assert.assertNull((Object)shipmentContainer01);
        shipmentContainer02 = EntityStorage.get().resolve(shipmentReference02);
        Assert.assertNotNull((Object)shipmentContainer02);
        Assert.assertEquals((long)1L, (long)((Shipment)shipmentContainer02.getEntity()).getBillingItems().size());
        Assert.assertTrue((boolean)((Shipment)shipmentContainer02.getEntity()).getBillingItems().contains(billingItemReference03));
        Assert.assertEquals((long)1L, (long)((Shipment)shipmentContainer02.getEntity()).getFinanceDocuments().size());
        Assert.assertTrue((boolean)((Shipment)shipmentContainer02.getEntity()).getFinanceDocuments().contains(financeDocumentReference01));
        financeDocumentContainer01 = EntityStorage.get().resolve(financeDocumentReference01);
        Assert.assertNotNull((Object)financeDocumentContainer01);
        Assert.assertEquals((long)1L, (long)((FinanceDocument)financeDocumentContainer01.getEntity()).getBillingItems().size());
        Assert.assertTrue((boolean)((FinanceDocument)financeDocumentContainer01.getEntity()).getBillingItems().contains(billingItemReference03));
        Assert.assertEquals((long)1L, (long)((FinanceDocument)financeDocumentContainer01.getEntity()).getRelatedShipments().size());
        Assert.assertTrue((boolean)((FinanceDocument)financeDocumentContainer01.getEntity()).getRelatedShipments().contains(shipmentReference02));
        financeDocumentContainer02 = EntityStorage.get().resolve(financeDocumentReference02);
        Assert.assertNull((Object)financeDocumentContainer02);
    }
}

