/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.statistics;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.Publisher;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.Preference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.statistics.CollectStatisticsRequest;
import com.gridnine.xtrip.common.model.statistics.CollectStatisticsResponse;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.configuration.ServerConfiguration;
import com.gridnine.xtrip.server.licence.Address;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import com.gridnine.xtrip.server.storage.DictionaryStorage;

public class CollectStatisticsFlagPublisher
implements Publisher {
    public static String STATISTICS_USER = "stat-user";
    private static boolean collectStatistics = false;

    public void publish() throws Exception {
        CollectStatisticsFlagPublisher.updateCollectStatisticsFlag();
    }

    public static synchronized void updateCollectStatisticsFlag() throws Exception {
        String licenseKey = ((ServerConfiguration)Environment.getPublished(ServerConfiguration.class)).getConfiguration().getProperty("licenceKey");
        if (TextUtil.isBlank((String)licenseKey)) {
            collectStatistics = false;
            return;
        }
        CollectStatisticsRequest requestData = new CollectStatisticsRequest();
        SynchronizationRequest<CollectStatisticsRequest> request = new SynchronizationRequest<CollectStatisticsRequest>();
        request.setData(requestData);
        request.setClientId(Environment.getApplicationId());
        request.setOperationId(CollectStatisticsRequest.class.getSimpleName());
        request.setUser(STATISTICS_USER);
        requestData.setLicenseKey(licenseKey);
        SynchronizationResponse response = SynchronizationHelper.execute(request, Address.getSync(), null);
        boolean hasErrors = response.getMessages().stream().anyMatch(msg -> msg.getType() == MessageType.ERROR);
        if (hasErrors) {
            collectStatistics = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.COLLECT_STATISTICS, (boolean)false);
        } else {
            String value;
            collectStatistics = ((CollectStatisticsResponse)response.getData()).isCollectStatistics();
            Preference pref = DictHelper.getPreference((PreferenceKey)PreferenceKey.COLLECT_STATISTICS);
            if (pref == null) {
                pref = new Preference();
                pref.setKey(PreferenceKey.COLLECT_STATISTICS);
                pref.setCode(PreferenceKey.COLLECT_STATISTICS.name());
            }
            if (!(value = Boolean.toString(collectStatistics)).equals(pref.getValue())) {
                pref.setValue(value);
                pref.setDataSource("CollectStatisticsFlagPublisher");
                DictionaryStorage.get().save((BaseDictionary)pref);
            }
        }
    }

    public static boolean isCollectStatistics() {
        return collectStatistics;
    }
}

